/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.DataChunkInputStream;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import java.io.InputStream;
import java.util.concurrent.Flow;

class InputStreamBodyReader
implements MessageBodyReader<InputStream> {
    private static final InputStreamBodyReader DEFAULT = new InputStreamBodyReader();
    private static final GenericType<InputStream> INPUT_STREAM_TYPE = GenericType.create(InputStream.class);
    private static final GenericType<DataChunkInputStream> OLD_STREAM_TYPE = GenericType.create(DataChunkInputStream.class);

    private InputStreamBodyReader() {
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        if (INPUT_STREAM_TYPE.equals(type) || OLD_STREAM_TYPE.equals(type)) {
            return MessageBodyOperator.PredicateResult.SUPPORTED;
        }
        return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    @Override
    public <U extends InputStream> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return Single.just((Object)new DataChunkInputStream(publisher, true));
    }

    static InputStreamBodyReader create() {
        return DEFAULT;
    }
}

