-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Spectre active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AxisCasterGlacialCascade"] = {
	name = "Glacial Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5750000476837,
	incrementalEffectiveness = 0.025000000372529,
	description = "Icicles emerge from the ground in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 6 },
		{ "active_skill_area_of_effect_radius_+%_final", -34 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.25999999046326, 0.40000000596046, 0.47999998927116, 0.73000001907349, critChance = 6, damageEffectiveness = 0.8, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, }, },
		[2] = { 0.25999999046326, 0.40000000596046, 0.47999998927116, 0.73000001907349, critChance = 6, damageEffectiveness = 0.8, levelRequirement = 75, statInterpolation = { 3, 3, 3, 3, }, },
	},
}
skills["AxisDoubleStrikeTrigger"] = {
	name = "Double Strike",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Performs two fast strikes with a melee weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	constantStats = {
		{ "base_skill_number_of_additional_hits", 1 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 2, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BanditExplosiveArrowAtAnimationSpeed"] = {
	name = "Explosive Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.866700053215,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arrow which acts as a short duration fuse. Applying additional arrows to an enemy extends the duration. When the target dies or the fuses expire, the arrows explode, dealing fire AoE damage to nearby enemies. The AoE radius is proportional to the number of arrows upon death.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["minimum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMin", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["maximum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMax", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		cast = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 1, 0, 0),
	},
	constantStats = {
		{ "base_skill_effect_duration", 1000 },
		{ "fuse_arrow_explosion_radius_+_per_fuse_arrow_orb", 2 },
	},
	stats = {
		"minimum_fire_damage_per_fuse_arrow_orb",
		"maximum_fire_damage_per_fuse_arrow_orb",
		"action_attack_or_cast_time_uses_animation_length",
		"skill_can_fire_arrows",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 2, statInterpolation = { 3, 3, }, },
	},
}
skills["BanditChampionBlastRainSpectre"] = {
	name = "Blast Rain",
	hidden = true,
	color = 2,
	description = "Fires arrows up in the air, to rain down in an area. Each arrow deals area damage around where it lands, and they will all overlap on the targeted location.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Fire] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("dpsMultiplier", 4),
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "number_of_additional_arrows", 4 },
		{ "blast_rain_arrow_delay_ms", 80 },
		{ "active_skill_area_of_effect_radius_+%_final", -21 },
	},
	stats = {
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { baseMultiplier = 0.3125, levelRequirement = 15, },
	},
}
skills["GABeastCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.475, cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BirdmanBloodProjectileMortar"] = {
	name = "Blood Projectile",
	hidden = true,
	color = 4,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "skill_repeat_count", 2 },
		{ "active_skill_damage_+%_final", 10 },
		{ "projectile_spread_radius", 15 },
		{ "main_hand_base_maximum_attack_distance", 40 },
		{ "attack_speed_+%", 100 },
	},
	stats = {
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { baseMultiplier = 1.15, levelRequirement = 1, },
	},
}
skills["BirdmanConsumeCorpse"] = {
	name = "Consume Corpse",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.67,
	baseFlags = {
		spell = true,
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["BoneStalkerEarthquake"] = {
	name = "Earthquake",
	hidden = true,
	color = 1,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 1800 },
		{ "quake_slam_fully_charged_explosion_damage_+%_final", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", -20 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { cooldown = 5, damageEffectiveness = 0.5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BreachCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["active_skill_merged_damage_+%_final_while_dual_wielding"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Condition", var = "DualWielding" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_merged_damage_+%_final_while_dual_wielding", -40 },
		{ "physical_damage_+%", 29 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -20 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "melee_range_+", 4 },
	},
	stats = {
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, levelRequirement = 1, },
	},
}
skills["BullCharge"] = {
	name = "Charge",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.75,
	baseFlags = {
		attack = true,
		melee = true,
	},
	stats = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { cooldown = 4, levelRequirement = 2, storedUses = 1, },
		[2] = { 15, cooldown = 4, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["CageSpiderCycloneTriggerSandstorms"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", 150 },
		{ "active_skill_damage_+%_final", -60 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -40 },
		{ "cyclone_extra_distance", 40 },
	},
	stats = {
		"is_area_damage",
		"cyclone_has_triggered_skill",
	},
	levels = {
		[1] = { levelRequirement = 2, },
	},
}
skills["CageSpiderSandSpark"] = {
	name = "Sandstorm",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.64999997615814,
	incrementalEffectiveness = 0.031399998813868,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "base_projectile_speed_+%", -11 },
		{ "cast_on_cyclone_contact_%", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 61, statInterpolation = { 3, 3, }, },
	},
}
skills["ChaosDegenAura"] = {
	name = "Chaos Aura",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.93330001831055,
	incrementalEffectiveness = 0.036499999463558,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.HasReservation] = true, [SkillType.DamageOverTime] = true, [SkillType.Aura] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, levelRequirement = 3, statInterpolation = { 3, }, },
	},
}
skills["DelayedBlastSpectre"] = {
	name = "Delayed Blast",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.77999997138977,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 1.3, levelRequirement = 3, storedUses = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["DelveProtovaalWhirlingCharge"] = {
	name = "Whirling Charge",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", 100 },
		{ "combo_attack_first_hit_damage_+%_final", 150 },
		{ "active_skill_area_of_effect_radius_+%_final", -30 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.56, cooldown = 10, levelRequirement = 1, storedUses = 1, },
	},
}
skills["DemonFemaleRangedProjectile"] = {
	name = "Ranged Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesNotFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -60 },
		{ "active_skill_damage_+%_final", -60 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 30 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { levelRequirement = 30, },
	},
}
skills["DemonFemaleRangedProjectile2"] = {
	name = "Ranged Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesNotFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -60 },
		{ "active_skill_damage_+%_final", -60 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 30 },
		{ "monster_projectile_variation", 1 },
	},
	stats = {
		"base_is_projectile",
		"cannot_freeze_shock_ignite_on_critical",
	},
	levels = {
		[1] = { levelRequirement = 60, },
	},
}
skills["DemonModularBladeVortexSpectre"] = {
	name = "Blade Vortex",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.59500002861023,
	incrementalEffectiveness = 0.035999998450279,
	description = "An ethereal blade spins around you for a duration, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("hitTimeOverride", 1),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "maximum_number_of_spinning_blades", 5 },
		{ "skill_repeat_count", 2 },
		{ "active_skill_area_of_effect_radius_+%_final", 20 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["ElementalHitSkeletonKnight"] = {
	name = "Elemental Hit Fire",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.1667000055313,
	incrementalEffectiveness = 0.04280000180006,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.RandomElement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	baseMods = {
		flag("DealNoPhysical"),
		flag("DealNoChaos"),
		flag("DealNoCold"),
		flag("DealNoLightning"),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Scorched" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Brittle" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Sapped" }),
		mod("Damage", "MORE", 10, 0, 0, { type = "Multiplier", var = "ElementalHitAilmentOnEnemy" }),
	},
	constantStats = {
		{ "chance_to_freeze_shock_ignite_%", 50 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, levelRequirement = 1, },
		[3] = { baseMultiplier = 1.5, levelRequirement = 45, },
		[4] = { baseMultiplier = 1.5, levelRequirement = 84, },
	},
}
skills["ElementalHitSkeletonKnightIncursion"] = {
	name = "Elemental Hit",
	hidden = true,
	color = 2,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.RandomElement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "chance_to_freeze_shock_ignite_%", 25 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, levelRequirement = 1, },
		[3] = { baseMultiplier = 1.5, levelRequirement = 45, },
		[4] = { baseMultiplier = 1.5, levelRequirement = 84, },
	},
}
skills["ExperimenterDetonateDead"] = {
	name = "Detonate Dead",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5111000537872,
	incrementalEffectiveness = 0.014299999922514,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		cast = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -70 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "active_skill_area_of_effect_radius_+%_final", 2 },
	},
	stats = {
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"corpse_explosion_monster_life_%",
		"is_area_damage",
	},
	notMinionStat = {
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 7, critChance = 5, levelRequirement = 3, statInterpolation = { 3, 3, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 5, critChance = 5, levelRequirement = 33, statInterpolation = { 3, 3, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 4, critChance = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["FireballIncursionChaos"] = {
	name = "Chaos Ball",
	hidden = true,
	color = 3,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.025000000372529,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -40 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["FireballIncusionFire"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.97219997644424,
	incrementalEffectiveness = 0.050000000745058,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -40 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["FireballIncusionLightning"] = {
	name = "Lightning Ball",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.0937999486923,
	incrementalEffectiveness = 0.050000000745058,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -40 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["FireMonsterWhirlingBlades"] = {
	name = "Fire Roll",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.0888999700546,
	incrementalEffectiveness = 0.064599998295307,
	description = "Dive through enemies, dealing weapon damage. If dual wielding attacks with both weapons, dealing the damage of both in one hit. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.43,
	statMap = {
		["whirling_blades_base_ground_fire_damage_to_deal_per_minute"] = {
			skill("FireDot", nil),
			div = 60,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "attack_speed_+%", -50 },
		{ "monster_flurry", 1 },
	},
	stats = {
		"whirling_blades_base_ground_fire_damage_to_deal_per_minute",
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { 16.666667039196, levelRequirement = 3, statInterpolation = { 3, }, },
	},
}
skills["FlamebearerFlameBlue"] = {
	name = "Blue Flame",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.17000000178814,
	incrementalEffectiveness = 0.041000001132488,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 8,
	castTime = 0.25,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "skill_repeat_count", 9 },
		{ "active_skill_cast_speed_+%_final", 25 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -78, cooldown = 4, damageEffectiveness = 0.25, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, -75, cooldown = 4, damageEffectiveness = 0.25, levelRequirement = 8, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[3] = { 1.2400000095367, 1.8600000143051, -75, cooldown = 4, damageEffectiveness = 0.25, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["GhostPirateBladeVortexSpectre"] = {
	name = "Blade Vortex",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.59500002861023,
	incrementalEffectiveness = 0.035999998450279,
	description = "An ethereal blade spins around you for a duration, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("hitTimeOverride", 1),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "maximum_number_of_spinning_blades", 5 },
		{ "skill_repeat_count", 2 },
		{ "active_skill_area_of_effect_radius_+%_final", 20 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["GoatmanEarthquake"] = {
	name = "Earthquake",
	hidden = true,
	color = 1,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 1800 },
		{ "quake_slam_fully_charged_explosion_damage_+%_final", 25 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 13, cooldown = 2.75, damageEffectiveness = 0.5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["GoatmanFireMagmaOrb"] = {
	name = "Magma Orb",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.7778000831604,
	incrementalEffectiveness = 0.035999998450279,
	description = "Lob a fiery orb that deals area damage as it hits the ground. The skill chains, bouncing forward to deal damage multiple times.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Multicastable] = true, [SkillType.Chains] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
		chaining = true,
	},
	constantStats = {
		{ "base_cast_speed_+%", 30 },
		{ "number_of_chains", 2 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 3, critChance = 5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 1.3799999952316, 1.8400000333786, cooldown = 3, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GoatmanMoltenShell"] = {
	name = "Molten Shell",
	hidden = true,
	color = 1,
	baseEffectiveness = 5.3499999046326,
	incrementalEffectiveness = 0.037999998778105,
	description = "Summons fiery elemental shields providing additional armour for a short duration. If cumulative physical damage prevented by your blocking or armour reaches a threshold, the shields explode outwards, dealing fire damage to surrounding enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsWhenNotDetached] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 54 },
		{ "molten_shell_expire_after_x_hits", 1 },
		{ "base_skill_effect_duration", 5000 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"fire_shield_damage_threshold",
		"base_physical_damage_reduction_rating",
		"is_area_damage",
		"always_ignite",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 20, 335, cooldown = 7.5, critChance = 5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 25, 649, cooldown = 7.5, critChance = 5, levelRequirement = 5, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, 36, 1000, cooldown = 7.5, critChance = 5, levelRequirement = 8, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, 49, 1633, cooldown = 7.5, critChance = 5, levelRequirement = 12, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, 64, 2075, cooldown = 7.5, critChance = 5, levelRequirement = 15, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, 91, 2573, cooldown = 7.5, critChance = 5, levelRequirement = 19, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, 116, 3094, cooldown = 7.5, critChance = 5, levelRequirement = 22, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, 160, 3641, cooldown = 7.5, critChance = 5, levelRequirement = 26, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, 209, 4352, cooldown = 7.5, critChance = 5, levelRequirement = 30, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, 315, 5313, cooldown = 7.5, critChance = 5, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, 374, 5890, cooldown = 7.5, critChance = 5, levelRequirement = 39, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, 377, 6189, cooldown = 7.5, critChance = 5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, 565, 7030, cooldown = 7.5, critChance = 5, levelRequirement = 45, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, 752, 7870, cooldown = 7.5, critChance = 5, levelRequirement = 50, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, 1194, 9159, cooldown = 7.5, critChance = 5, levelRequirement = 57, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, 1403, 9867, cooldown = 7.5, critChance = 5, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, 2091, 11090, cooldown = 7.5, critChance = 5, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, 2211, 11524, cooldown = 7.5, critChance = 5, levelRequirement = 67, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, 2334, 11966, cooldown = 7.5, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 2456, 12428, cooldown = 7.5, critChance = 5, levelRequirement = 69, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 2579, 12894, cooldown = 7.5, critChance = 5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 2746, 13369, cooldown = 7.5, critChance = 5, levelRequirement = 71, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 2912, 13857, cooldown = 7.5, critChance = 5, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 3074, 14358, cooldown = 7.5, critChance = 5, levelRequirement = 73, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 3237, 14875, cooldown = 7.5, critChance = 5, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 3397, 15397, cooldown = 7.5, critChance = 5, levelRequirement = 75, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 3552, 15931, cooldown = 7.5, critChance = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 3703, 16480, cooldown = 7.5, critChance = 5, levelRequirement = 77, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 3847, 17039, cooldown = 7.5, critChance = 5, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 3981, 17613, cooldown = 7.5, critChance = 5, levelRequirement = 79, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 4110, 18195, cooldown = 7.5, critChance = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 4230, 18790, cooldown = 7.5, critChance = 5, levelRequirement = 81, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 4334, 19399, cooldown = 7.5, critChance = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, 1, 1, }, },
	},
}
skills["GoatmanMonsterSlam"] = {
	name = "Slam",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -20 },
		{ "active_skill_area_of_effect_radius_+%_final", 200 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.75, cooldown = 6, damageEffectiveness = 1.75, levelRequirement = 1, storedUses = 1, },
	},
}
skills["GroundEffectsSlamDockworkerChampion"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.7272999286652,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -40 },
		{ "base_skill_effect_duration", 4000 },
		{ "active_skill_area_of_effect_radius_+%_final", -50 },
	},
	stats = {
		"base_cold_damage_to_deal_per_minute",
		"is_area_damage",
	},
	levels = {
		[1] = { 58.333334637185, baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 2.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["GuardianArc"] = {
	name = "Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.029999999329448,
	description = "An arc of lightning reaches from the caster to a targeted enemy and chains to other enemies, but not immediately back. Each time the arc chains, it will also chain a secondary arc to another enemy that the main arc has not already hit, which cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		chaining = true,
	},
	constantStats = {
		{ "base_chance_to_shock_%", 5 },
		{ "active_skill_cast_speed_+%_final", -80 },
		{ "spell_maximum_action_distance_+%", -50 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 2, statInterpolation = { 3, 3, }, },
		[2] = { 0.60000002384186, 1.7999999523163, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 70, statInterpolation = { 3, 3, }, },
	},
}
skills["HalfSkeletonPuncture"] = {
	name = "Puncture",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Punctures enemies, causing a bleeding debuff, which will be affected by modifiers to skill duration. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	constantStats = {
		{ "active_skill_bleeding_damage_+%_final", 57 },
		{ "melee_range_+", 20 },
	},
	stats = {
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { baseMultiplier = 1.2, cooldown = 7.5, levelRequirement = 2, storedUses = 1, },
		[2] = { baseMultiplier = 1.2, cooldown = 7.5, levelRequirement = 14, storedUses = 1, },
	},
}
skills["HolyFireElementalFireball"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.1888999938965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.75, 2.710000038147, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["IguanaProjectile"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 4 },
		{ "spell_maximum_action_distance_+%", -60 },
		{ "active_skill_damage_+%_final", -60 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 30 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { cooldown = 3.5, levelRequirement = 1, storedUses = 3, },
	},
}
skills["IguanaProjectileChrome"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 24 },
		{ "spell_maximum_action_distance_+%", -60 },
		{ "active_skill_damage_+%_final", -30 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 30 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, cooldown = 3.5, levelRequirement = 1, storedUses = 3, },
	},
}
skills["IncaMinionProjectile"] = {
	name = "Chaos Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3600000143051,
	incrementalEffectiveness = 0.018999999389052,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_range_+%", -75 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_damage_+%_final",
		"visual_hit_effect_chaos_is_green",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 0.27000001072884, 0.40000000596046, 0.40000000596046, 0.60000002384186, 60, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, 2, }, },
		[2] = { 0.27000001072884, 0.40000000596046, 0.40000000596046, 0.60000002384186, 40, critChance = 5, levelRequirement = 21, statInterpolation = { 3, 3, 3, 3, 2, }, },
		[3] = { 0.6700000166893, 1.0099999904633, 1.0099999904633, 1.5199999809265, 0, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 2, }, },
	},
}
skills["IncursionLeapSlamChampion"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["IncursionMeteorUpheaval"] = {
	name = "Chaos Spikes",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.02250000089407,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 8 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 30 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["InsectSpawnerSpit"] = {
	name = "Spit",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.93999999761581,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 30 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.18000000715256, 0.27000001072884, 0.60000002384186, 0.75, levelRequirement = 2, statInterpolation = { 3, 3, 3, 3, }, },
	},
}
skills["KaomFireBeamTotemSpectre"] = {
	name = "Scorching Ray Totem",
	hidden = true,
	color = 3,
	baseEffectiveness = 3.039999961853,
	incrementalEffectiveness = 0.047400001436472,
	description = "Unleash a beam of fire that burns enemies it touches. Remaining in the beam raises the burning, adding a portion of the beam's damage in stages. Inflicts Fire Exposure at maximum stages. Enemies who leave the beam continue to burn for a duration. Increasing cast speed also increases the rate at which the beam turns.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.CausesBurning] = true, [SkillType.Duration] = true, [SkillType.Channel] = true, [SkillType.DegenOnlySpellDamage] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["fire_beam_enemy_fire_resistance_%_per_stack"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectStackVar = "KaomFireBeamTotemStage", effectStackLimit = 24 }),
		},
	},
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	baseMods = {
		mod("Damage", "MORE", 60, 0, 0, { type = "Multiplier", actor = "parent", var = "KaomFireBeamTotemStage", base = -60, limit = 8 }),
	},
	constantStats = {
		{ "totem_damage_+%_final_per_active_totem", -12 },
		{ "fire_beam_additional_stack_damage_+%_final", -40 },
		{ "base_fire_damage_resistance_%", -25 },
		{ "base_totem_duration", 5000 },
		{ "totem_art_variation", 1 },
		{ "base_skill_effect_duration", 1500 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"base_active_skill_totem_level",
		"is_totem",
		"base_skill_is_totemified",
		"totem_ignores_cooldown",
		"ignores_totem_cooldown_limit",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
		"base_active_skill_totem_level",
	},
	levels = {
		[1] = { 16.666667039196, 1, cooldown = 3, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 2, }, },
		[2] = { 16.666667039196, 83, cooldown = 3, levelRequirement = 83, storedUses = 1, statInterpolation = { 3, 2, }, },
	},
}
skills["KaomWarriorGroundSlam"] = {
	name = "Ground Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "base_stun_threshold_reduction_+%", 10 },
		{ "active_skill_damage_+%_final", 20 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { cooldown = 5, levelRequirement = 2, storedUses = 1, },
	},
}
skills["KaomWarriorMoltenStrike"] = {
	name = "Molten Strike",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.69999998807907,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will deal area attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "number_of_additional_projectiles", 5 },
		{ "active_skill_damage_+%_final", -20 },
		{ "active_skill_projectile_damage_+%_final", -20 },
		{ "base_projectile_speed_+%", -25 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.55, cooldown = 3, levelRequirement = 2, storedUses = 1, },
	},
}
skills["KitavaDemonLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "physical_damage_%_to_add_as_fire", 50 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.2, cooldown = 5, damageEffectiveness = 1.2, levelRequirement = 1, storedUses = 1, },
	},
}
skills["KitavaDemonCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "bleed_on_hit_with_attacks_%", 100 },
		{ "active_skill_bleeding_damage_+%_final", -44 },
		{ "active_skill_attack_speed_+%_final", -25 },
	},
	stats = {
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { baseMultiplier = 1.9, cooldown = 6, damageEffectiveness = 1.9, levelRequirement = 1, storedUses = 1, },
	},
}
skills["KitavaDemonWhirlingBlades"] = {
	name = "Whirling Blades",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.666699886322,
	incrementalEffectiveness = 0.0625,
	description = "Dive through enemies, dealing weapon damage. If dual wielding attacks with both weapons, dealing the damage of both in one hit. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.859,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "monster_flurry", 1 },
	},
	stats = {
		"whirling_blades_base_ground_fire_damage_to_deal_per_minute",
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { 16.666667039196, baseMultiplier = 0.6, cooldown = 6, damageEffectiveness = 0.6, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
		[2] = { 16.666667039196, baseMultiplier = 0.6, cooldown = 6, damageEffectiveness = 0.6, levelRequirement = 45, storedUses = 1, statInterpolation = { 3, }, },
		[3] = { 16.666667039196, baseMultiplier = 0.6, cooldown = 6, damageEffectiveness = 0.6, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, }, },
		[4] = { 16.666667039196, baseMultiplier = 0.6, cooldown = 6, damageEffectiveness = 0.6, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["KitavaDemonXMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 2 },
		{ "spell_maximum_action_distance_+%", 500 },
		{ "projectile_minimum_range", 10 },
		{ "projectile_spread_radius_per_additional_projectile", 125 },
		{ "active_skill_area_of_effect_radius_+%_final", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 3, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.54000002145767, 0.80000001192093, cooldown = 3, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MassFrenzy"] = {
	name = "Mass Frenzy",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 0, storedUses = 1, },
	},
}
skills["MassPower"] = {
	name = "Mass Power",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 0, storedUses = 1, },
	},
}
skills["MinerThrowFireSpectre"] = {
	name = "Throw Fire",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2777999639511,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
		duration = true,
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
		"base_is_projectile",
		"is_area_damage",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2000, cooldown = 1.5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[2] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2100, cooldown = 1.5, levelRequirement = 5, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[3] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2200, cooldown = 1.5, levelRequirement = 8, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[4] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2300, cooldown = 1.5, levelRequirement = 11, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[5] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2400, cooldown = 1.5, levelRequirement = 15, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[6] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2500, cooldown = 1.5, levelRequirement = 19, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[7] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2600, cooldown = 1.5, levelRequirement = 23, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[8] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2700, cooldown = 1.5, levelRequirement = 27, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[9] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2800, cooldown = 1.5, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[10] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 2900, cooldown = 1.5, levelRequirement = 32, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[11] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 3000, cooldown = 1.5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
		[12] = { 26.666667660077, 0.20000000298023, 0.30000001192093, 4000, cooldown = 1.5, levelRequirement = 79, storedUses = 1, statInterpolation = { 3, 3, 3, 1, }, },
	},
}
skills["MonsterArc"] = {
	name = "Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.046000000089407,
	description = "An arc of lightning reaches from the caster to a targeted enemy and chains to other enemies, but not immediately back. Each time the arc chains, it will also chain a secondary arc to another enemy that the main arc has not already hit, which cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		chaining = true,
	},
	constantStats = {
		{ "base_chance_to_shock_%", 10 },
		{ "number_of_chains", 1 },
		{ "skill_range_+%", -50 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 3, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
		[2] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 8, statInterpolation = { 3, 3, }, cost = { Mana = 19, }, },
		[3] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 12, statInterpolation = { 3, 3, }, cost = { Mana = 18, }, },
		[4] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 25, statInterpolation = { 3, 3, }, cost = { Mana = 17, }, },
		[5] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 32, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
		[6] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 16, }, },
	},
}
skills["MonsterCausticArrow"] = {
	name = "Caustic Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0666999816895,
	incrementalEffectiveness = 0.03999999910593,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "physical_damage_%_to_add_as_chaos", 34 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "ground_caustic_art_variation", 2 },
		{ "active_skill_area_of_effect_radius_+%_final", -33 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"base_skill_effect_duration",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
		"skill_can_fire_arrows",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 16.666667039196, 1200, levelRequirement = 3, statInterpolation = { 3, 1, }, cost = { Mana = 10, }, },
		[2] = { 16.666667039196, 1200, levelRequirement = 12, statInterpolation = { 3, 1, }, cost = { Mana = 9, }, },
		[3] = { 16.666667039196, 1200, levelRequirement = 26, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[4] = { 16.666667039196, 1200, levelRequirement = 67, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[5] = { 23.33333345751, 2400, levelRequirement = 68, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[6] = { 23.33333345751, 2500, levelRequirement = 69, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[7] = { 23.33333345751, 2600, levelRequirement = 70, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[8] = { 23.33333345751, 2700, levelRequirement = 71, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[9] = { 23.33333345751, 2800, levelRequirement = 72, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[10] = { 23.33333345751, 2900, levelRequirement = 73, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
		[11] = { 23.33333345751, 3000, levelRequirement = 74, statInterpolation = { 3, 1, }, cost = { Mana = 8, }, },
	},
}
skills["MonsterCausticArrowAtAnimationSpeed"] = {
	name = "Caustic Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0666999816895,
	incrementalEffectiveness = 0.03999999910593,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 2250 },
		{ "physical_damage_%_to_add_as_chaos", 34 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "ground_caustic_art_variation", 2 },
		{ "active_skill_area_of_effect_radius_+%_final", -15 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
		"action_attack_or_cast_time_uses_animation_length",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 25.000000558794, levelRequirement = 3, statInterpolation = { 3, }, },
		[2] = { 25.000000558794, levelRequirement = 68, statInterpolation = { 3, }, },
	},
}
skills["MonsterCausticBomb"] = {
	name = "Caustic Bomb",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2667000293732,
	incrementalEffectiveness = 0.038499999791384,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_trap_duration", 2500 },
		{ "base_skill_effect_duration", 4000 },
		{ "trap_variation", 2 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "ground_caustic_art_variation", 2 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"base_chaos_damage_to_deal_per_minute",
		"is_trap",
		"is_area_damage",
		"base_skill_is_trapped",
		"ignores_trap_and_mine_cooldown_limit",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
		[2] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 7, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
		[3] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 12, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
		[4] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
		[5] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
		[6] = { 0.30000001192093, 0.40000000596046, 16.666667039196, cooldown = 4, critChance = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
	},
}
skills["MonsterDischarge"] = {
	name = "Discharge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.2111001014709,
	incrementalEffectiveness = 0.028500000014901,
	description = "Discharge all the character's charges to deal elemental damage to all nearby monsters.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -75 },
		{ "active_skill_base_area_of_effect_radius", 25 },
	},
	stats = {
		"spell_minimum_base_lightning_damage_per_removable_power_charge",
		"spell_maximum_base_lightning_damage_per_removable_power_charge",
		"spell_minimum_base_fire_damage_per_removable_endurance_charge",
		"spell_maximum_base_fire_damage_per_removable_endurance_charge",
		"spell_minimum_base_cold_damage_per_removable_frenzy_charge",
		"spell_maximum_base_cold_damage_per_removable_frenzy_charge",
		"is_area_damage",
		"disable_skill_repeats",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage_per_removable_power_charge",
		"spell_maximum_base_lightning_damage_per_removable_power_charge",
		"spell_minimum_base_fire_damage_per_removable_endurance_charge",
		"spell_maximum_base_fire_damage_per_removable_endurance_charge",
		"spell_minimum_base_cold_damage_per_removable_frenzy_charge",
		"spell_maximum_base_cold_damage_per_removable_frenzy_charge",
	},
	levels = {
		[1] = { 0.56000000238419, 1.6900000572205, 0.80000001192093, 1.2000000476837, 0.64999997615814, 0.98000001907349, critChance = 4, damageEffectiveness = 1.5, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, 3, 3, }, },
		[2] = { 0.62000000476837, 1.8500000238419, 0.87999999523163, 1.3200000524521, 0.72000002861023, 1.0800000429153, critChance = 4, damageEffectiveness = 1.5, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, }, },
	},
}
skills["MonsterEnduringCry"] = {
	name = "Enduring Cry",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "Performs a warcry, taunting all nearby enemies to attack the user and granting a buff to the user and nearby allies. The user and allied players also gain endurance charges.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "enduring_cry_grants_x_additional_endurance_charges", 2 },
		{ "base_skill_effect_duration", 1000 },
		{ "life_regeneration_rate_per_minute_%", 600 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 4, storedUses = 1, },
		[2] = { cooldown = 8, levelRequirement = 7, storedUses = 1, },
		[3] = { cooldown = 8, levelRequirement = 10, storedUses = 1, },
		[4] = { cooldown = 8, levelRequirement = 14, storedUses = 1, },
		[5] = { cooldown = 8, levelRequirement = 18, storedUses = 1, },
		[6] = { cooldown = 8, levelRequirement = 22, storedUses = 1, },
		[7] = { cooldown = 8, levelRequirement = 24, storedUses = 1, },
		[8] = { cooldown = 8, levelRequirement = 28, storedUses = 1, },
		[9] = { cooldown = 8, levelRequirement = 32, storedUses = 1, },
		[10] = { cooldown = 8, levelRequirement = 36, storedUses = 1, },
		[11] = { cooldown = 8, levelRequirement = 40, storedUses = 1, },
		[12] = { cooldown = 8, levelRequirement = 44, storedUses = 1, },
		[13] = { cooldown = 8, levelRequirement = 48, storedUses = 1, },
		[14] = { cooldown = 8, levelRequirement = 52, storedUses = 1, },
		[15] = { cooldown = 8, levelRequirement = 56, storedUses = 1, },
		[16] = { cooldown = 8, levelRequirement = 60, storedUses = 1, },
		[17] = { cooldown = 8, levelRequirement = 63, storedUses = 1, },
		[18] = { cooldown = 8, levelRequirement = 66, storedUses = 1, },
		[19] = { cooldown = 8, levelRequirement = 67, storedUses = 1, },
		[20] = { cooldown = 8, levelRequirement = 68, storedUses = 1, },
		[21] = { cooldown = 8, levelRequirement = 69, storedUses = 1, },
		[22] = { cooldown = 8, levelRequirement = 70, storedUses = 1, },
		[23] = { cooldown = 8, levelRequirement = 71, storedUses = 1, },
		[24] = { cooldown = 8, levelRequirement = 72, storedUses = 1, },
		[25] = { cooldown = 8, levelRequirement = 73, storedUses = 1, },
		[26] = { cooldown = 8, levelRequirement = 74, storedUses = 1, },
		[27] = { cooldown = 8, levelRequirement = 75, storedUses = 1, },
		[28] = { cooldown = 8, levelRequirement = 76, storedUses = 1, },
		[29] = { cooldown = 8, levelRequirement = 77, storedUses = 1, },
		[30] = { cooldown = 8, levelRequirement = 78, storedUses = 1, },
		[31] = { cooldown = 8, levelRequirement = 79, storedUses = 1, },
		[32] = { cooldown = 8, levelRequirement = 80, storedUses = 1, },
		[33] = { cooldown = 8, levelRequirement = 81, storedUses = 1, },
		[34] = { cooldown = 8, levelRequirement = 82, storedUses = 1, },
	},
}
skills["AxisEnfeeble"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "accuracy_rating_+%", -40 },
		{ "enfeeble_damage_+%_final", -40 },
		{ "enfeeble_damage_+%_vs_rare_or_unique_final", -15 },
		{ "active_skill_area_of_effect_radius_+%_final", 42 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 10, levelRequirement = 1, storedUses = 1, },
	},
}
skills["MonsterFireballContactPos"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.9400000572205, 3.0099999904633, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterFireBomb"] = {
	name = "Fire Bomb",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8889000415802,
	incrementalEffectiveness = 0.052000001072884,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies and leaving an area of burning ground that damages enemies who walk through it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_trap_duration", 2500 },
		{ "base_skill_effect_duration", 4500 },
		{ "trap_variation", 1 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"is_trap",
		"is_area_damage",
		"base_skill_is_trapped",
		"ignores_trap_and_mine_cooldown_limit",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 0.40000000596046, 0.60000002384186, 16.666667039196, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 3, }, },
		[2] = { 0.56000000238419, 0.83999997377396, 23.33333345751, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 3, }, },
	},
}
skills["MonsterFlickerStrike"] = {
	name = "Flicker Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "attack_speed_+%", 30 },
		{ "base_attack_speed_+%_per_frenzy_charge", 10 },
		{ "active_skill_damage_+%_final", 10 },
	},
	stats = {
		"ignores_proximity_shield",
		"melee_defer_damage_prediction",
	},
	levels = {
		[1] = { cooldown = 2, levelRequirement = 13, storedUses = 1, },
	},
}
skills["MonsterFlameRedCannibal"] = {
	name = "Incinerate",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3999999761581,
	incrementalEffectiveness = 0.037000000476837,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 8,
	castTime = 0.333,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_repeat_count", 2 },
		{ "spell_maximum_action_distance_+%", -75 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "number_of_additional_projectiles", 3 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"always_pierce",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.30000001192093, 0.60000002384186, damageEffectiveness = 0.25, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterIceShot"] = {
	name = "Ice Shot",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "base_skill_effect_duration", 2500 },
	},
	stats = {
		"physical_damage_+%",
		"skill_can_fire_arrows",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 15, baseMultiplier = 0.625, levelRequirement = 1, statInterpolation = { 1, }, },
		[2] = { 50, baseMultiplier = 0.625, levelRequirement = 68, statInterpolation = { 2, }, },
	},
}
skills["MountainGoatmanIceSpear"] = {
	name = "Ice Spear",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1817998886108,
	incrementalEffectiveness = 0.037999998778105,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "active_skill_chill_duration_+%_final", 20 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"ice_spear_second_form_damage_+%",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, critChance = 7, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, 25, critChance = 7, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["MonsterLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 2, },
	},
}
skills["MonsterLeapSlamFoothills"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "leapslam_overshoot_distance", 10 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 2, },
	},
}
skills["MonsterLesserMultiFireballSpectre"] = {
	name = "Lesser Multi Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.88889998197556,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "number_of_additional_projectiles", 1 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.7599999904633, 2.6400001049042, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterLesserMultiIceSpear"] = {
	name = "Lesser Multi Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "ice_spear_second_form_damage_+%", 50 },
		{ "number_of_additional_projectiles", 1 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterLightningArrow"] = {
	name = "Lightning Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.63800001144409,
	incrementalEffectiveness = 0.019999999552965,
	description = "Fires a charged arrow which damages enemies by causing them to be struck by a bolt of lightning, which also damages a number of surrounding enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "lightning_arrow_maximum_number_of_extra_targets", 4 },
		{ "base_chance_to_shock_%", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", -12 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { levelRequirement = 9, },
	},
}
skills["SkeletonArcherLightningArrow"] = {
	name = "Lightning Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.63800001144409,
	incrementalEffectiveness = 0.019999999552965,
	description = "Fires a charged arrow which damages enemies by causing them to be struck by a bolt of lightning, which also damages a number of surrounding enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "lightning_arrow_maximum_number_of_extra_targets", 4 },
		{ "base_chance_to_shock_%", 50 },
		{ "active_skill_area_of_effect_radius_+%_final", -12 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.7812, levelRequirement = 9, },
	},
}
skills["MonsterLightningThorns"] = {
	name = "Lightning Thorns",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.7999999523163,
	incrementalEffectiveness = 0.034000001847744,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3500 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 3.5, levelRequirement = 3, storedUses = 2, },
	},
}
skills["MonsterMultiFireballSpectre"] = {
	name = "Multi Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.77780002355576,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "number_of_additional_projectiles", 2 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.7599999904633, 2.6400001049042, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterMultiIceSpear"] = {
	name = "Multi Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "ice_spear_second_form_damage_+%", 50 },
		{ "number_of_additional_projectiles", 2 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterProjectileWeakness"] = {
	name = "Projectile Weakness",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses a single enemy, increasing the damage they take from projectiles, and making projectiles split when hitting them, to hit other targets around them. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "projectiles_hitting_self_split_into_x", 3 },
	},
	stats = {
		"projectile_damage_taken_+%",
		"active_skill_area_of_effect_radius_+%_final",
	},
	notMinionStat = {
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 32, 24, cooldown = 12, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[2] = { 34, 42, cooldown = 12, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, }, },
		[3] = { 34, 42, cooldown = 12, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["MonsterProximityShield"] = {
	name = "Proximity Shield",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 18, levelRequirement = 0, storedUses = 1, },
	},
}
skills["MonsterPuncture"] = {
	name = "Puncture",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Punctures enemies, causing a bleeding debuff, which will be affected by modifiers to skill duration. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	stats = {
		"active_skill_bleeding_damage_+%_final",
		"skill_can_fire_arrows",
		"global_bleed_on_hit",
	},
	notMinionStat = {
		"active_skill_bleeding_damage_+%_final",
	},
	levels = {
		[1] = { 112, baseMultiplier = 1.2, levelRequirement = 9, statInterpolation = { 1, }, },
		[2] = { 155, baseMultiplier = 1.2, levelRequirement = 30, statInterpolation = { 1, }, },
		[3] = { 197, baseMultiplier = 1.2, levelRequirement = 60, statInterpolation = { 1, }, },
	},
}
skills["MonsterRighteousFireWhileSpectred"] = {
	name = "Unrighteous Fire",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.1110999584198,
	incrementalEffectiveness = 0.056000001728535,
	description = "Engulfs you in magical fire that rapidly burns you and nearby enemies. Your spell damage is substantially increased while under this effect. The effect ends when you have 1 life remaining.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 18 },
		{ "active_skill_area_of_effect_radius_+%_final", 27 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, levelRequirement = 3, statInterpolation = { 3, }, },
	},
}
skills["MonsterShockNova"] = {
	name = "Shock Nova",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.2374999523163,
	incrementalEffectiveness = 0.0304000005126,
	description = "Casts a ring of Lightning around you, followed by a larger Lightning nova. Each effect hits enemies caught in their area with Lightning Damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "newshocknova_first_ring_damage_+%_final", -50 },
		{ "base_chance_to_shock_%", 50 },
		{ "active_skill_shock_effect_+%_final", 20 },
		{ "active_skill_area_of_effect_radius_+%_final", 5 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 3, levelRequirement = 4, statInterpolation = { 3, 3, }, },
		[2] = { 1.460000038147, 4.3899998664856, critChance = 3, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterSpark"] = {
	name = "Spark",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5625,
	incrementalEffectiveness = 0.035000000149012,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "number_of_additional_projectiles", 1 },
		{ "base_projectile_speed_+%", 25 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 4, statInterpolation = { 3, 3, }, },
		[2] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 8, statInterpolation = { 3, 3, }, },
		[3] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 11, statInterpolation = { 3, 3, }, },
		[4] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 25, statInterpolation = { 3, 3, }, },
		[5] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 29, statInterpolation = { 3, 3, }, },
		[6] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 31, statInterpolation = { 3, 3, }, },
		[7] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 66, statInterpolation = { 3, 3, }, },
		[8] = { 1.1000000238419, 3.2999999523163, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterSplitFireballSpectre"] = {
	name = "Split Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.95560002326965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"projectiles_fork",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.7599999904633, 2.6400001049042, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterSplitIceSpear"] = {
	name = "Split Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "ice_spear_second_form_damage_+%", 50 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"projectiles_fork",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 7, damageEffectiveness = 0.8, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterViperStrike"] = {
	name = "Viper Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.64999997615814,
	incrementalEffectiveness = 0.025499999523163,
	description = "Hits enemies, converting some of your physical damage to chaos damage and inflicting poison which will be affected by modifiers to skill duration. If dual wielding, will strike with both weapons. Requires a claw, dagger or sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	constantStats = {
		{ "physical_damage_%_to_add_as_chaos", 10 },
		{ "base_chance_to_poison_on_hit_%", 100 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"poison_duration_is_skill_duration",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { levelRequirement = 4, cost = { Mana = 5, }, },
	},
}
skills["MonsterWarlordsMark"] = {
	name = "Warlord's Mark",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "Curses a single enemy, giving a chance to double the duration of stuns on them. Attacking the cursed enemy will leech life and mana, stunning them will grant rage, and killing it will grant an endurance charge. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["life_leech_on_any_damage_when_hit_by_attack_permyriad"] = {
			mod("SelfDamageLifeLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["mana_leech_on_any_damage_when_hit_by_attack_permyriad"] = {
			mod("SelfDamageManaLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["enemy_rage_regeneration_on_stun"] = {
			flag("Condition:CanGainRage", { type = "GlobalEffect", effectType = "Buff" } ),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "enemy_chance_to_double_stun_duration_%_vs_self", 40 },
		{ "life_leech_on_any_damage_when_hit_by_attack_permyriad", 200 },
		{ "mana_leech_on_any_damage_when_hit_by_attack_permyriad", 200 },
		{ "chance_to_grant_endurance_charge_on_death_%", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 24 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 1, storedUses = 1, },
	},
}
skills["MotherOfFlamesMagmaOrb3"] = {
	name = "Rolling Magma",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.7778000831604,
	incrementalEffectiveness = 0.035500001162291,
	description = "Lob a fiery orb that deals area damage as it hits the ground. The skill chains, bouncing forward to deal damage multiple times.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Multicastable] = true, [SkillType.Chains] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
		chaining = true,
	},
	constantStats = {
		{ "base_cast_speed_+%", -66 },
		{ "number_of_chains", 2 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 3, critChance = 5, levelRequirement = 1, storedUses = 3, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 3, critChance = 5, levelRequirement = 68, storedUses = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["NecromancerConductivity"] = {
	name = "Conductivity",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their lightning resistance and giving them a chance to be shocked when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_lightning_damage_resistance_%"] = {
			mod("LightningResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_shocked_%"] = {
			mod("SelfShockChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "chance_to_be_shocked_%", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", 9 },
	},
	stats = {
		"base_lightning_damage_resistance_%",
	},
	levels = {
		[1] = { -20, cooldown = 10, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { -25, cooldown = 10, levelRequirement = 41, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { -30, cooldown = 10, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { -40, cooldown = 10, levelRequirement = 71, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["NecromancerElementalWeakness"] = {
	name = "Elemental Weakness",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, lowering their elemental resistances.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_resist_all_elements_%"] = {
			mod("ElementalResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "active_skill_area_of_effect_radius_+%_final", 42 },
	},
	stats = {
		"base_resist_all_elements_%",
	},
	levels = {
		[1] = { -20, cooldown = 10, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { -25, cooldown = 10, levelRequirement = 40, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { -30, cooldown = 10, levelRequirement = 56, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { -40, cooldown = 10, levelRequirement = 71, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["NecromancerEnfeeble"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "accuracy_rating_+%", -60 },
		{ "enfeeble_damage_+%_final", -60 },
		{ "enfeeble_damage_+%_vs_rare_or_unique_final", -23 },
		{ "active_skill_area_of_effect_radius_+%_final", 42 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 10, levelRequirement = 4, storedUses = 1, },
	},
}
skills["NecromancerFlammability"] = {
	name = "Flammability",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their fire resistance and giving them a chance to be ignited when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_fire_damage_resistance_%"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_ignited_%"] = {
			mod("SelfIgniteChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "chance_to_be_ignited_%", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", 9 },
	},
	stats = {
		"base_fire_damage_resistance_%",
	},
	levels = {
		[1] = { -20, cooldown = 10, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { -25, cooldown = 10, levelRequirement = 41, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { -30, cooldown = 10, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { -40, cooldown = 10, levelRequirement = 71, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["NecromancerFrostbite"] = {
	name = "Frostbite",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their cold resistance and giving them a chance to be frozen when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_cold_damage_resistance_%"] = {
			mod("ColdResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_frozen_%"] = {
			mod("SelfFreezeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "chance_to_be_frozen_%", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", 9 },
	},
	stats = {
		"base_cold_damage_resistance_%",
	},
	levels = {
		[1] = { -20, cooldown = 10, levelRequirement = 10, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { -25, cooldown = 10, levelRequirement = 41, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { -30, cooldown = 10, levelRequirement = 58, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { -40, cooldown = 10, levelRequirement = 71, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["NecromancerProjectileWeakness"] = {
	name = "Projectile Weakness",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses a single enemy, increasing the damage they take from projectiles, and making projectiles split when hitting them, to hit other targets around them. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "projectiles_hitting_self_split_into_x", 3 },
	},
	stats = {
		"projectile_damage_taken_+%",
		"active_skill_area_of_effect_radius_+%_final",
	},
	notMinionStat = {
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 22, 24, cooldown = 12, levelRequirement = 25, storedUses = 1, statInterpolation = { 1, 1, }, },
		[2] = { 24, 42, cooldown = 12, levelRequirement = 55, storedUses = 1, statInterpolation = { 1, 1, }, },
		[3] = { 24, 42, cooldown = 12, levelRequirement = 60, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["NecromancerRaiseZombie"] = {
	name = "Raise Zombie",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Raises a zombie minion from a corpse, which will follow you and attack enemies with a melee strike.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 1 },
	},
	stats = {
		"base_number_of_zombies_allowed",
	},
	levels = {
		[1] = { 3, levelRequirement = 2, statInterpolation = { 1, }, },
		[2] = { 4, levelRequirement = 26, statInterpolation = { 1, }, },
		[3] = { 5, levelRequirement = 40, statInterpolation = { 1, }, },
		[4] = { 6, levelRequirement = 51, statInterpolation = { 1, }, },
	},
}
skills["NecromancerVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "physical_damage_taken_+%", 50 },
		{ "receive_bleeding_chance_%_when_hit_by_attack", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", 24 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 9, levelRequirement = 1, storedUses = 1, },
	},
}
skills["PyroChaosFireball"] = {
	name = "Chaos Fireball",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3555999994278,
	incrementalEffectiveness = 0.028500000014901,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.40000000596046, 0.60000002384186, 0.27000001072884, 0.33000001311302, cooldown = 3, critChance = 6, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, 3, 3, }, },
	},
}
skills["PyroFireball"] = {
	name = "Fireball",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.1888999938965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.93,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_base_area_of_effect_radius", 9 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 1.1200000047684, 1.6799999475479, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["PyroSuicideExplosion"] = {
	name = "Suicide Explosion",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2667000293732,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"grant_kill_to_target_when_exploding_self",
		"is_area_damage",
	},
	notMinionStat = {
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 3, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, levelRequirement = 9, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, levelRequirement = 13, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, levelRequirement = 18, statInterpolation = { 3, 3, }, },
		[5] = { 0.80000001192093, 1.2000000476837, levelRequirement = 23, statInterpolation = { 3, 3, }, },
		[6] = { 0.80000001192093, 1.2000000476837, levelRequirement = 27, statInterpolation = { 3, 3, }, },
	},
}
skills["RevenantSpellProjectileSpectre"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.052999999374151,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 7 },
		{ "base_number_of_projectiles_in_spiral_nova", 3 },
		{ "projectile_spiral_nova_time_ms", 150 },
		{ "projectile_spiral_nova_angle", 20 },
		{ "projectile_spiral_nova_starting_angle_offset", -10 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 60 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.60000002384186, 1.3999999761581, cooldown = 3, levelRequirement = 3, storedUses = 2, statInterpolation = { 3, 3, }, },
	},
}
skills["SeawitchFrostbolt"] = {
	name = "Frostbolt",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.0455000400543,
	incrementalEffectiveness = 0.041000001132488,
	description = "Fires a slow-moving projectile that pierces through enemies, dealing cold damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 3, critChance = 5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 1.0499999523163, 1.5800000429153, cooldown = 3, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SeaWitchScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.27270001173019,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.73,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	constantStats = {
		{ "base_movement_velocity_+%", -20 },
		{ "base_skill_effect_duration", 1900 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6.5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 1.8500000238419, 2.8800001144409, cooldown = 6.5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SeawitchVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.75,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "physical_damage_taken_+%", 50 },
		{ "receive_bleeding_chance_%_when_hit_by_attack", 25 },
		{ "active_skill_area_of_effect_radius_+%_final", 24 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SkeletonBlackAbyssBoneLance"] = {
	name = "Unearth",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.035000000149012,
	description = "Fires a projectile that will pierce through enemies to impact the ground at the targeted location, creating a Bone Archer corpse where it lands.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Trappable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "desecrate_maximum_number_of_corpses", 3 },
		{ "base_projectile_speed_+%", -35 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"always_pierce",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 6, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonCannonMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.014000000432134,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 5 },
		{ "projectile_speed_variation_+%", 15 },
		{ "spell_maximum_action_distance_+%", -40 },
		{ "projectile_minimum_range", 8 },
		{ "projectile_spread_radius_per_additional_projectile", 5 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectiles_not_offset",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.87999999523163, 1.3200000524521, critChance = 5, levelRequirement = 45, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonCannonBoneMortar"] = {
	name = "Bone Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.014000000432134,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 543 },
		{ "projectile_minimum_range", 217 },
		{ "number_of_additional_projectiles", 1 },
		{ "mortar_cone_angle", 30 },
		{ "base_skill_effect_duration", 10000 },
		{ "monster_projectile_variation", 3 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.87999999523163, 1.3200000524521, cooldown = 4, critChance = 5, levelRequirement = 45, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 4, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonCannonBoneNova"] = {
	name = "Bone Nova",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "number_of_additional_projectiles", 10 },
		{ "active_skill_damage_+%_final", 40 },
		{ "main_hand_base_maximum_attack_distance", 30 },
		{ "active_skill_area_of_effect_radius_+%_final", 150 },
	},
	stats = {
		"projectiles_nova",
		"base_is_projectile",
	},
	levels = {
		[1] = { cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SkeletonMassBowProjectile"] = {
	name = "Puncture",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	constantStats = {
		{ "monster_projectile_variation", 12 },
		{ "spell_maximum_action_distance_+%", -50 },
		{ "base_projectile_speed_+%", 200 },
	},
	stats = {
		"base_is_projectile",
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { levelRequirement = 2, },
	},
}
skills["SkeletonProjectileBlack"] = {
	name = "",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.2699999809265,
	incrementalEffectiveness = 0.027300000190735,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 33 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonSoldierTornadoShot"] = {
	name = "Tornado Shot",
	hidden = true,
	color = 2,
	description = "Fires a piercing shot that travels until it reaches the targeted location. It will then fire projectiles out in all directions from that point, which will travel for a short time before disappearing.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "tornado_shot_num_of_secondary_projectiles", 3 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"skill_can_fire_arrows",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { -30, levelRequirement = 2, statInterpolation = { 1, }, },
		[2] = { -35, levelRequirement = 38, statInterpolation = { 1, }, },
		[3] = { -40, levelRequirement = 54, statInterpolation = { 1, }, },
	},
}
skills["SkeletonSpark"] = {
	name = "Spark",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.75,
	incrementalEffectiveness = 0.0304000005126,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3500 },
		{ "number_of_additional_projectiles", 2 },
		{ "base_projectile_speed_+%", 25 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 4, statInterpolation = { 3, 3, }, cost = { Mana = 50, }, },
		[2] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 8, statInterpolation = { 3, 3, }, cost = { Mana = 48, }, },
		[3] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 11, statInterpolation = { 3, 3, }, cost = { Mana = 45, }, },
		[4] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 20, statInterpolation = { 3, 3, }, cost = { Mana = 44, }, },
		[5] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 28, statInterpolation = { 3, 3, }, cost = { Mana = 41, }, },
		[6] = { 0.5, 1.5, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 29, statInterpolation = { 3, 3, }, cost = { Mana = 40, }, },
		[7] = { 2.2400000095367, 6.7300000190735, critChance = 5, damageEffectiveness = 0.7, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { Mana = 40, }, },
	},
}
skills["AxisTemporalChains"] = {
	name = "Temporal Chains",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curses all enemies in an area, lowering their action speed and making other effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.67,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "temporal_chains_action_speed_+%_final", -20 },
		{ "buff_time_passed_+%_other_than_temporal_chains", -25 },
		{ "temporal_chains_action_speed_+%_vs_rare_or_unique_final", -10 },
		{ "active_skill_area_of_effect_radius_+%_final", 9 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 0, storedUses = 1, },
	},
}
skills["SkeletonVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "physical_damage_taken_+%", 50 },
		{ "receive_bleeding_chance_%_when_hit_by_attack", 20 },
		{ "active_skill_area_of_effect_radius_+%_final", 24 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 1, cost = { Mana = 110, }, },
	},
}
skills["SlavedriverFlameWhip"] = {
	name = "Lightning Surge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.045000001788139,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
	},
	constantStats = {
		{ "base_cast_speed_+%", -65 },
		{ "active_skill_area_of_effect_radius_+%_final", 33 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["KitavaSlavedriverFlameWhip"] = {
	name = "Flame Surge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.2000000476837,
	incrementalEffectiveness = 0.027499999850988,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
	},
	constantStats = {
		{ "base_cast_speed_+%", -65 },
		{ "active_skill_area_of_effect_radius_+%_final", 33 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SnakeSpineProjectile"] = {
	name = "Spine Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 2 },
		{ "spell_maximum_action_distance_+%", -60 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["SolarisChampionFlameVortex"] = {
	name = "Flame Vortex",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.029999999329448,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "monster_projectile_variation", 2 },
		{ "base_projectile_speed_+%", -57 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"projectiles_not_offset",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SpecialBeamCannon"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.1556000709534,
	incrementalEffectiveness = 0.037000000476837,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", -23 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["TarMortarTaster"] = {
	name = "Tar Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3332999944687,
	incrementalEffectiveness = 0.032000001519918,
	description = "Like monster mortar skill, but leaves a ground effect on impact.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 2 },
		{ "projectile_spread_radius", 10 },
		{ "spell_maximum_action_distance_+%", -50 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_projectile_speed_+%",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 4, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.87999999523163, 1.3200000524521, 33, cooldown = 4, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["UndyingWhirlingBlades"] = {
	name = "Whirling Blades",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Dive through enemies, dealing weapon damage. If dual wielding attacks with both weapons, dealing the damage of both in one hit. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.43,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "active_skill_damage_+%_final", -40 },
		{ "monster_flurry", 1 },
	},
	stats = {
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { levelRequirement = 0, cost = { Mana = 50, }, },
	},
}
skills["WalkingDoubleSlash"] = {
	name = "Double Slash",
	hidden = true,
	color = 2,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -22 },
	},
	stats = {
		"is_area_damage",
		"disable_skill_repeats",
	},
	levels = {
		[1] = { baseMultiplier = 0.7, cooldown = 6, damageEffectiveness = 0.95, levelRequirement = 12, storedUses = 1, },
	},
}
skills["WickerManMoltenStrike"] = {
	name = "Molten Strike",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.69999998807907,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will deal area attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "number_of_additional_projectiles", 4 },
		{ "active_skill_damage_+%_final", 20 },
		{ "physical_damage_+%", 10 },
		{ "active_skill_projectile_damage_+%_final", -40 },
		{ "base_projectile_speed_+%", -25 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.55, levelRequirement = 10, },
	},
}
skills["VaalincursionMortar"] = {
	name = "Physical Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.9550000429153,
	incrementalEffectiveness = 0.035000000149012,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 10 },
		{ "spell_maximum_action_distance_+%", -40 },
		{ "projectile_spread_radius_per_additional_projectile", 5 },
		{ "projectile_minimum_range", 10 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["VaalIncursionFirestorm"] = {
	name = "Firestorm",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.4443998336792,
	incrementalEffectiveness = 0.03999999910593,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radiusLabel", "Fireball explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Fireballs fall:"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 600 },
		{ "fire_storm_fireball_delay_ms", 200 },
		{ "firestorm_base_area_of_effect_+%", 100 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["VaalIncursionSpecialBeamCannonBlood"] = {
	name = "Physical Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 83, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeEyrieArrow"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
		{ "arrow_projectile_variation", 26 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["AtlasEyrieArcherMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.33,
	baseFlags = {
		spell = true,
		hit = true,
		projectile = true,
		area = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 10, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasEyrieArcherSnipe"] = {
	name = "Snipe",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 92 },
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
	},
	stats = {
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"always_pierce",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 19, },
		[3] = { levelRequirement = 20, },
		[4] = { levelRequirement = 84, },
	},
}
skills["AtlasEyrieArcherCrystalImpact"] = {
	name = "Crystal Impact",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasExilesCrusaderMageguardProjectile"] = {
	name = "Projectile Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 127 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasExileCrusaderMageguardBombExplodeSpectre"] = {
	name = "Bombs",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasCrusaderMageguardBeam"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.3,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 8, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasCrusaderSisterMortarSpectre"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2999999523163,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 20 },
		{ "number_of_projectiles_override", 1 },
		{ "monster_mortar_number_of_forks", 3 },
		{ "mortar_projectile_distance_override", 10 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["BreachLightningWhip"] = {
	name = "Breach Lightning Whip",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
		skill("showAverage", true),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 80 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 5, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 1, 3, cooldown = 5, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["BreachArc"] = {
	name = "Breach Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.82499998807907,
	incrementalEffectiveness = 0.043999999761581,
	description = "An arc of lightning reaches from the caster to a targeted enemy and chains to other enemies, but not immediately back. Each time the arc chains, it will also chain a secondary arc to another enemy that the main arc has not already hit, which cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		chaining = true,
	},
	constantStats = {
		{ "base_chance_to_shock_%", 10 },
		{ "spell_maximum_action_distance_+%", -65 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, levelRequirement = 1, statInterpolation = { 3, 3, }, },
		[2] = { 1.3999999761581, 2.5999999046326, levelRequirement = 68, statInterpolation = { 3, 3, }, },
	},
}
skills["BreachTeamWarp"] = {
	name = "Breach Team Warp",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
		{ "number_of_monsters_to_summon", 3 },
		{ "breach_team_warp_buff_lightning_damage_+%", 25 },
		{ "breach_team_warp_buff_movement_velocity_+%", 50 },
		{ "breach_team_warp_buff_damage_taken_+%", -50 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 20, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BreachLightningOrbsCommander"] = {
	name = "Breach Lightning Orbs Commander",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.049100000411272,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 5, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SandLeaperDodgeLeft"] = {
	name = "Sand Leaper Dodge Left",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
	},
	constantStats = {
		{ "monster_dodge_distance", 22 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 1, cost = { Mana = 90, }, },
	},
}
skills["SandLeaperDodgeRight"] = {
	name = "Sand Leaper Dodge Right",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
	},
	constantStats = {
		{ "monster_dodge_direction", 1 },
		{ "monster_dodge_distance", 22 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 1, cost = { Mana = 90, }, },
	},
}
skills["SynthesisSoulstealerProjectileLightning"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.037999998778105,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		triggerable = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 103 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["SynthesisSoulstealerLaser"] = {
	name = "Lightning Laser",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["SynthesisSoulstealerBolt"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "base_skill_effect_duration", 260 },
		{ "skill_range_+%", -75 },
		{ "active_skill_area_of_effect_radius_+%_final", -35 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeCold"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["AtlasCrusaderJudgeBallLightning"] = {
	name = "Ball Lightning",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.41249999403954,
	incrementalEffectiveness = 0.045000001788139,
	description = "Fires a slow-moving projectile that damages each enemy in an area around it repeatedly with bolts of lightning.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.6,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "base_projectile_speed_+%", -25 },
		{ "active_skill_area_of_effect_radius_+%_final", -11 },
		{ "active_skill_base_area_of_effect_radius", 18 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasCruasderJudgeFadingNova"] = {
	name = "Nova Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 128 },
		{ "number_of_additional_projectiles", 7 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"always_pierce",
		"use_scaled_contact_offset",
		"projectiles_nova",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 8, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GAHarvestCrabDashSlam"] = {
	name = "Dash Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 50, -30, baseMultiplier = 2, cooldown = 4, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, baseMultiplier = 2, cooldown = 4, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, baseMultiplier = 2, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, baseMultiplier = 2, cooldown = 4, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
	},
	stats = {
		"is_area_damage",
	},
}
skills["HarvestCrabAbyssSlam"] = {
	name = "Slam Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 4 },
		{ "main_hand_base_maximum_attack_distance", 50 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -50 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, cooldown = 10, levelRequirement = 1, storedUses = 1, },
		[2] = { baseMultiplier = 0.75, cooldown = 10, levelRequirement = 19, storedUses = 1, },
		[3] = { baseMultiplier = 0.75, cooldown = 10, levelRequirement = 20, storedUses = 1, },
		[4] = { baseMultiplier = 0.75, cooldown = 10, levelRequirement = 84, storedUses = 1, },
	},
}
skills["HarvestNessaCrabScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 12, levelRequirement = 0, storedUses = 1, },
	},
}
skills["HarvestNessaCrabScreechDebuff"] = {
	name = "Frigid Roar",
	hidden = true,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statMap = {
		["frigid_roar_cold_damage_taken_+%"] = {
			mod("ColdDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Frigid Roar" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	stats = {
		"frigid_roar_cold_damage_taken_+%",
	},
	levels = {
		[1] = { 20, cooldown = 12, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}

skills["HarvestRhexLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { cooldown = 10, levelRequirement = 1, storedUses = 1, },
		[2] = { cooldown = 10, levelRequirement = 19, storedUses = 1, },
		[3] = { cooldown = 10, levelRequirement = 20, storedUses = 1, },
		[4] = { cooldown = 10, levelRequirement = 84, storedUses = 1, },
	},
}
skills["GAHarvestRhexDashSlash"] = {
	name = "Dash Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 50, -30, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
	},
	stats = {
		"is_area_damage",
	},
}
skills["GSHarvestRhexScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2000000476837,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 2, 7, critChance = 5, duration = 4, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
}
skills["HarvestRhexScreechDebuff"] = {
	name = "Thunderous Roar",
	hidden = true,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statMap = {
		["thunderous_roar_lightning_damage_taken_+%"] = {
			mod("LightningDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Thunderous Roar" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	stats = {
		"thunderous_roar_lightning_damage_taken_+%",
	},
	levels = {
		[1] = { 10, cooldown = 8, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}

skills["LegionTemplarJudgeBallLightning"] = {
	name = "Ball Lightning",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.20600000023842,
	incrementalEffectiveness = 0.045000001788139,
	description = "Fires a slow-moving projectile that damages each enemy in an area around it repeatedly with bolts of lightning.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.6,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "base_projectile_speed_+%", -25 },
		{ "skill_physical_damage_%_to_convert_to_lightning", 80 },
		{ "active_skill_area_of_effect_radius_+%_final", -11 },
		{ "active_skill_base_area_of_effect_radius", 18 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"visual_hit_effect_elemental_is_holy",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["LegionTemplarJudgeStormCall"] = {
	name = "Storm Call",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.6499999761581,
	incrementalEffectiveness = 0.031199999153614,
	description = "Sets a marker at a location. After a short duration, lightning strikes the marker, dealing damage around it and causing lightning strikes at any other markers you've cast.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Lightning] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "skill_physical_damage_%_to_convert_to_lightning", 60 },
		{ "active_skill_area_of_effect_radius_+%_final", -13 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"visual_hit_effect_elemental_is_holy",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MPWHeistThugRangedBurningArrow"] = {
	name = "Burning Arrow",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 124 },
		{ "skill_physical_damage_%_to_convert_to_fire", 75 },
		{ "spell_maximum_action_distance_+%", -50 },
	},
	stats = {
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
		"always_ignite",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 19, },
		[3] = { levelRequirement = 20, },
		[4] = { levelRequirement = 84, },
	},
}
skills["MPSHeistRobotClockworkGolemBasicProjectile"] = {
	name = "Frost Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 163 },
		{ "spell_maximum_action_distance_+%", -50 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSHeistRobotClockworkGolemMortarSpectre"] = {
	name = "Frost Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.045000001788139,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -35 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["HeistThugRangedExplosiveArrow"] = {
	name = "Explosive Arrow (20 Fuses)",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arrow which will stick into an enemy or wall, and then explode, dealing area damage around it, either after a duration or when the maximum number of arrows stuck to that target is reached. If an enemy has multiple Explosive Arrows stuck in them, the first one to explode will consume the others, adding their damage to its explosion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["explosive_arrow_explosion_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil),
		},
		["explosive_arrow_explosion_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["explosive_arrow_explosion_base_damage_+permyriad"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment)),
			div = 100,
		},
		["explosive_arrow_hit_and_ailment_damage_+%_final_per_stack"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
		area = true,
		duration = true,
		triggerable = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true),
		mod("Damage", "MORE", 100, 0, 0, { type = "Multiplier", var = "ExplosiveArrowFuse", base = -100 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 20),
	},
	constantStats = {
		{ "fuse_arrow_explosion_radius_+_per_fuse_arrow_orb", 2 },
		{ "explosive_arrow_explosion_base_damage_+permyriad", -5000 },
		{ "explosive_arrow_maximum_bonus_explosion_radius", 12 },
		{ "explosive_arrow_hit_damage_+%_final_per_stack", 3 },
		{ "explosive_arrow_stack_limit", 20 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"explosive_arrow_explosion_minimum_added_fire_damage",
		"explosive_arrow_explosion_maximum_added_fire_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["EmptyActionAttackSecretPoliceDaggers"] = {
	name = "Dagger Trigger Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.87,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "main_hand_base_maximum_attack_distance", 60 },
	},
	stats = {
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["BetrayalSecretPoliceCurveDagger1"] = {
	name = "Secret Police Daggers",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "lunaris_glaive_angle", -20 },
		{ "lunaris_glaive_acceleration_x", 1500 },
		{ "active_skill_attack_speed_+%_final", 20 },
		{ "melee_weapon_range_+", 50 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { -50, levelRequirement = 1, statInterpolation = { 2, }, },
		[2] = { 0, levelRequirement = 100, statInterpolation = { 2, }, },
	},
}
skills["AtlasEyrieKiwethMortarSpectre"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.67,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 10, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AtlasEyrieKiwethMortarShards"] = {
	name = "Mortar Shards",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		projectile = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GAHeistThugRangedArrowShotgun"] = {
	name = "Arrow Shotgun",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 3,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, cooldown = 10, levelRequirement = 1, storedUses = 1, },
	},
}
skills["GAHeistThugRangedShotgun"] = {
	name = "Ranged Shotgun",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Triggerable] = true, [SkillType.Channel] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.33,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.3, levelRequirement = 1, },
		[2] = { baseMultiplier = 1.3, levelRequirement = 19, },
		[3] = { baseMultiplier = 1.3, levelRequirement = 20, },
		[4] = { baseMultiplier = 1.3, levelRequirement = 84, },
	},
}
skills["GSHeistRobotPyreBeamBlast"] = {
	name = "Beam Blast",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHeistRobotPyreNukeBeam"] = {
	name = "Nuke Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 4.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 13, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHeistRobotPyreNukeBeamChannelled"] = {
	name = "Nuke Beam Channelled",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Channel] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.54,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 13, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHeistRobotPyreBeamSweepBeam"] = {
	name = "Beam Sweep",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeEyrieBird"] = {
	name = "Knockback Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
		{ "base_knockback_speed_+%", 100 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"global_knockback",
		"determine_knockback_direction_from_melee_pattern",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -38, baseMultiplier = 0.75, cooldown = 8, levelRequirement = 1, storedUses = 1, },
		[2] = { attackSpeedMultiplier = -38, baseMultiplier = 0.75, cooldown = 8, levelRequirement = 19, storedUses = 1, },
		[3] = { attackSpeedMultiplier = -38, baseMultiplier = 0.75, cooldown = 8, levelRequirement = 20, storedUses = 1, },
		[4] = { attackSpeedMultiplier = -38, baseMultiplier = 0.75, cooldown = 8, levelRequirement = 84, storedUses = 1, },
	},
}
skills["AtlasEyrieBirdBreath"] = {
	name = "Chilling Breath",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "chill_minimum_slow_%", 30 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 10, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SecretDesecrateMonsterEarthquakeTriggered"] = {
	name = "Earthquake",
	hidden = true,
	color = 4,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		melee = true,
		area = true,
		duration = true,
		triggerable = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 10 },
		{ "quake_slam_fully_charged_explosion_damage_+%_final", 50 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["SecretDesecrateMonsterMultiSlash"] = {
	name = "Multi Slash",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", -33 },
	},
	stats = {
		"is_area_damage",
		"skill_is_attack",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -33, levelRequirement = 0, },
	},
}
skills["UltimatumGuardMeleeCold"] = {
	name = "Cold Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "number_of_additional_projectiles", 2 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "arrow_projectile_variation", 34 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 68, },
	},
}
skills["UltimatumGuardConeArrowCold"] = {
	name = "Cone Arrow",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 1, storedUses = 1, },
		[2] = { cooldown = 8, levelRequirement = 83, storedUses = 1, },
	},
}
skills["MPWVaalGuardBarrage"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 80 },
		{ "monster_projectile_variation", 141 },
		{ "projectile_random_angle_based_on_distance_to_target_location_%", 60 },
	},
	stats = {
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { baseMultiplier = 0.5, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.5, levelRequirement = 83, },
	},
}
skills["MeleeAtAnimationSpeed"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["MeleeKaruiArcher"] = {
	name = "Cold Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "arrow_projectile_variation", 18 },
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 19, },
		[3] = { levelRequirement = 20, },
		[4] = { levelRequirement = 84, },
	},
}
skills["LegionKaruiArcherSnipe"] = {
	name = "Snipe",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
		{ "active_skill_attack_speed_+%_final", -50 },
		{ "monster_projectile_variation", 69 },
	},
	stats = {
		"base_is_projectile",
		"always_pierce",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { baseMultiplier = 1.65, cooldown = 10, levelRequirement = 1, storedUses = 1, },
		[2] = { baseMultiplier = 1.65, cooldown = 10, levelRequirement = 20, storedUses = 1, },
		[3] = { baseMultiplier = 1.65, cooldown = 10, levelRequirement = 21, storedUses = 1, },
		[4] = { baseMultiplier = 1.65, cooldown = 10, levelRequirement = 84, storedUses = 1, },
	},
}
skills["MeleeAtAnimationSpeedFire"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["GAHellscapeDemonElite1DashSlash"] = {
	name = "Dash Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 19, },
		[3] = { levelRequirement = 20, },
		[4] = { levelRequirement = 84, },
	},
}
skills["GSHellscapeDemonElite1Screech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.75,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["TBHellscapePaleLightningBoltSpammableLeft"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.75,
	incrementalEffectiveness = 0.032499998807907,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	constantStats = {
		{ "generic_skill_trigger_skills_with_id", 1 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHellscapePaleEliteBoltImpact"] = {
	name = "Bolt Impact",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.032499998807907,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
		triggerable = true,
	},
	constantStats = {
		{ "generic_skill_trigger_id", 1 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHellscapePaleEliteOmegaBeam"] = {
	name = "Omega Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.043099999427795,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.333,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
		triggerable = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -65 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 0.5, 1.5, -50, cooldown = 6, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, 2, }, },
		[2] = { 0.5, 1.5, 1, cooldown = 6, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, 2, }, },
	},
}
skills["MMSHellscapeDemonEliteTripleMortar"] = {
	name = "Triple Mortal",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "projectile_spread_radius", 15 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 19, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSHellscapeDemonEliteVomitMortar"] = {
	name = "Vomit Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.875,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.7,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "projectile_spread_radius", 5 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 19, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHellscapeDemonEliteBeamNuke"] = {
	name = "Beam Nuke",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.033500000834465,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 7, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 7, critChance = 5, levelRequirement = 19, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, cooldown = 7, critChance = 5, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, cooldown = 7, critChance = 5, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["DTTHellscapeStabWeb"] = {
	name = "Thunder Web",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	statMap = {
		["action_speed_-%"] = {
			mod("ActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Thunder Web" }),
		},
		["base_damage_taken_+%"] = {
			mod("DamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Thunder Web" }),
		},
	},
	stats = {
		"walk_emerge_extra_distance",
		"leap_slam_minimum_distance",
		"spell_maximum_action_distance_+%",
		"action_speed_-%",
		"base_damage_taken_+%",
	},
	levels = {
		[1] = { 20, 40, -50, -15, 15, cooldown = 6, levelRequirement = 0, statInterpolation = { 1, 1, 1, 1, 1 }, cost = { }, },
	},
	baseFlags = {
		spell = true,
		hit = true,
		movement = true,
	},
}
skills["GAHellscapeStabbyCleave1"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.5, levelRequirement = 1, },
	},
}
skills["GAHellscapePaleEliteSkyStab"] = {
	name = "Stab Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["HellscapeFleshFodderArc"] = {
	name = "Scourge Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.3500000238419,
	incrementalEffectiveness = 0.045000001788139,
	description = "An arc of lightning reaches from the caster to a targeted enemy and chains to other enemies, but not immediately back. Each time the arc chains, it will also chain a secondary arc to another enemy that the main arc has not already hit, which cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 1.166,
	baseFlags = {
		spell = true,
		chaining = true,
		triggerable = true,
	},
	constantStats = {
		{ "base_chance_to_shock_%", 10 },
		{ "spell_maximum_action_distance_+%", -50 },
		{ "shock_art_variation", 2 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"disable_visual_hit_effect",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SynthesisSoulstealerProjectilePhysical"] = {
	name = "Projectile",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.037999998778105,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 104 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["SynthesisPhysicalTripleMortar"] = {
	name = "Triple Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 3.67,
	baseFlags = {
		area = true,
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 25 },
		{ "projectile_minimum_range", 20 },
		{ "number_of_projectiles_override", 2 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"mortar_projectile_scale_animation_speed_instead_of_projectile_speed",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 12, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SynthesisSoulstealerQuicksand"] = {
	name = "Quicksand",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.67,
	baseFlags = {
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
		{ "ground_quicksand_art_variation", 4 },
		{ "active_skill_area_of_effect_radius_+%_final", -10 },
	},
	stats = {
		"base_physical_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 8, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["SynthesisPhysicalVolatileSlam"] = {
	name = "Volatile Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["HellionRallyingCry"] = {
	name = "Rallying Cry",
	hidden = true,
	color = 1,
	description = "[DNT] Unused (replaced)",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.25,
	baseFlags = {
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
		{ "taunted_enemies_damage_+%_final_vs_non_taunt_target", -30 },
		{ "active_skill_area_of_effect_radius_+%_final", -25 },
	},
	stats = {
		"damage_+%",
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
	},
	levels = {
		[1] = { 8, cooldown = 8, levelRequirement = 1, storedUses = 1, statInterpolation = { 1, }, },
		[2] = { 10, cooldown = 8, levelRequirement = 50, storedUses = 1, statInterpolation = { 1, }, },
		[3] = { 12, cooldown = 8, levelRequirement = 68, storedUses = 1, statInterpolation = { 1, }, },
		[4] = { 15, cooldown = 8, levelRequirement = 77, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["EmptyActionSpellWarlordGrandmaster"] = {
	name = "Arena Master's Presence",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	statMap = {
		["auras_grant_damage_+%_to_you_and_your_allies"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
	},
	stats = {
		"auras_grant_damage_+%_to_you_and_your_allies",
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
	},
	levels = {
		[1] = { 20, 20, 20, 20, duration = 4, cooldown = 12, levelRequirement = 0, statInterpolation = { 1, 1, 1, 1 }, cost = { }, },
	},
	baseFlags = {
		spell = true,
		buff = true,
		area = true,
		duration = true,
		cooldown = true,
	},
	baseMods = {
		skill("buffAllies", true),
		skill("buffMinions", true),
	},
}
skills["BreachBlizzardSpectre"] = {
	name = "Snow Cloak",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, [SkillType.Buff] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["avoid_damage_%"] = {
			mod("AvoidPhysicalDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidLightningDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidColdDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidFireDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidChaosDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
		},
	},
	baseFlags = {
		spell = true,
		buff = true,
		area = true,
		duration = true,
		cooldown = true,
	},
	baseMods = {
		skill("buffAllies", true),
		skill("buffMinions", true),
	},
	constantStats = {
		{ "avoid_damage_%", 15 },
		{ "base_skill_effect_duration", 10000 },
		{ "active_skill_area_of_effect_radius_+%_final", 150 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 9, levelRequirement = 1, storedUses = 1, },
	},
}
skills["DelveWraithScreechChaos"] = {
	name = "Chaos Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.7999999523163,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterChanceToTemporalChainsOnHit1"] = {
	name = "Temporal Chains",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses all enemies in an area, lowering their action speed and making other effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["curse_effect_+%_final_vs_players"] = {
			mod("CurseEffectAgainstPlayer", "MORE", nil),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"temporal_chains_action_speed_+%_final",
		"buff_time_passed_+%_other_than_temporal_chains",
		"curse_effect_+%_final_vs_players",
		"temporal_chains_action_speed_+%_vs_rare_or_unique_final",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 5000, 0, -20, -40, -50, -10, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}

skills["WraithEtherealKnives"] = {
	name = "Ethereal Knives",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.7000000476837,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arc of knives outwards in front of the caster which deal physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "number_of_additional_projectiles", 9 },
		{ "base_cast_speed_+%", -25 },
		{ "active_skill_damage_+%_final", -15 },
		{ "base_projectile_speed_+%", 25 },
		{ "fixed_projectile_spread", 20 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, critChance = 5, levelRequirement = 51, statInterpolation = { 3, 3, 1, }, },
		[2] = { 0.60000002384186, 0.89999997615814, -25, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, },
		[3] = { 0.60000002384186, 0.89999997615814, -25, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["DelveMonsterEnfeebleOnHit"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"accuracy_rating_+%",
		"enfeeble_damage_+%_final",
		"enfeeble_damage_+%_vs_rare_or_unique_final",
		"base_deal_no_damage",
	},
	levels = {
		[8] = { 9700, 4, -13, -24, -12, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}

skills["MonsterVulnerabilityOnHit1"] = {
	name = "Vulnerability",
    color = 1,
    baseEffectiveness = 0,
    description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding, and ailments inflicted on them will deal damage faster.",
    skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
    statDescriptionScope = "curse_skill_stat_descriptions",
    castTime = 0.5,
    statMap = {
        ["receive_bleeding_chance_%_when_hit_by_attack"] = {
            mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
        },
        ["physical_damage_taken_+%"] = {
            mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
        },
    },
    baseFlags = {
        spell = true,
        curse = true,
        area = true,
        duration = true,
        hex = true,
    },
    baseMods = {
        skill("debuff", true),
        skill("radius", 22),
    },
    constantStats = {
        { "receive_bleeding_chance_%_when_hit_by_attack", 25 },
    },
    stats = {
        "base_skill_effect_duration",
        "active_skill_base_radius_+",
        "physical_damage_taken_+%",
        "base_deal_no_damage",
    },
    levels = {
        [3] = { 9200, 1, 31, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
    },
}

skills["CrucibleIceStormTrap"] = {
	name = "Ice Storm",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.050000000745058,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.67,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		area = true,
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("radiusLabel", "Ice explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Ice fall:"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "fire_storm_fireball_delay_ms", 300 },
		{ "firestorm_base_area_of_effect_+%", -75 },
		{ "base_trap_duration", 10000 },
		{ "trap_variation", 4 },
		{ "trap_throwing_speed_+%", -66 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"is_trap",
		"ignores_trap_and_mine_cooldown_limit",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.40000000596046, 0.60000002384186, cooldown = 8, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSPyromaniacIceMortar"] = {
	name = "Ice Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.045000001788139,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		area = true,
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 10 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriHailrakeGlacialCascade"] = {
	name = "Glacial Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.56300002336502,
	incrementalEffectiveness = 0.039500001817942,
	description = "Icicles emerge from the ground in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"upheaval_number_of_spikes",
		"base_cast_speed_+%",
		"active_skill_area_of_effect_radius_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 6, 0, -20, critChance = 5, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, },
	},
}
skills["AzmeriHailrakeArcticArmour"] = {
	name = "Arctic Armour",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.029999999329448,
	description = "Conjures an icy barrier that chills enemies when they hit you. You drop chilled ground while moving, and take less Fire and Physical damage while stationary.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Totemable] = true, [SkillType.Duration] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Cold] = true, [SkillType.ElementalStatus] = true, [SkillType.Instant] = true, [SkillType.NonHitChill] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1.07,
	baseFlags = {
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "chill_enemy_when_hit_duration_ms", 500 },
		{ "new_arctic_armour_physical_damage_taken_when_hit_+%_final", -5 },
		{ "new_arctic_armour_fire_damage_taken_when_hit_+%_final", -5 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 3, },
	},
}
skills["AzmeriHailrakeGlacialHammer"] = {
	name = "Glacial Hammer",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "Hits enemies, converting some of your physical damage to cold damage. If a non-unique enemy is frozen and is on less than one third life, they will shatter when hit by Glacial Hammer. If striking three times in a row, the third strike will freeze enemies more easily. Requires a Mace, Sceptre or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "base_chance_to_freeze_%", 30 },
		{ "active_skill_damage_+%_final", 20 },
		{ "active_skill_freeze_duration_+%_final", 100 },
	},
	stats = {
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 0.7812, levelRequirement = 1, },
	},
}
skills["GSAzmeriHailrakeIceNova"] = {
	name = "Ice Nova",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2999999523163,
	incrementalEffectiveness = 0.039500001817942,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "base_chance_to_freeze_%", 20 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 0.2, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["IceCrashAzmeriHailrake"] = {
	name = "Ice Crash",
	hidden = true,
	color = 1,
	description = "Slam the ground, damaging enemies in an area around the impact in three stages of increasing size. Enemies take slightly less damage on the second and third stage, and can only be hit by one stage. Works with Swords, Maces, Sceptres, Axes, Staves and Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Cold] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "ice_crash_second_hit_damage_+%_final", -15 },
		{ "ice_crash_third_hit_damage_+%_final", -30 },
		{ "active_skill_base_area_of_effect_radius", 11 },
		{ "active_skill_base_secondary_area_of_effect_radius", 21 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 31 },
		{ "active_skill_attack_speed_+%_final", -66 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, levelRequirement = 0, },
	},
}
skills["AzmeriHailrakeColdResistAura"] = {
	name = "Purity of Ice",
	hidden = true,
	color = 2,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Cold] = true, [SkillType.Instant] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_cold_damage_resistance_%"] = {
			mod("ColdResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_cold_damage_resistance_%"] = {
			mod("ColdResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	stats = {
		"base_cold_damage_resistance_%",
		"base_maximum_cold_damage_resistance_%",
		"active_skill_area_of_effect_radius_+%_final",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 20, 0, 20, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 2, 2, 2, }, },
		[2] = { 31, 1, 50, cooldown = 0.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 2, 2, 2, }, },
	},
}
skills["AzmeriFireFuryMoltenStrike"] = {
	name = "Molten Strike",
	hidden = true,
	color = 1,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will deal area attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, [SkillType.Multistrikeable] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
		{ "active_skill_projectile_damage_+%_final", -40 },
		{ "base_projectile_speed_+%", -25 },
		{ "number_of_additional_projectiles", 4 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.6187, levelRequirement = 0, },
	},
}
skills["FemaleCannibalBossFireStorm"] = {
	name = "Firestorm",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.031500000506639,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radiusLabel", "Fireball explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Fireballs fall:"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "fire_storm_fireball_delay_ms", 100 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "base_chance_to_ignite_%", 25 },
		{ "spell_maximum_action_distance_+%", -75 },
		{ "firestorm_base_area_of_effect_+%", -74 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 2, statInterpolation = { 3, 3, }, },
	},
}
skills["FemaleCannibalBossFlameDash"] = {
	name = "Flame Dash",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.0541000366211,
	incrementalEffectiveness = 0.04450000077486,
	description = "Teleport to a location, damaging enemies and leaving a trail of burning ground. Shares a cooldown with other Blink skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, [SkillType.Damage] = true, [SkillType.DamageOverTime] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Travel] = true, [SkillType.Blink] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.13,
	baseFlags = {
		spell = true,
		movement = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 90.000003601114, cooldown = 6, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
	},
}
skills["AzmeriFirefuryCremation"] = {
	name = "Cremation",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2000000476837,
	incrementalEffectiveness = 0.034000001847744,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Cascadable] = true, [SkillType.Projectile] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cremation_base_fires_projectile_every_x_ms"] = {
			skill("hitTimeOverride", nil),
			div = 1000
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
		projectile = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "corpse_erruption_base_maximum_number_of_geyers", 3 },
		{ "number_of_additional_projectiles", 2 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -60 },
		{ "cremation_base_fires_projectile_every_x_ms", 500 },
		{ "active_skill_area_of_effect_radius_+%_final", -30 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 5, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriFirefuryFireResistAura"] = {
	name = "Purity of Fire",
	hidden = true,
	color = 1,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_fire_damage_resistance_%"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_fire_damage_resistance_%"] = {
			mod("FireResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	stats = {
		"base_fire_damage_resistance_%",
		"base_maximum_fire_damage_resistance_%",
		"active_skill_area_of_effect_radius_+%_final",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 20, 0, 20, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 2, 2, 2, }, },
		[2] = { 31, 1, 50, levelRequirement = 80, statInterpolation = { 2, 2, 2, }, },
	},
}
skills["AzmeriHydraDoomArrow"] = {
	name = "Doom Arrow",
	hidden = true,
	color = 2,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "doom_arrow_number_of_arrows", 10 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "active_skill_damage_+%_final", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 45 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, cooldown = 3, levelRequirement = 83, storedUses = 1, },
	},
}
skills["AzmeriHydraBarrage"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.4,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = output.ProjectileCount
	end,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "number_of_additional_projectiles", 9 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "active_skill_damage_+%_final", -10 },
	},
	stats = {
		"base_is_projectile",
		"always_pierce",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, cooldown = 3, levelRequirement = 83, storedUses = 1, },
	},
}
skills["AzmeriHydraForkArrow"] = {
	name = "Fork Arrow",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.33,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "active_skill_damage_+%_final", 50 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, cooldown = 8, levelRequirement = 83, storedUses = 1, },
	},
}
skills["AzmeriHydraHatred"] = {
	name = "Hatred",
	hidden = true,
	color = 2,
	description = "Casts an aura that grants extra cold damage based on physical damage to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Cold] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["physical_damage_%_to_add_as_cold"] = {
			mod("PhysicalDamageGainAsCold", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["hatred_aura_cold_damage_+%_final"] = {
			mod("ColdDamage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "physical_damage_%_to_add_as_cold", 20 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "hatred_aura_cold_damage_+%_final", 16 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["DarkMarionetteExplode"] = {
	name = "On Death Explode",
	hidden = true,
	color = 4,
	baseFlags = {
		area = true,
	},
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true },
	baseMods = {
		skill("FireMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("FireMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("PhysicalMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("PhysicalMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("LightningMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("LightningMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("showAverage", true),
		skill("radius", 22),
	},
	stats = {
	},
	levelMods = {
	},
	levels = {
		[1] = { cost = { } },
	},
}

--Scorch is not showing up as a config option
skills["DarkMarionetteExplodePerfect"] = {
	name = "On Death Explode",
	hidden = true,
	color = 4,
	baseFlags = {
		area = true,
	},
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true },
	baseMods = {
		skill("FireMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("FireMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("PhysicalMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("PhysicalMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("LightningMin", 1, { type = "PerStat", stat = "Life", div = 20 }),
		skill("LightningMax", 1, { type = "PerStat", stat = "Life", div = 20 }),
		mod("EnemyScorchChance", "BASE", 100),
		skill("showAverage", true),
		skill("radius", 22),
	},
	stats = {
	},
	levelMods = {
	},
	levels = {
		[1] = { cost = { } },
	},
}

skills["AzmeriArgusMeleeAtAnimationSpeed"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { baseMultiplier = 0.3, damageEffectiveness = 0.3, levelRequirement = 1, },
	},
}
skills["GAAzmeriRobotArgusSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, cooldown = 10, damageEffectiveness = 0.75, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriKudukuShockNova"] = {
	name = "Shock Nova",
	hidden = true,
	color = 3,
	baseEffectiveness = 5.25,
	incrementalEffectiveness = 0.050000000745058,
	description = "Casts a ring of Lightning around you, followed by a larger Lightning nova. Each effect hits enemies caught in their area with Lightning Damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.6,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "newshocknova_first_ring_damage_+%_final", -60 },
		{ "base_chance_to_shock_%", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 65 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 6, critChance = 5, levelRequirement = 7, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriKudukuSparkExtraProj"] = {
	name = "Spark",
	hidden = true,
	color = 3,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3500 },
		{ "number_of_additional_projectiles", 3 },
		{ "base_projectile_speed_+%", 30 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 6, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriKudukuWarp"] = {
	name = "Lightning Warp",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.5,
	incrementalEffectiveness = 0.050000000745058,
	description = "Waits for a duration before teleporting to a targeted destination, with the duration based on the distance and your movement speed. When the teleport occurs, lightning damage is dealt to the area around both where the player was and where they teleported to. Casting again will queue up multiple teleportations to occur in sequence.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Movement] = true, [SkillType.Lightning] = true, [SkillType.AreaSpell] = true, [SkillType.Travel] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "variable_duration_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "skill_effect_duration_+%", -80 },
		{ "base_cast_speed_+%", 150 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 2, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriKudukuWrath"] = {
	name = "Wrath",
	hidden = true,
	color = 3,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.028500000014901,
	description = "Casts an aura that adds lightning damage to the attacks of you and your allies, and makes your spells deal more lightning damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Lightning] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["attack_minimum_added_lightning_damage"] = {
			mod("LightningMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_lightning_damage"] = {
			mod("LightningMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["wrath_aura_spell_lightning_damage_+%_final"] = {
			mod("LightningDamage", "MORE", nil, ModFlag.Spell, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "wrath_aura_spell_lightning_damage_+%_final", 18 },
	},
	stats = {
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
	},
	levels = {
		[1] = { 0.019999999552965, 0.28000000119209, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeAtAnimationSpeedCold"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["AzmeriAdmiralDoubleStrikeTriggered"] = {
	name = "Double Strike",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 75 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.7, damageEffectiveness = 0.7, levelRequirement = 1, },
	},
}
skills["AzmeriAdmiralDashThrustTriggered"] = {
	name = "Dash thrust",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"is_area_damage",
		"always_freeze",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["AzmeriAdmiralGeyserDamage"] = {
	name = "Geyser Damage",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.82499998807907,
	incrementalEffectiveness = 0.046250000596046,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "chill_minimum_slow_%_from_skill", 30 },
		{ "active_skill_chill_duration_+%_final", 100 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -50 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriAdmiralTidalWave"] = {
	name = "Tidal Wave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 5,
	baseFlags = {
		spell = true,
		triggerable = true,
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 25, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AzmeriAdmiralDashMortars"] = {
	name = "Dash Mortars",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.045000001788139,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 10 },
		{ "projectile_minimum_range", 5 },
		{ "number_of_projectiles_override", 2 },
		{ "active_skill_area_of_effect_radius_+%_final", -33 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_direction",
		"mortar_projectile_scale_animation_speed_instead_of_projectile_speed",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriAdmiralCannonball"] = {
	name = "Cannonball",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.3499999046326,
	incrementalEffectiveness = 0.037500001490116,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriAdmiralPrecision"] = {
	name = "Precision",
	hidden = true,
	color = 2,
	baseEffectiveness = 15,
	incrementalEffectiveness = 0.0070000002160668,
	description = "Casts an aura that grants accuracy and critical strike chance to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["accuracy_rating"] = {
			mod("Accuracy", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["skill_buff_grants_critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_base_radius_+", 50 },
	},
	stats = {
		"accuracy_rating",
		"skill_buff_grants_critical_strike_chance_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 0.55150002241135, 0.054299999028444, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriSawbladeAnimatedWeaponCyclone"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", 150 },
		{ "cyclone_movement_speed_+%_final", 80 },
		{ "cyclone_extra_distance", 30 },
		{ "active_skill_damage_+%_final", -50 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 68, },
	},
}
skills["AzmeriDoubleSlashAnimatedWeapon"] = {
	name = "Lacerate",
	hidden = true,
	color = 2,
	description = "Slashes twice, releasing waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. The slashes will have a chance to inflict bleeding in Blood Stance, or have a wider angle in Sand Stance. Can be used with Axes and Swords. You are in Blood Stance by default.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 70 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 68, },
	},
}
skills["AzmeriSwordStormCascade"] = {
	name = "Sword Cascade",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3400000333786,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("radiusLabel", "Sword explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Swords fall:"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "fire_storm_fireball_delay_ms", 190 },
		{ "skill_override_pvp_scaling_time_ms", 450 },
		{ "upheaval_number_of_spikes", 10 },
		{ "base_secondary_skill_effect_duration", 1500 },
		{ "active_skill_area_of_effect_radius_+%_final", -50 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 10, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriBarrageDemonSpineProjectile"] = {
	name = "Spine Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 2 },
		{ "spell_maximum_action_distance_+%", -30 },
		{ "base_projectile_speed_+%", 90 },
		{ "active_skill_physical_damage_+%_final", 30 },
	},
	stats = {
		"base_is_projectile",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["AzmeriBarrageDemonRainOfSpines"] = {
	name = "Rain of Arrows",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Fires a large number of arrows into the air, to land at the target after a short delay.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"base_is_projectile",
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.425, damageEffectiveness = 1.425, levelRequirement = 0, },
	},
}
skills["AzmeriBarrageDemonSpinestorm"] = {
	name = "Firestorm",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.125,
	incrementalEffectiveness = 0.042500000447035,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.9,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
		triggerable = true,
	},
	baseMods = {
		skill("radiusLabel", "Spine explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Spines fall:"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "fire_storm_fireball_delay_ms", 90 },
		{ "spell_maximum_action_distance_+%", 50 },
		{ "firestorm_base_area_of_effect_+%", -51 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -30 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeAtAnimationSpeedChaos"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 25 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["AzmeriBasiliskShoulderMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.039500001817942,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 8 },
		{ "projectile_minimum_range", 15 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "base_poison_duration_+%", 100 },
		{ "base_chance_to_poison_on_hit_%", 60 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriBasiliskComboThrust"] = {
	name = "Combo Thrust",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 0.4, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskComboSlam"] = {
	name = "Combo Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 1.625, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskDecapitateRightToLeft"] = {
	name = "Decapitate",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_poison_duration_+%", 50 },
		{ "base_poison_damage_+%", 0 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskDecapThrust"] = {
	name = "Decapitate Thrust",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"is_area_damage",
		"global_maim_on_hit",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 0.4, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskWyvernFlight"] = {
	name = "Wyvern Flight",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_poison_damage_+%", 100 },
		{ "base_chance_to_poison_on_hit_%", 60 },
	},
	stats = {
		"base_is_projectile",
		"always_pierce",
		"projectile_uses_contact_position",
		"visual_hit_effect_chaos_is_green",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.45, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskDualProjectile"] = {
	name = "Dual Projectile",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 174 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_chance_to_poison_on_hit_%", 60 },
	},
	stats = {
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"always_pierce",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 0.2, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskDualProjectileImpact"] = {
	name = "Projectile Impact",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 40 },
		{ "base_poison_duration_+%", 50 },
		{ "base_chance_to_poison_on_hit_%", 60 },
	},
	stats = {
		"is_area_damage",
		"global_bleed_on_hit",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskWyvernGroundCollide"] = {
	name = "Ground Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "base_chance_to_poison_on_hit_%", 40 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 1.25, levelRequirement = 0, },
	},
}
skills["AzmeriBasiliskShoulderMortar2"] = {
	name = "Mortar 2",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.041000001132488,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 13 },
		{ "projectile_minimum_range", 15 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 60 },
		{ "base_poison_duration_+%", 100 },
		{ "base_chance_to_poison_on_hit_%", 60 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["ABTTAzmeriBasaliskShroud"] = {
	name = "Poison DoT",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.032499998807907,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_chaos_damage_taken_per_minute"] = {
			skill("ChaosDot", nil),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		buff = true,
		duration = true,
		triggerable = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"base_chaos_damage_taken_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 0.1, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriCasterDemonProjectile"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.414999961853,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 139 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 1, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["DeceleratingProjectileAzmeriCasterDemon"] = {
	name = "Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"cast_time_overrides_attack_duration",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 5, critChance = 1, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["DeceleratingProjectileAzmeriCasterDemonExplode"] = {
	name = "Explode",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.1500000953674,
	incrementalEffectiveness = 0.04450000077486,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"always_shock",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 1, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriCasterDemonSpellDamageAura"] = {
	name = "Zealotry",
	hidden = true,
	color = 3,
	description = "Casts an aura that grants bonuses to damage and critical strike chance of spells to you and your allies, and gives a chance to create Consecrated Ground against stronger enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["spell_damage_aura_spell_damage_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Spell, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, ModFlag.Spell, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "create_consecrated_ground_on_hit_%_vs_rare_or_unique_enemy", 10 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"spell_damage_aura_spell_damage_+%_final",
		"spell_critical_strike_chance_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 10, 20, cooldown = 0.5, levelRequirement = 0, storedUses = 1, statInterpolation = { 2, 2, }, },
		[2] = { 12, 29, cooldown = 0.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 2, 2, }, },
	},
}
skills["AzmeriCycloneDemonCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "corrupted_blood_on_hit_%_average_damage_to_deal_per_minute_per_stack", 100 },
		{ "corrupted_blood_on_hit_duration", 4000 },
		{ "corrupted_blood_on_hit_num_stacks", 2 },
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { levelRequirement = 3, },
	},
}
skills["AzmeriCycloneDemonDesecratedGroundCyclone"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	baseMods = {
		mod("CooldownRecovery", "OVERRIDE", 0),
	},
	constantStats = {
		{ "desecrated_ground_art_variation", 1 },
		{ "attack_speed_+%", 120 },
		{ "cyclone_movement_speed_+%_final", 120 },
		{ "cyclone_extra_distance", 40 },
		{ "cyclone_places_ground_desecration_chaos_damage_per_minute", 4250 },
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 0.575, cooldown = 5, levelRequirement = 4, storedUses = 1, },
	},
}
skills["GAExpeditionDeathKnightSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		attack = true,
		area = true,
		triggerable = true,
	},
	constantStats = {
		{ "main_hand_base_maximum_attack_distance", 35 },
		{ "skill_physical_damage_%_to_convert_to_cold", 20 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 35, attackSpeedMultiplier = -10, baseMultiplier = 1.4025, cooldown = 4, levelRequirement = 0, storedUses = 1, statInterpolation = { 2, }, },
		[2] = { 0, attackSpeedMultiplier = -10, baseMultiplier = 1.4025, cooldown = 4, levelRequirement = 68, storedUses = 1, statInterpolation = { 2, }, },
	},
}
skills["GSExpeditionDeathKnightNova"] = {
	name = "Nova Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.036200001835823,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
		triggerable = true,
		hit = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 20 },
		{ "spell_maximum_action_distance_+%", -75 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1, cooldown = 2.5, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriDualStrikeDemonFireEnrage"] = {
	name = "Enrage",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.7889000177383,
	incrementalEffectiveness = 0.034000001847744,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["physical_damage_%_to_add_as_fire"] = {
			mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Enrage" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Enrage" }),
		},
		["attack_speed_+%"] = {
			mod("Speed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Enrage" }),
		},
		["minimum_fire_damage_to_return_when_hit"] = {
			mod("FireMin", "BASE", nil),
		},
		["maximum_fire_damage_to_return_when_hit"] = {
			mod("FireMax", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		hit = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "base_movement_velocity_+%", 50 },
		{ "attack_speed_+%", 50 },
	},
	stats = {
		"minimum_fire_damage_to_return_when_hit",
		"maximum_fire_damage_to_return_when_hit",
		"physical_damage_%_to_add_as_fire",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 100, cooldown = 12, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["AzmeriDualStrikeDemonDualStrike"] = {
	name = "Dual Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Attacks with both weapons, dealing the damage of both in one strike. Dual wield only. Does not work with wands.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.DualWieldOnly] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	stats = {
		"skill_double_hits_when_dual_wielding",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 0, },
	},
}
skills["GSAncestralDruidFlaskExplode"] = {
	name = "Poisonous Concoction",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.25,
	incrementalEffectiveness = 0.037500001490116,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "base_chance_to_poison_on_hit_%", 100 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GAHeistRobotHoundStomp"] = {
	name = "Stomp",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"global_knockback",
		"is_area_damage",
		"always_stun",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 19, },
		[3] = { levelRequirement = 20, },
		[4] = { levelRequirement = 84, },
	},
}
skills["GSRoboHoundBellyDamage"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGeofriSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -47 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"voll_slam_damage_+%_final_at_centre",
		"is_area_damage",
	},
	levels = {
		[1] = { 100, baseMultiplier = 1.15, cooldown = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["TalismanT2EnfeebleAura"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("CooldownRecovery", "OVERRIDE", 15),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "accuracy_rating_+%", -40 },
		{ "enfeeble_damage_+%_final", -40 },
		{ "enfeeble_damage_+%_vs_rare_or_unique_final", -15 },
		{ "active_skill_area_of_effect_radius_+%_final", -10 },
	},
	stats = {
		"curse_apply_as_aura",
	},
	levels = {
		[1] = { cooldown = 100, levelRequirement = 4, storedUses = 1, cost = { Mana = 35, }, },
	},
}
skills["TalismanT1Vulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
        ["receive_bleeding_chance_%_when_hit_by_attack"] = {
            mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
        },
        ["physical_damage_taken_+%"] = {
            mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
        },
    },
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("CooldownRecovery", "OVERRIDE", 15),
	},
	constantStats = {
		{ "physical_damage_taken_+%", 25 },
		{ "receive_bleeding_chance_%_when_hit_by_attack", 25 },
	},
	stats = {
		"curse_apply_as_aura",
	},
	levels = {
		[1] = { cooldown = 100, levelRequirement = 1, storedUses = 1, },
	},
}
skills["TalismanT1TemporalChains"] = {
	name = "Temporal Chains",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curses all enemies in an area, lowering their action speed and making other effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("CooldownRecovery", "OVERRIDE", 15),
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "temporal_chains_action_speed_+%_final", -20 },
		{ "buff_time_passed_+%_other_than_temporal_chains", -25 },
		{ "temporal_chains_action_speed_+%_vs_rare_or_unique_final", -10 },
		{ "active_skill_area_of_effect_radius_+%_final", 9 },
	},
	stats = {
		"curse_apply_as_aura",
	},
	levels = {
		[1] = { cooldown = 100, levelRequirement = 4, storedUses = 1, cost = { Mana = 35, }, },
	},
}
skills["AzmeriGeofriSmite"] = {
	name = "Smite",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.028000000864267,
	description = "Performs a melee attack, and causes lightning to strike a nearby enemy, dealing damage in an area. Each target can only be hit once by this skill. Hitting an enemy grants an aura for a duration. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Damage] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Aura] = true, [SkillType.Buff] = true, [SkillType.Lightning] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["minimum_added_lightning_damage_from_skill"] = {
			mod("LightningMin", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", neg = true, var = "AffectedByVaalSmite" }),
		},
		["maximum_added_lightning_damage_from_skill"] = {
			mod("LightningMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }, { type = "Condition", neg = true, var = "AffectedByVaalSmite" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
		aura = true,
		buff = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "base_skill_effect_duration", 4000 },
		{ "base_smite_number_of_targets", 1 },
		{ "smite_lightning_target_range", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "active_skill_base_secondary_area_of_effect_radius", 80 },
		{ "active_skill_secondary_area_of_effect_description_mode", 4 },
	},
	stats = {
		"minimum_added_lightning_damage_from_skill",
		"maximum_added_lightning_damage_from_skill",
		"visual_hit_effect_elemental_is_holy",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { 0.10000000149012, 1.8999999761581, baseMultiplier = 1.5625, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGoddessSpiritMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.91109997034073,
	incrementalEffectiveness = 0.050999999046326,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		projectile = true,
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 20 },
		{ "base_cast_speed_+%", -25 },
		{ "projectile_minimum_range", 15 },
		{ "ignite_art_variation", 2 },
		{ "monster_projectile_variation", 1 },
		{ "base_number_of_projectiles", 5 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_is_projectile",
		"distribute_projectiles_over_contact_points",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 81, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGoddessOfferingOfJudgement"] = {
	name = "Fire Pillar",
	hidden = true,
	color = 4,
	baseEffectiveness = 10,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriGoddessOfferingOfJudgementChaos"] = {
	name = "Chaos Pillar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.666699886322,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"is_area_damage",
		"base_is_projectile",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriGoddessBeam"] = {
	name = "Goddess Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 10,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"is_area_damage",
		"disable_skill_repeats",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 18, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["ABTTAzmeriGoddessAura"] = {
	name = "Skeleton Buff",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.0080000003799796,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["attack_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Skeleton" }),
		},
		["attack_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Skeleton" }),
		},
		["attack_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Skeleton" }),
		},
		["attack_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Skeleton" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		buff = true,
	},
	baseMods = {
		skill("buffMinions", true),
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0.60000002384186, 1, levelRequirement = 0, statInterpolation = { 3, 3, 3, 3, }, },
	},
}
skills["AzmeriGoddessDiscipline"] = {
	name = "Discipline",
	hidden = true,
	color = 3,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.0089999996125698,
	description = "Casts an aura that grants additional energy shield and increased energy shield recharge rate to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["energy_shield_recharge_rate_+%"] = {
			mod("EnergyShieldRecharge", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_energy_shield"] = {
			mod("EnergyShield", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "energy_shield_recharge_rate_+%", 30 },
	},
	stats = {
		"base_maximum_energy_shield",
	},
	levels = {
		[1] = { 1, cooldown = 0.5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["MeleeAtAnimationSpeedLightning"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["AzmeriBirdBeam"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
	},
	constantStats = {
		{ "skill_range_+%", -100 },
		{ "active_skill_area_of_effect_radius_+%_final", -50 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriBirdScreechExposure"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.1499999761581,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["lightning_exposure_on_hit_magnitude"] = {
			mod("LightningExposure", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Lightning Exposure" }),
		},
	},
	baseFlags = {
		spell = true,
		hit = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "lightning_exposure_on_hit_magnitude", -20 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 25, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriBirdDashZap"] = {
	name = "Zap",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, critChance = 15, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriBirdGrace"] = {
	name = "Grace",
	hidden = true,
	color = 2,
	baseEffectiveness = 15,
	incrementalEffectiveness = 0.025000000372529,
	description = "Casts an aura that grants evasion to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["grace_aura_evasion_rating_+%_final"] = {
			mod("Evasion", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_evasion_rating"] = {
			mod("Evasion", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "grace_aura_evasion_rating_+%_final", 30 },
	},
	stats = {
		"base_evasion_rating",
	},
	levels = {
		[1] = { 1, cooldown = 0.5, levelRequirement = 29, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriLightningMelee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 75 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 0, baseMultiplier = 0.3281, levelRequirement = 1, statInterpolation = { 2, }, },
	},
}
skills["AzmeriPhantasmExplode"] = {
	name = "Explode",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5899999141693,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 12, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
--Sap is not showing up as a config option
skills["AzmeriPhantasmExplodeSap"] = {
	name = "Explode",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	statMap = {
		["chance_to_inflict_sapped_%"] = {
			mod("EnemySapChance", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "chance_to_inflict_sapped_%", 100 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 8, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriPhantasmClarity"] = {
	name = "Clarity",
	hidden = true,
	color = 3,
	baseEffectiveness = 45,
	incrementalEffectiveness = 0.0070000002160668,
	description = "Casts an aura that grants mana regeneration to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_mana_regeneration_rate_per_minute"] = {
			mod("ManaRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"base_mana_regeneration_rate_per_minute",
	},
	levels = {
		[1] = { 1139, levelRequirement = 1, statInterpolation = { 1, }, },
	},
}
skills["AzmeriMegaSkeletonHeavyMelee"] = {
	name = "Heavy Melee",
	hidden = true,
	color = 4,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "melee_range_+", 30 },
		{ "attack_repeat_offset_left_of_target", 8 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, cooldown = 4, damageEffectiveness = 1.5, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AzmeriMegaSkeletonCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "main_hand_base_maximum_attack_distance", 13 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.15, cooldown = 5, damageEffectiveness = 1.15, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AzmeriOakSweep"] = {
	name = "Sweep",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Swings a two handed melee weapon in a circle, knocking back monsters around the character.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.15,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "base_stun_threshold_reduction_+%", 30 },
		{ "base_stun_duration_+%", 100 },
	},
	stats = {
		"active_skill_physical_damage_+%_final",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	notMinionStat = {
		"active_skill_physical_damage_+%_final",
	},
	levels = {
		[1] = { 20, levelRequirement = 19, statInterpolation = { 1, }, },
	},
}
skills["AzmeriOakLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "active_skill_damage_+%_final", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "base_stun_threshold_reduction_+%", 30 },
		{ "base_stun_duration_+%", 100 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { levelRequirement = 2, },
	},
}
skills["AzmeriOakVitality"] = {
	name = "Vitality",
	hidden = true,
	color = 1,
	baseEffectiveness = 315,
	incrementalEffectiveness = 0.0070000002160668,
	description = "Casts an aura that grants life regeneration to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"base_life_regeneration_rate_per_minute",
	},
	levels = {
		[1] = { 0.2301000058651, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriReaperMelee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "base_knockback_speed_+%", 300 },
		{ "knockback_distance_+%", -50 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"global_knockback",
		"determine_knockback_direction_from_melee_pattern",
	},
	levels = {
		[1] = { baseMultiplier = 0.6, levelRequirement = 1, },
	},
}
skills["GAAzmeriReaperLacerate"] = {
	name = "Lacerate",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.75, levelRequirement = 0, },
	},
}
skills["GAAzmeriReaperComboRightSlash"] = {
	name = "Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
		"global_knockback",
		"determine_knockback_direction_from_melee_pattern",
	},
	levels = {
		[1] = { baseMultiplier = 0.45, levelRequirement = 0, },
	},
}
skills["GAAzmeriReaperComboWhirl"] = {
	name = "Whirl",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
		"global_knockback",
	},
	levels = {
		[1] = { baseMultiplier = 0.6, levelRequirement = 0, },
	},
}
skills["MMSAzmeriShepherdTripleMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.25,
	incrementalEffectiveness = 0.037500001490116,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "projectile_spread_radius", 15 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSAzmeriShepherdVomitMortar"] = {
	name = "Vomit Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2339999675751,
	incrementalEffectiveness = 0.037500001490116,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.7,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "projectile_spread_radius", 5 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriShepherdBeamNuke"] = {
	name = "Beam Nuke",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.043000001460314,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "skill_physical_damage_%_to_convert_to_fire", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 7, critChance = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["ABTTAzmeriShepherdSpellDamage"] = {
	name = "Damage Buff",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
		buff = true,
	},
	stats = {
		"spell_damage_+%",
	},
	levels = {
		[1] = { 30, levelRequirement = 0, statInterpolation = { 2, }, },
		[2] = { 150, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["MonsterViperStrikeAtAnimationSpeed"] = {
	name = "Viper Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.64999997615814,
	incrementalEffectiveness = 0.025499999523163,
	description = "Hits enemies, converting some of your physical damage to chaos damage and inflicting poison which will be affected by modifiers to skill duration. If dual wielding, will strike with both weapons. Requires a claw, dagger or sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	constantStats = {
		{ "physical_damage_%_to_add_as_chaos", 25 },
		{ "base_chance_to_poison_on_hit_%", 100 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"poison_duration_is_skill_duration",
		"visual_hit_effect_chaos_is_green",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["AzmeriSpiderLeaderMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "number_of_monsters_to_summon", 1 },
		{ "alternate_minion", 184 },
		{ "projectile_minimum_range", 15 },
		{ "monster_projectile_variation", 1 },
		{ "projectile_spread_radius", 20 },
		{ "number_of_additional_projectiles", 3 },
		{ "active_skill_area_of_effect_radius_+%_final", -35 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"summoned_monsters_are_minions",
		"summoned_monsters_no_drops_or_experience",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 5, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["ABTTAzmeriSpiderLeaderAura"] = {
	name = "Spider Buff",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.0080000003799796,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["attack_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Spider" }),
		},
		["attack_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff", effectName = "Judgemental Spirit" }, { type = "MonsterTag", monsterTag = "Spider" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		buff = true,
	},
	baseMods = {
		skill("buffMinions", true),
	},
	stats = {
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
	},
	levels = {
		[1] = { 0.89999997615814, 1.2999999523163, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriZombieCausticGroundWhenHit"] = {
	name = "Caustic Ground",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.666699886322,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		flag("dotIsCausticGround"),
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "cast_on_any_damage_taken_%", 100 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 46.666666915019, cooldown = 4, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["ElderTentacleMinionProjectile"] = {
	name = "Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.75,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 44 },
		{ "skill_visual_scale_+%", 50 },
		{ "base_chance_to_shock_%", 60 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["ElderTentacleMinionProjectileEpic"] = {
	name = "Projectile Large",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.051249999552965,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 3,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 48 },
		{ "skill_visual_scale_+%", 100 },
		{ "base_chance_to_shock_%", 100 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 5, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.5, 1.5, cooldown = 5, critChance = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriTentacleMonsterBeam"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.033500000834465,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriTentacleMonsterShockExplode"] = {
	name = "Shock Explode",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.037500001490116,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, cooldown = 0.1, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriTentacleMinionLightningResistAura"] = {
	name = "Purity of Lightning",
	hidden = true,
	color = 3,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Lightning] = true, [SkillType.Instant] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["base_lightning_damage_resistance_%"] = {
			mod("LightningResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_lightning_damage_resistance_%"] = {
			mod("LightningResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	stats = {
		"base_lightning_damage_resistance_%",
		"base_maximum_lightning_damage_resistance_%",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 20, 0, 20, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 2, 2, 2, }, },
		[2] = { 31, 1, 50, cooldown = 0.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 2, 2, 2, }, },
	},
}
skills["AzmeriTigerSpiritFangs"] = {
	name = "Bite",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -60 },
		{ "active_skill_damage_+%_final", 20 },
		{ "active_skill_bleeding_damage_+%_final", 100 },
	},
	stats = {
		"is_area_damage",
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriTigerSpiritLacerate"] = {
	name = "lacerate",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 750 },
		{ "active_skill_attack_speed_+%_final", -32 },
		{ "active_skill_damage_+%_final", 20 },
	},
	stats = {
		"is_area_damage",
		"global_maim_on_hit",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriTigerSpiritTeleportSlam"] = {
	name = "Teleport Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 4.55,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", 14 },
		{ "active_skill_damage_+%_final", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", -33 },
	},
	stats = {
		"is_area_damage",
		"disable_attack_repeats",
	},
	levels = {
		[1] = { cooldown = 12, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriStampedeTiger"] = {
	name = "Stampede",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -65 },
	},
	stats = {
	},
	levels = {
		[1] = { baseMultiplier = 0.5, cooldown = 12, damageEffectiveness = 0.5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriTigerGeometryAttackStrafe"] = {
	name = "Strafe Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
	},
	stats = {
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { baseMultiplier = 1.2, levelRequirement = 0, },
	},
}
skills["AzmeriTigerHaste"] = {
	name = "Haste",
	hidden = true,
	color = 2,
	description = "Casts an aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "attack_speed_+%_granted_from_skill", 19 },
		{ "cast_speed_+%_granted_from_skill", 19 },
		{ "base_movement_velocity_+%", 13 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 0.5, levelRequirement = 0, storedUses = 1, },
	},
}
skills["ABTTAzmeriTurtleInvulnerability"] = {
	name = "Damage Immunity Buff",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		buff = true,
		duration = true,
		spell = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -80 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { cooldown = 30, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AzmeriTurtleDetermination"] = {
	name = "Determination",
	hidden = true,
	color = 1,
	baseEffectiveness = 15,
	incrementalEffectiveness = 0.025000000372529,
	description = "Casts an aura that grants armour to you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["determination_aura_armour_+%_final"] = {
			mod("Armour", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "determination_aura_armour_+%_final", 44 },
	},
	stats = {
		"base_physical_damage_reduction_rating",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 0.31400001049042, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["AzmeriOversoulRocksTriggered"] = {
	name = "Rain of Boulders",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.03999999910593,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["fire_storm_fireball_delay_ms"] = {
			skill("hitTimeOverride", nil ),
			div = 1000,
		},
		["firestorm_base_area_of_effect_+%"] = {
			mod("AreaOfEffectPrimary", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radiusLabel", "Rock explosion:"),
		skill("radiusSecondary", 25),
		skill("radiusSecondaryLabel", "Area in which Rocks fall:"),
	},
	constantStats = {
		{ "fire_storm_fireball_delay_ms", 300 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "firestorm_base_area_of_effect_+%", -50 },
		{ "base_skill_effect_duration", 900 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.40000000596046, 0.60000002384186, levelRequirement = 23, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriOversoulExplosionIgnite"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.25,
	baseFlags = {
		attack = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
		{ "spell_maximum_action_distance_+%", -80 },
		{ "active_skill_ignite_damage_+%_final", 500 },
		{ "base_chance_to_ignite_%", 50 },
		{ "ignite_duration_+%", 100 },
	},
	stats = {
		"is_area_damage",
		"global_cannot_crit",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.25, levelRequirement = 23, },
	},
}
skills["AzmeriOversoulLaserMaxShock"] = {
	name = "Laser",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.5,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.45,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "skill_repeat_count", 2 },
		{ "base_chance_to_shock_%", 100 },
		{ "active_skill_shock_duration_+%_final", 100 },
		{ "spell_maximum_action_distance_+%", -40 },
		{ "base_cast_speed_+%", 50 },
		{ "shock_maximum_magnitude_+", 20 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_cast_speed_+%_final",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_cast_speed_+%_final",
	},
	levels = {
		[1] = { 1.1000000238419, 1.6000000238419, 15, critChance = 5, levelRequirement = 23, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["AzmeriOversoulColdSnapTriggered"] = {
	name = "Cold Snap",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.75,
	incrementalEffectiveness = 0.046000000089407,
	description = "Creates a sudden burst of cold in a targeted area, damaging enemies. Also creates an expanding area which is filled with chilled ground, and deals cold damage over time to enemies. Enemies that die while in the area have a chance to grant Frenzy Charges. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Cascadable] = true, [SkillType.Duration] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "active_skill_base_secondary_area_of_effect_radius", 15 },
		{ "active_skill_base_tertiary_area_of_effect_radius", 30 },
		{ "base_skill_effect_duration", 7000 },
		{ "active_skill_area_of_effect_radius_+%_final", -50 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_cold_damage_to_deal_per_minute",
		"active_skill_chill_effect_+%_final",
		"base_chance_to_freeze_%",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0, 0, 40.000002483527, 200, 0, levelRequirement = 23, statInterpolation = { 3, 3, 3, 2, 2, }, },
	},
}
skills["AzmeriVikingCyclone"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	baseEffectiveness = 2.5859999656677,
	incrementalEffectiveness = 0.050000000745058,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	constantStats = {
		{ "attack_speed_+%", 100 },
		{ "base_skill_number_of_additional_hits", 1 },
		{ "cyclone_movement_speed_+%_final", 40 },
		{ "base_skill_effect_duration", 5000 },
		{ "cyclone_extra_distance", 30 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"cyclone_places_ground_fire_damage_per_minute",
		"is_area_damage",
	},
	levels = {
		[1] = { 41.666667597989, levelRequirement = 68, statInterpolation = { 3, }, },
	},
}
skills["AzmeriVikingUpheaval"] = {
	name = "Sunder",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.6667000055313,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 10 },
		{ "skill_physical_damage_%_to_convert_to_fire", 50 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"global_cannot_crit",
		"always_ignite",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 33.333334078391, baseMultiplier = 0.4375, levelRequirement = 66, statInterpolation = { 3, }, },
	},
}
skills["AfflictionMinionPhysSlamCircleSmall"] = {
	name = "Small Circle",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.15, levelRequirement = 0, },
	},
}
skills["AfflictionMinionPhysSlamCircleBig"] = {
	name = "Big Circle",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.33, levelRequirement = 0, },
	},
}
skills["AfflictionMinionPhysSlamCircleRectangle"] = {
	name = "Rectangle",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.4, levelRequirement = 0, },
	},
}
skills["GSHeistLightningVolatileExplode"] = {
	name = "Volatile",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "shock_minimum_damage_taken_increase_%", 20 },
		{ "shock_art_variation", 5 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"always_shock",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["HeistCultistLightningBolt"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.875,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -25 },
		{ "shock_art_variation", 5 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHeistLightningWaterfallHit"] = {
	name = "Waterfall",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.40000000596046,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "shock_art_variation", 5 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MPSHeistCultistStaffProjectileGreen"] = {
	name = "Green Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.166,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 166 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
		"visual_hit_effect_chaos_is_green",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 2.2, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSHeistScienceLightningDashImpact"] = {
	name = "Dash",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "shock_minimum_damage_taken_increase_%", 20 },
		{ "shock_art_variation", 5 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"always_shock",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriDemonTeethShot"] = {
	name = "Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.69999998807907,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 208 },
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
		{ "number_of_projectiles_override", 1 },
		{ "corrupted_blood_on_hit_%_average_damage_to_deal_per_minute_per_stack", 80 },
		{ "corrupted_blood_on_hit_duration", 4000 },
		{ "corrupted_blood_on_hit_num_stacks", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, baseMultiplier = 0.7, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GAAzmeriDemonLeapSlamDamage"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
		{ "corrupted_blood_on_hit_%_average_damage_to_deal_per_minute_per_stack", 80 },
		{ "corrupted_blood_on_hit_duration", 4000 },
		{ "corrupted_blood_on_hit_num_stacks", 3 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { -30, baseMultiplier = 1.4, levelRequirement = 1, statInterpolation = { 2, }, },
	},
}
skills["GAAzmeriDemonMeleeMiniSlam1"] = {
	name = "Claw Slam",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
		{ "corrupted_blood_on_hit_%_average_damage_to_deal_per_minute_per_stack", 100 },
		{ "corrupted_blood_on_hit_duration", 4000 },
		{ "corrupted_blood_on_hit_num_stacks", 1 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, levelRequirement = 1, },
	},
}
skills["MMSAzmeriDemonBloodVomitSmall"] = {
	name = "Small Vomit",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.82599997520447,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		hit = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"always_pierce",
		"mortar_projectile_scale_animation_speed_instead_of_projectile_speed",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSAzmeriDemonBloodVomitMedium"] = {
	name = "Medium Vomit",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.6729999780655,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		hit = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"always_pierce",
		"mortar_projectile_scale_animation_speed_instead_of_projectile_speed",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["MMSAzmeriDemonBloodVomitLarge"] = {
	name = "Large Vomit",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.75,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		hit = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
		{ "skill_physical_damage_%_to_convert_to_fire", 40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["GSAzmeriDemonBossCorruptExplode"] = {
	name = "Corrupted Blood Explode",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 0.5, critChance = 5, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriDemonPhysicalDamageAura"] = {
	name = "Pride",
	hidden = true,
	color = 1,
	description = "Casts an aura that causes nearby enemies to take more physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.AuraAffectsEnemies] = true, [SkillType.CanHaveBlessing] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["physical_damage_aura_nearby_enemies_physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "AuraDebuff", modCond = "PrideMinEffect" }),
			--This mod does not work as it it looking at the wrong actor
		},
		["physical_damage_aura_nearby_enemies_physical_damage_taken_+%_max"] = {
			mod("PhysicalDamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "AuraDebuff" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		aura = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
	},
	stats = {
		"physical_damage_aura_nearby_enemies_physical_damage_taken_+%",
		"physical_damage_aura_nearby_enemies_physical_damage_taken_+%_max",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 15, 30, cooldown = 5, levelRequirement = 1, storedUses = 1, statInterpolation = { 2, 2, }, },
		[2] = { 17, 34, cooldown = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 2, 2, }, },
	},
}
skills["EmptyActionAttackAzmeriGolemVSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.17,
	baseFlags = {
		attack = true,
	},
	constantStats = {
		{ "main_hand_base_maximum_attack_distance", 50 },
		{ "active_skill_attack_speed_+%_final", -25 },
	},
	stats = {
		"skill_cannot_be_stunned",
		"skill_cannot_be_knocked_back",
		"skill_cannot_be_interrupted",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { cooldown = 15, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AzmeriGolemVTurretProjectile"] = {
	name = "Turret Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		hit = true,
	},
	constantStats = {
		{ "number_of_projectiles_override", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGuardian4Slam"] = {
	name = "Unpowered Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_damage_+%_final", 85 },
		{ "active_skill_attack_speed_+%_final", -25 },
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["AzmeriGuardian4BeamGun"] = {
	name = "Spinning Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.625,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGolemLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.33,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "active_skill_damage_+%_final", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 75 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { cooldown = 7, levelRequirement = 1, storedUses = 1, },
	},
}
skills["AzmeriGolemBossWhipLeft"] = {
	name = "Turn Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "active_skill_damage_+%_final", 120 },
		{ "active_skill_attack_speed_+%_final", -25 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.625, levelRequirement = 0, },
	},
}
skills["AzmeriBossShockRifleSingle"] = {
	name = "Lightning Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.25,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "base_projectile_speed_+%", 50 },
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "active_skill_projectile_damage_+%_final", 625 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"projectile_uses_contact_position",
		"is_area_damage",
		"skill_cannot_be_interrupted",
		"skill_cannot_be_stunned",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AzmeriGolemRotateZap"] = {
	name = "Spinning Zap",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"cannot_stun",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["RevenantBossSpellProjectile"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.125,
	incrementalEffectiveness = 0.046000000089407,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 7 },
		{ "base_number_of_projectiles_in_spiral_nova", 9 },
		{ "projectile_spiral_nova_time_ms", 750 },
		{ "projectile_spiral_nova_angle", 50 },
		{ "projectile_spiral_nova_starting_angle_offset", -20 },
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 80 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.60000002384186, 1.3999999761581, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["MeleeFire"] = {
	name = "Basic Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["LegionKaruiMeleeLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 75 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, cooldown = 8, levelRequirement = 1, storedUses = 1, },
		[2] = { baseMultiplier = 0.75, cooldown = 8, levelRequirement = 19, storedUses = 1, },
		[3] = { baseMultiplier = 0.75, cooldown = 8, levelRequirement = 20, storedUses = 1, },
		[4] = { baseMultiplier = 0.75, cooldown = 8, levelRequirement = 84, storedUses = 1, },
	},
}
skills["LegionKaruiMeleeCombo2"] = {
	name = "Combo Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 75 },
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, baseMultiplier = 1.3, levelRequirement = 1, statInterpolation = { 2, }, },
		[2] = { 0, baseMultiplier = 1.3, levelRequirement = 19, statInterpolation = { 2, }, },
		[3] = { 1, baseMultiplier = 1.3, levelRequirement = 20, statInterpolation = { 2, }, },
		[4] = { 200, baseMultiplier = 1.3, levelRequirement = 84, statInterpolation = { 2, }, },
	},
}

skills["LegionMonsterProximityShield"] = {
	name = "Proximity Shield",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 18, levelRequirement = 0, storedUses = 1, },
	},
}
skills["EmpoweringHowlSpectre"] = {
	name = "Empowering Howl",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["empowering_cry_physical_damage_added_as_fire_damage_%"] = {
			mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Empowering Howl" }),
		},
	},
	baseFlags = {
		buff = true,
		area = true,
		duration = true,
		cooldown = true,
		warcry = true,
	},
	baseMods = {
		skill("buffAllies", true),
		skill("buffMinions", true),
	},
	constantStats = {
		{ "empowering_cry_physical_damage_added_as_fire_damage_%", 20 },
		{ "base_skill_effect_duration", 7500 },
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { cooldown = 12, levelRequirement = 1, storedUses = 1, },
	},
}
skills["DelveMelee"] = {
	name = "Default Attack (Cold DoT)",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.03999999910593,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "apply_azurite_debuff_on_hit_ms", 2500 },
	},
	stats = {
		"base_cold_damage_to_deal_per_minute",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { 25.000000558794, levelRequirement = 1, statInterpolation = { 3, }, },
	},
}
skills["DelveMeleeCold"] = {
	name = "Default Attack (Cold Hit)",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	stats = {
		"physical_damage_%_to_add_as_cold",
		"action_attack_or_cast_time_uses_animation_length",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 10, levelRequirement = 1, statInterpolation = { 2, }, },
		[2] = { 100, levelRequirement = 83, statInterpolation = { 2, }, },
	},
}
skills["DelveSpiderFlickerStrike"] = {
	name = "Flicker Strike (Cold Hit)",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_cold", 40 },
	},
	stats = {
		"ignores_proximity_shield",
		"melee_defer_damage_prediction",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 20, baseMultiplier = 0.35, cooldown = 4, levelRequirement = 1, storedUses = 1, },
	},
}
skills["MeleeAtAnimationSpeedLightning"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 75 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { baseMultiplier = 0.75, levelRequirement = 1, },
		[2] = { baseMultiplier = 0.75, levelRequirement = 19, },
		[3] = { baseMultiplier = 0.75, levelRequirement = 20, },
		[4] = { baseMultiplier = 0.75, levelRequirement = 84, },
	},
}
skills["CrucibleVendigoFlickerStrike"] = {
	name = "Flicker Strike",
	hidden = true,
	color = 4,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
	},
	stats = {
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 1, storedUses = 1, },
	},
}