-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Other active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["RepeatingShockwave"] = {
	name = "Abberath's Fury",
	hidden = true,
	color = 4,
	description = "While you run, this skill creates a small explosion with each step, dealing fire damage in an area around you.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_chance_to_ignite_%",
		"cast_on_gain_skill",
		"cannot_knockback",
		"spell_uncastable_if_triggerable",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"no_cost",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[7] = { 50, 75, 10, PvPDamageMultiplier = -80, critChance = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, },
		[20] = { 150, 225, 25, PvPDamageMultiplier = -80, critChance = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["Affliction"] = {
	name = "Affliction",
	hidden = true,
	color = 3,
	description = "Permanently Afflicts any of your damageable minions in a targeted area, causing them to take physical damage over time, at an accelerating rate. Each such minion causes you to regenerate life at a rate based on the current damage of it's Affliction debuff. Afflicted Minions explode if their life is lowered to a fifth of maximum.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Minion] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	fromTree = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_base_area_of_effect_radius", 30 },
		{ "minion_sacrifice_%_damage_to_regen", 20 },
		{ "minion_sacrifice_%_minion_life_to_degen", 8 },
		{ "minion_sacrifice_%_minion_life_explosion", 50 },
	},
	stats = {
	},
	levels = {
		[20] = { levelRequirement = 70, cost = { Mana = 33, }, },
	},
}
skills["AnimateGuardiansWeapon"] = {
	name = "Animate Guardian's Weapon",
	hidden = true,
	color = 2,
	description = "Animates a copy of your Animated Guardian's main-hand weapon to fight by your side.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, [SkillType.CreatesMinion] = true, [SkillType.Physical] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["active_skill_damage_+%_final"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "MORE", nil) }),
		},
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["number_of_animated_weapons_allowed"] = {
			mod("Multiplier:AnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 20000 },
	},
	stats = {
		"chance_to_trigger_on_animate_weapon_kill_%",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"base_number_of_animated_weapons_allowed",
		"chance_to_trigger_on_animate_guardian_kill_%",
	},
	notMinionStat = {
		"chance_to_trigger_on_animate_weapon_kill_%",
	},
	levels = {
		[18] = { 10, 108, 159, 13, cooldown = 0.05, levelRequirement = 64, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[20] = { 100, 126, 184, 14, cooldown = 0.05, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["ApproachingFlames"] = {
	name = "Approaching Flames",
	hidden = true,
	color = 4,
	description = "Become touched by the flames of the Cleansing Fire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["display_touch_of_fire"] = {
			flag("FlameTouched", { type = "GlobalEffect", effectType = "Buff" })
		}
	},
	baseFlags = {
		spell = true,
	},
	stats = {
		"display_touch_of_fire",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, },
	},
}
skills["SupportTriggerSpellOnBowAttack"] = {
	name = "Asenath's Chant",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"triggered_skill_uses_main_hand_or_averaged_attack_time_for_pvp_scaling",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[1] = { cooldown = 0.3, levelRequirement = 1, storedUses = 1, },
	},
}
skills["Barkskin"] = {
	name = "Barkskin",
	hidden = true,
	color = 2,
	description = "Adopt the power of the forest, gradually covering your body in bark. Getting hit by enemy attacks causes bark to be removed. You take reduced damage from physical attack hits the more bark builds up, but higher chance to evade when less covered in bark.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.ZeroReservation] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	statMap = {
		["physical_attack_damage_taken_+_per_barkskin_stack"] = {
			mod("PhysicalDamageTakenFromAttacks", "BASE", nil, 0, 0, { type = "Multiplier", var = "BarkskinStacks", limitVar = "BarkskinMaxStacks" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Barkskin" }),
		},
		["chance_to_evade_attacks_+%_final_per_missing_barkskin_stack"] = {
			mod("EvadeChance", "MORE", nil, 0, 0, { type = "Multiplier", var = "MissingBarkskinStacks" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Barkskin" }),
		},
		["max_barkskin_stacks"] = {
			mod("Multiplier:BarkskinMaxStacks", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
			mod("Multiplier:MissingBarkskinStacks", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "max_barkskin_stacks", 10 },
		{ "physical_attack_damage_taken_+_per_barkskin_stack", -30 },
		{ "chance_to_evade_attacks_+%_final_per_missing_barkskin_stack", 2 },
	},
	stats = {
		"physical_attack_damage_taken_+_per_barkskin_stack",
		"chance_to_evade_attacks_+%_final_per_missing_barkskin_stack",
	},
	levels = {
		[20] = { -30, 2, cooldown = 10, levelRequirement = 70, storedUses = 1, statInterpolation = { 1, 1, }, },
		[30] = { -60, 3, cooldown = 10, levelRequirement = 90, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["AilmentBearer"] = {
	name = "Unbound Avatar",
	hidden = true,
	color = 2,
	description = "Gain Unbound Fury by inflicting Elemental Ailments with Hits on enemies. Once you reach maximum Unbound Fury, consume it to become Unbound, vastly augmenting your Elemental prowess.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "display_max_ailment_bearer_charges", 100 },
		{ "display_ailment_bearer_charge_interval", 1 },
	},
	stats = {
		"base_deal_no_damage",
		"fixed_skill_effect_duration",
		"display_skill_fixed_duration_buff",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	levels = {
		[20] = { cooldown = 0.5, levelRequirement = 70, storedUses = 1, cost = { Mana = 13, }, },
	},
}
skills["AspectOfTheAvian"] = {
	name = "Aspect of the Avian",
	hidden = true,
	color = 4,
	description = "While active, grants the Avian's Might and Avian's Flight buffs in sequence. Avian's Might grants you and your minions a chance to deal Double Damage with hits for a duration. Avian's Flight grants you and your minions increased Movement Speed for a secondary duration.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["chance_to_deal_double_damage_%"] = {
			mod("DoubleDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Might", effectCond = "AviansMightActive" }),
		},
		["minion_chance_to_deal_double_damage_%"] = {
			mod("MinionModifier", "LIST", { mod = mod("DoubleDamageChance", "BASE", nil) }, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Might", effectCond = "AviansMightActive" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Flight", effectCond = "AviansFlightActive" }),
		},
		["minion_movement_speed_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", nil) }, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Flight", effectCond = "AviansFlightActive" }),
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "base_secondary_skill_effect_duration", 4000 },
	},
	stats = {
		"chance_to_deal_double_damage_%",
		"minion_chance_to_deal_double_damage_%",
		"base_movement_velocity_+%",
		"minion_movement_speed_+%",
	},
	levels = {
		[20] = { 10, 10, 10, 10, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
		[30] = { 12, 12, 14, 14, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, }, },
	},
}
skills["AspectOfTheCat"] = {
	name = "Aspect of the Cat",
	hidden = true,
	color = 4,
	description = "While active, grants the Cat's Stealth and Cat's Agility buffs in sequence. Cat's Stealth increases your critical strike chance, makes you harder to see, and gives you a chance to avoid damage for a short duration. Cat's Agility increases your attack and cast speed for a longer secondary duration.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["skill_buff_grants_critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Stealth", effectCond = "CatsStealthActive" }),
		},
		["avoid_damage_%"] = {
			mod("AvoidAllDamageFromHitsChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Stealth", effectCond = "CatsStealthActive" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Agility", effectCond = "CatsAgilityActive" }),
		},
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Agility", effectCond = "CatsAgilityActive" }),
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
		{ "base_secondary_skill_effect_duration", 6000 },
	},
	stats = {
		"skill_buff_grants_critical_strike_chance_+%",
		"avoid_damage_%",
		"stealth_+%",
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
	},
	levels = {
		[20] = { 100, 15, 100, 10, 10, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, },
		[30] = { 120, 15, 100, 16, 16, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, 1, 1, 1, 1, }, },
	},
}
skills["AspectOfTheCrab"] = {
	name = "Aspect of the Crab",
	hidden = true,
	color = 4,
	description = "While active, periodically adds Crab Barriers to you, and grants additional Physical Damage reduction for each Crab Barrier you have. All Crab Barriers are lost when you take physical damage from a hit.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Instant] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["physical_damage_reduction_%_per_crab_aspect_stack"] = {
			mod("PhysicalDamageReduction", "BASE", nil, 0, 0, { type = "Multiplier", var = "CrabBarrier" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["max_crab_aspect_stacks"] = {
			mod("CrabBarriersMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		cast = true,
	},
	constantStats = {
		{ "physical_damage_reduction_%_per_crab_aspect_stack", 2 },
	},
	stats = {
		"max_crab_aspect_stacks",
	},
	levels = {
		[20] = { 10, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, }, },
		[30] = { 12, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["AspectOfTheSpider"] = {
	name = "Aspect of the Spider",
	hidden = true,
	color = 4,
	description = "While active, periodically applies a Spider's Web debuff to nearby Enemies, and Hinders them. Each Spider's Web on an Enemy increases the Damage they take. Hinder reduces their movement speed.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["base_damage_taken_+%"] = {
			mod("DamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Spider's Web" })
		},
		["spider_aspect_max_web_count"] = {
			mod("Multiplier:SpiderWebApplyStackMax", "BASE", nil),
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("stackCount", 1, { type = "Multiplier", var = "SpiderWebApplyStack", limitVar = "SpiderWebApplyStackMax" }),
	},
	constantStats = {
		{ "base_damage_taken_+%", 5 },
		{ "base_skill_effect_duration", 6000 },
		{ "spider_aspect_web_interval_ms", 1000 },
	},
	stats = {
		"spider_aspect_max_web_count",
	},
	levels = {
		[20] = { 3, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, }, },
		[30] = { 4, cooldown = 0.5, levelRequirement = 1, manaReservationPercent = 25, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["SupportBloodMagicUniquePrismGuardian"] = {
	name = "Blood Magic",
	hidden = true,
	color = 1,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"base_skill_reserve_life_instead_of_mana",
		"base_skill_cost_life_instead_of_mana",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["BloodOffering"] = {
	name = "Blood Offering",
	hidden = true,
	color = 3,
	description = "Consumes a corpse, and sacrifices a portion of your life, granting your minions life regeneration based on the life sacrificed, and a bonus to damage. The skill consumes other nearby corpses, increasing the duration and life regeneration for each corpse consumed.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Minion] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Offering] = true, },
	statDescriptionScope = "offering_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	statMap = {
		["damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["blood_offering_%_of_life_to_lose"] = {
			mod("Multiplier:BloodOfferingLifeSacrificed", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "PerStat", stat = "LifeUnreserved", actor = "parent" }),
			div = 100,
		},
		["blood_offering_%_of_lost_life_to_regenerate_as_life_per_second"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }, { type = "Multiplier", var = "BloodOfferingLifeSacrificed" }),
			mod("Multiplier:BloodOfferingBaseRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "BloodOfferingLifeSacrificed" }),
			div = 100,
		},
		["blood_offering_life_regenerated_+%_final_per_corpse"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }, { type = "Multiplier", var = "BloodOfferingBaseRegen"},  { type = "Multiplier", var = "CorpseConsumedRecently", limit = 5 }),
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }, { type = "Multiplier", var = "BloodOfferingBaseRegen"},  { type = "Multiplier", var = "CorpseConsumedRecently", limit = 5, actor="parent" }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("buffMinions", true),
		skill("buffNotPlayer", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "offering_skill_effect_duration_per_corpse", 1000 },
		{ "blood_offering_%_of_life_to_lose", 20 },
		{ "blood_offering_%_of_lost_life_to_regenerate_as_life_per_second", 35 },
		{ "blood_offering_life_regenerated_+%_final_per_corpse", 10 },
		{ "damage_+%", 50 },
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { levelRequirement = 12, },
		[15] = { levelRequirement = 12, },
	},
}
skills["BloodSacramentUnique"] = {
	name = "Blood Sacrament",
	hidden = true,
	color = 4,
	baseEffectiveness = 7.5999999046326,
	description = "Channel this skill to reserve more and more of your life, building up power in a marker on the ground under you. Release to deal physical damage in an area based on how much life you reserved. Cannot be cast by Totems.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Channel] = true, [SkillType.AreaSpell] = true, [SkillType.HasReservation] = true, [SkillType.Physical] = true, [SkillType.Nova] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.2,
	fromItem = true,
	initialFunc = function(activeSkill, output)
		if output.LifeReservedPercent >= 100 then
			return
		end
		local lifeReservedPercent = activeSkill.skillData["LifeReservedPercent"] or 3
		local lifeReserved = activeSkill.skillData["LifeReservedBase"] or math.huge
		activeSkill.skillModList:NewMod("Multiplier:ChannelledLifeReservedPercentPerStage", "BASE", lifeReservedPercent, "Blood Sacrament")
		activeSkill.skillModList:NewMod("Multiplier:ChannelledLifeReservedPerStage", "BASE", lifeReserved, "Blood Sacrament")
	end,
	statMap = {
		["flameblast_hundred_times_radius_+_per_1%_life_reserved"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ChannelledLifeReservedPercentPerStage" }),
			div = 100,
		},
		["flameblast_damage_+%_final_per_10_life_reserved"] = {
			mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "Multiplier", var = "ChannelledLifeReservedPerStage", div = 10 }),
		},
		["flameblast_ailment_damage_+%_final_per_10_life_reserved"] = {
			mod("Damage", "MORE", nil, ModFlag.Ailment, 0, { type = "Multiplier", var = "ChannelledLifeReservedPerStage", div = 10 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 5),
		mod("Multiplier:BloodSacramentMaxStages", "BASE", 33),
		flag("HasUncancellableReservation", { type = "Condition", var = "BloodSacramentReservationEHP" }),
	},
	constantStats = {
		{ "flameblast_hundred_times_radius_+_per_1%_life_reserved", 30 },
		{ "flameblast_damage_+%_final_per_10_life_reserved", 80 },
		{ "flameblast_ailment_damage_+%_final_per_10_life_reserved", 40 },
		{ "life_leech_from_any_damage_permyriad", 200 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 0.35, critChance = 5, damageEffectiveness = 0.03, levelRequirement = 0, lifeReservationPercent = 2, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["BoneArmour"] = {
	name = "Bone Armour",
	hidden = true,
	color = 3,
	baseEffectiveness = 10,
	incrementalEffectiveness = 0.029999999329448,
	description = "Applies a buff to you and each of your minions, which will take some of the damage from enemy hits before being depleted. The buff also grants immunity to bleeding. Shares a cooldown with other Guard skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Guard] = true, [SkillType.Minion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	statMap = {
		["quick_guard_damage_absorbed_%"] = {
			mod("GuardAbsorbRate", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
		["quick_guard_damage_absorb_limit"] = {
			mod("GuardAbsorbLimit", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
	},
	baseFlags = {
		duration = true,
		spell = true,
	},
	baseMods = {
		mod("AvoidBleed", "BASE", 100, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
	},
	constantStats = {
		{ "quick_guard_damage_absorbed_%", 70 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"quick_guard_damage_absorb_limit",
		"base_deal_no_damage",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"display_skill_buff_grants_bleeding_immunity",
	},
	levels = {
		[20] = { 1, cooldown = 3, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["BoneNova"] = {
	name = "Bone Nova",
	hidden = true,
	color = 4,
	description = "Bones erupt around enemies you hit, dealing physical damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "number_of_additional_projectiles", 8 },
		{ "attack_trigger_on_hitting_bleeding_enemy_%", 100 },
		{ "monster_projectile_variation", 15 },
	},
	stats = {
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"cannot_cause_bleeding",
	},
	levels = {
		[20] = { PvPDamageMultiplier = -80, baseMultiplier = 1.5, cooldown = 0.5, damageEffectiveness = 1.5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["Brandsurge"] = {
	name = "Brandsurge",
	hidden = true,
	color = 3,
	baseEffectiveness = 6.5999999046326,
	incrementalEffectiveness = 0.03999999910593,
	description = "Overcharges your brands near the targeted area, causing them to accelerate how quickly they activate and expire. Deals damage in an area around each overcharged brand when it expires.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "brand_detonate_faster_activation_%_per_second", 35 },
		{ "brand_detonate_faster_duration_%_per_second", 150 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"display_brand_deonate_tag_conversion",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, cooldown = 1.5, critChance = 5, damageEffectiveness = 5.1, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, cost = { Mana = 20, }, },
	},
}
skills["ColdAegis"] = {
	name = "Cold Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes cold damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking cold damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	statMap = {
		["aegis_unique_shield_max_value"] = {
			mod("ColdAegisValue", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "aegis_unique_shield_max_value", 1000 },
		{ "active_skill_display_aegis_variation", 1 },
		{ "aegis_recharge_delay_ms", 10000 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["UniqueEnchantmentOfInfernoOnCrit"] = {
	name = "Commandment of Inferno",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5555999279022,
	incrementalEffectiveness = 0.035000000149012,
	description = "Drops a meteor from above on a nearby foe, dealing fire damage in an area around them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "fire_storm_fireball_delay_ms", 100 },
		{ "skill_override_pvp_scaling_time_ms", 450 },
		{ "cast_on_crit_%", 100 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
		"damage_cannot_be_reflected",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 2.4000000953674, 3.7999999523163, PvPDamageMultiplier = -80, cooldown = 3, critChance = 5, levelRequirement = 75, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["TriggeredConsecrate"] = {
	name = "Consecrate",
	hidden = true,
	color = 4,
	description = "Creates an area of Consecrated Ground, providing life regeneration and reducing the effect of curses for you and allies who stand in it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "life_regeneration_rate_per_minute_%", 360 },
		{ "cast_on_crit_%", 100 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["CreateFungalGroundOnKill"] = {
	name = "Contaminate",
	hidden = true,
	color = 4,
	description = "Creates a patch of Fungal Ground at the targeted location.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		duration = true,
		area = true,
	},
	constantStats = {
		{ "chance_to_cast_on_kill_%", 100 },
		{ "base_skill_effect_duration", 5000 },
	},
	stats = {
		"base_deal_no_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { cooldown = 1, levelRequirement = 1, storedUses = 1, },
	},
}
skills["Convocation"] = {
	name = "Convocation",
	baseTypeName = "Convocation",
	color = 4,
	description = "Recalls all minions that are following you to your location, and grants them a temporary life regeneration effect.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Minion] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("buffMinions", true),
		skill("buffNotPlayer", true),
	},
	qualityStats = {
		Default = {
			{ "skill_effect_duration_+%", 1 },
			{ "base_cooldown_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "base_skill_effect_duration", 2000 },
		{ "life_regeneration_rate_per_minute_%", 120 },
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[2] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[3] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[4] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[5] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[6] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[7] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[8] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[9] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
		[10] = { cooldown = 3, levelRequirement = 31, storedUses = 1, cost = { Mana = 6, }, },
	},
}
skills["CorpseWalk"] = {
	name = "Corpse Walk",
	hidden = true,
	color = 4,
	description = "Spawns corpses around you while you move, based on monsters in the current area. If you are using the Raise Spectre skill there is a chance to spawn spectral corpses matching your most recently raised Spectres. Spectral corpses cannot be interacted with except by Minion skills.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		area = true,
	},
	constantStats = {
		{ "desecrate_corpse_level", 100 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 60, },
	},
}
skills["SupportUniqueCosprisMaliceColdSpellsCastOnMeleeCriticalStrike"] = {
	name = "Cospri's Malice",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Cold, SkillType.Triggerable, SkillType.AND, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"unique_cospris_malice_cold_spells_triggered",
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["TriggeredSummonLesserShrine"] = {
	name = "Create Lesser Shrine",
	hidden = true,
	color = 4,
	description = "Creates a Lesser Shrine, which will grant a bonus when touched. The Lesser Shrine will disappear after a short duration, or when used. This skill starts on cooldown.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		flag("Condition:CanHaveLesserShrines", { type = "GlobalEffect", effectType = "Buff", effectName = "Shrines" }),
	},
	constantStats = {
		{ "chance_to_cast_on_kill_%", 100 },
		{ "base_skill_effect_duration", 10000 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { cooldown = 20, levelRequirement = 1, storedUses = 1, },
		[20] = { cooldown = 10, levelRequirement = 1, storedUses = 1, },
	},
}
skills["DeathAura"] = {
	name = "Death Aura",
	hidden = true,
	color = 4,
	description = "Casts an aura that deals Chaos Damage over Time to nearby Enemies. This skill cannot be cast by Totems.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.Aura] = true, [SkillType.AuraAffectsEnemies] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, [SkillType.HasReservation] = true, [SkillType.ZeroReservation] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		skill("radius", 30),
	},
	constantStats = {
		{ "base_chaos_damage_to_deal_per_minute", 75000 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[1] = { levelRequirement = 62, },
		[20] = { levelRequirement = 62, },
	},
}
skills["DeathWalk"] = {
	name = "Death Walk",
	hidden = true,
	color = 4,
	description = "While you walk, this skill causes corpses near your steps to explode, dealing fire damage in an area. The explosions of the corpses are not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true),
		skill("showAverage", true),
	},
	constantStats = {
		{ "corpse_explosion_monster_life_%", 5 },
	},
	stats = {
		"cast_on_gain_skill",
		"cannot_knockback",
		"spell_uncastable_if_triggerable",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"damage_cannot_be_reflected",
		"no_cost",
	},
	levels = {
		[20] = { PvPDamageMultiplier = -80, levelRequirement = 60, },
	},
}
skills["DeathWish"] = {
	name = "Death Wish",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1530001163483,
	incrementalEffectiveness = 0.032299999147654,
	description = "As you channel this spell, it spreads its effect to more of your minions. When you stop channelling, each affected minion explodes, and this skill deals spell damage around them.  The explosion of the minion is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Channel] = true, [SkillType.AreaSpell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Minion] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.2,
	fromItem = true,
	parts = {
		{
			name = "Channelling",
			spell = true,
			cast = false,
		},
		{
			name = "Minion Explosion",
			spell = false,
			cast = true,
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			local skillData = activeSkill.skillData
			skillData.FireBonusMin = output.Life * skillData.selfFireExplosionLifeMultiplier
			skillData.FireBonusMax = output.Life * skillData.selfFireExplosionLifeMultiplier
		end
	end,
	statMap = {
		["spell_minimum_base_fire_damage"] = {
			skill("FireMin", nil, { type = "SkillPart", skillPart = 2 }),
		},
		["spell_maximum_base_fire_damage"] = {
			skill("FireMax", nil, { type = "SkillPart", skillPart = 2 }),
		},
		["death_wish_attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_cast_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_movement_speed_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_hit_and_ailment_damage_+%_final_per_stage"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "DeathWishStage" }, { type = "SkillPart", skillPart = 2 }),
		},
		["death_wish_max_stages"] = {
			mod("Multiplier:DeathWishMaxStages", "BASE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 10, { type = "SkillPart", skillPart = 2 }),
		skill("buffMinions", true),
		skill("buffNotPlayer", true),
	},
	constantStats = {
		{ "skill_minion_explosion_life_%", 19 },
		{ "death_wish_hit_and_ailment_damage_+%_final_per_stage", 10 },
		{ "death_wish_attack_speed_+%", 40 },
		{ "death_wish_cast_speed_+%", 40 },
		{ "death_wish_movement_speed_+%", 40 },
		{ "death_wish_max_stages", 13 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, }, cost = { Mana = 7, }, },
	},
}
skills["Melee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["MeleeUseContactPoint"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["GemDetonateMines"] = {
	name = "Detonate Mines",
	baseTypeName = "Detonate Mines",
	color = 4,
	description = "Detonates a Mine, starting a Detonation Sequence which will detonate other Mines around it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "mine_detonation_speed_+%", 1 },
		},
	},
	constantStats = {
		{ "display_mine_deontation_mechanics_detonation_speed_+%_final_per_sequence_mine", 10 },
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[2] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[3] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[4] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[5] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[6] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[7] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[8] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[9] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
		[10] = { cooldown = 0.2, levelRequirement = 8, storedUses = 1, },
	},
}
skills["SupportDivineBlessing"] = {
	name = "Divine Blessing",
	description = "Supports aura skills that create permanent auras around you, changing their reservation to a cost and making them temporary. Cannot support banner or stance skills.",
	color = 1,
	support = true,
	requireSkillTypes = { SkillType.CanHaveBlessing, },
	addSkillTypes = { SkillType.Duration, SkillType.Blessing, SkillType.ReservationBecomesCost, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	statMap = {
		["support_aura_duration_base_buff_duration"] = {
			skill("auraDuration", nil),
			div = 1000,
		},
	},
	qualityStats = {
		Default = {
			{ "aura_effect_+%", 0.25 },
		},
	},
	constantStats = {
		{ "base_spell_cast_time_ms_override", 500 },
	},
	stats = {
		"support_aura_duration_base_buff_duration",
		"aura_effect_+%",
		"base_mana_cost_+",
		"skill_is_blessing_skill",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { 9000, 10, 90, levelRequirement = 31, statInterpolation = { 1, 1, 1, }, },
		[2] = { 9100, 11, 101, levelRequirement = 34, statInterpolation = { 1, 1, 1, }, },
		[3] = { 9200, 12, 108, levelRequirement = 36, statInterpolation = { 1, 1, 1, }, },
		[4] = { 9300, 13, 115, levelRequirement = 38, statInterpolation = { 1, 1, 1, }, },
		[5] = { 9400, 14, 121, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, },
		[6] = { 9500, 15, 128, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, },
		[7] = { 9600, 16, 135, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, },
		[8] = { 9700, 17, 141, levelRequirement = 46, statInterpolation = { 1, 1, 1, }, },
		[9] = { 9800, 18, 148, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, },
		[10] = { 9900, 19, 155, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, },
		[11] = { 10000, 20, 163, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, },
		[12] = { 10100, 21, 169, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, },
		[13] = { 10200, 22, 176, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, },
		[14] = { 10300, 23, 184, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, },
		[15] = { 10400, 24, 189, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, },
		[16] = { 10500, 25, 198, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, },
		[17] = { 10600, 26, 205, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, },
		[18] = { 10700, 27, 209, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, },
		[19] = { 10800, 28, 220, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, },
		[20] = { 10900, 29, 233, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, },
		[21] = { 11000, 30, 244, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, },
		[22] = { 11100, 31, 253, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, },
		[23] = { 11200, 32, 260, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, },
		[24] = { 11300, 33, 269, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, },
		[25] = { 11400, 34, 278, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, },
		[26] = { 11500, 35, 285, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, },
		[27] = { 11600, 36, 294, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, },
		[28] = { 11700, 37, 303, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, },
		[29] = { 11800, 38, 310, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, },
		[30] = { 11900, 39, 319, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, },
		[31] = { 11950, 39, 338, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, },
		[32] = { 12000, 40, 348, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, },
		[33] = { 12050, 40, 358, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, },
		[34] = { 12100, 41, 368, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, },
		[35] = { 12150, 41, 379, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, },
		[36] = { 12200, 42, 389, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, },
		[37] = { 12250, 42, 399, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, },
		[38] = { 12300, 43, 409, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, },
		[39] = { 12350, 43, 419, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, },
		[40] = { 12400, 44, 429, levelRequirement = 100, statInterpolation = { 1, 1, 1, }, },
	},
}
skills["DoryanisTouch"] = {
	name = "Doryani's Touch",
	hidden = true,
	color = 1,
	description = "The character uses their fist to slam the ground in front of them, with less attack speed, but more damage. This attack deals Lightning Damage to enemies in a large area, with a chance to Shock them. Cannot be used while wielding a Weapon. Cannot be Evaded.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Lightning] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 100 },
		{ "base_chance_to_shock_%", 40 },
	},
	stats = {
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 28, cost = { Mana = 10, }, },
		[2] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 31, cost = { Mana = 11, }, },
		[3] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 34, cost = { Mana = 11, }, },
		[4] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 37, cost = { Mana = 11, }, },
		[5] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 40, cost = { Mana = 12, }, },
		[6] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 42, cost = { Mana = 12, }, },
		[7] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 44, cost = { Mana = 12, }, },
		[8] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 46, cost = { Mana = 12, }, },
		[9] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 48, cost = { Mana = 12, }, },
		[10] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 50, cost = { Mana = 13, }, },
		[11] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 52, cost = { Mana = 13, }, },
		[12] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 54, cost = { Mana = 13, }, },
		[13] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 56, cost = { Mana = 13, }, },
		[14] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 58, cost = { Mana = 13, }, },
		[15] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 60, cost = { Mana = 13, }, },
		[16] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 62, cost = { Mana = 14, }, },
		[17] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 64, cost = { Mana = 14, }, },
		[18] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 66, cost = { Mana = 14, }, },
		[19] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 68, cost = { Mana = 14, }, },
		[20] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 70, cost = { Mana = 14, }, },
		[21] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 72, cost = { Mana = 15, }, },
		[22] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 74, cost = { Mana = 15, }, },
		[23] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 76, cost = { Mana = 15, }, },
		[24] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 78, cost = { Mana = 15, }, },
		[25] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 80, cost = { Mana = 15, }, },
		[26] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 82, cost = { Mana = 15, }, },
		[27] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 84, cost = { Mana = 16, }, },
		[28] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 86, cost = { Mana = 16, }, },
		[29] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 88, cost = { Mana = 16, }, },
		[30] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 90, cost = { Mana = 16, }, },
		[31] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 91, cost = { Mana = 16, }, },
		[32] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 92, cost = { Mana = 16, }, },
		[33] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 93, cost = { Mana = 16, }, },
		[34] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 94, cost = { Mana = 17, }, },
		[35] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 95, cost = { Mana = 17, }, },
		[36] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 96, cost = { Mana = 17, }, },
		[37] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 97, cost = { Mana = 17, }, },
		[38] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 98, cost = { Mana = 17, }, },
		[39] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 99, cost = { Mana = 17, }, },
		[40] = { attackSpeedMultiplier = -30, damageEffectiveness = 10, levelRequirement = 100, cost = { Mana = 17, }, },
	},
}
skills["ElementalAegis"] = {
	name = "Elemental Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes elemental damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking elemental damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	statMap = {
		["aegis_unique_shield_max_value"] = {
			mod("ElementalAegisValue", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "active_skill_display_aegis_variation", 2 },
		{ "aegis_recharge_delay_ms", 10000 },
	},
	stats = {
		"aegis_unique_shield_max_value",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[1] = { 50, levelRequirement = 1, statInterpolation = { 1, }, },
		[20] = { 1000, levelRequirement = 1, statInterpolation = { 1, }, },
	},
}
skills["SupportEarthbreaker"] = {
	name = "Earthbreaker",
	description = "Supports slam skills, causing them to summon an ancestor totem that uses the skill for you while you're near it. Being near it grants you increased area of effect for melee skills.",
	color = 1,
	support = true,
	requireSkillTypes = { SkillType.Slam, SkillType.Totemable, SkillType.AND, },
	addSkillTypes = { SkillType.SummonsTotem, },
	excludeSkillTypes = { SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	addFlags = {
		totem = true,
	},
	statMap = {
		["support_ancestor_slam_totem_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack),
		},
		["support_ancestor_slam_totem_damage_+%_final"] = {
			mod("Damage", "MORE", nil),
		},
		["ancestor_totem_grants_owner_area_of_effect_+%_with_melee_skills"] = {
			mod("AreaOfEffect", "INC", nil, ModFlag.Melee),
		},
	},
	qualityStats = {
		Default = {
			{ "totem_damage_+%", 0.5 },
		},
	},
	constantStats = {
		{ "base_totem_duration", 12000 },
		{ "base_totem_range", 50 },
		{ "ancestor_totem_parent_activiation_range", 70 },
		{ "summon_totem_cast_speed_+%", 50 },
		{ "support_ancestor_slam_totem_attack_speed_+%_final", -30 },
	},
	stats = {
		"totem_support_gem_level",
		"support_ancestor_slam_totem_damage_+%_final",
		"base_skill_is_totemified",
		"is_totem",
		"leap_slam_no_epk",
		"totem_targets_ignoring_action_distance",
		"force_lite_skill_effects",
		"support_totem_type_override_to_support_slam_ancestor",
	},
	notMinionStat = {
		"totem_support_gem_level",
	},
	levels = {
		[1] = { 8, 0, levelRequirement = 8, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[2] = { 10, 1, levelRequirement = 10, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[3] = { 13, 2, levelRequirement = 13, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[4] = { 17, 3, levelRequirement = 17, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[5] = { 21, 4, levelRequirement = 21, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[6] = { 25, 5, levelRequirement = 25, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[7] = { 29, 6, levelRequirement = 29, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[8] = { 33, 7, levelRequirement = 33, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[9] = { 37, 8, levelRequirement = 37, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[10] = { 40, 9, levelRequirement = 40, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[11] = { 43, 10, levelRequirement = 43, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[12] = { 46, 11, levelRequirement = 46, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[13] = { 49, 12, levelRequirement = 49, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[14] = { 52, 13, levelRequirement = 52, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[15] = { 55, 14, levelRequirement = 55, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[16] = { 58, 15, levelRequirement = 58, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[17] = { 61, 16, levelRequirement = 61, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[18] = { 64, 17, levelRequirement = 64, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[19] = { 67, 18, levelRequirement = 67, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[20] = { 70, 19, levelRequirement = 70, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[21] = { 72, 20, levelRequirement = 72, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[22] = { 74, 21, levelRequirement = 74, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[23] = { 76, 22, levelRequirement = 76, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[24] = { 78, 23, levelRequirement = 78, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[25] = { 80, 24, levelRequirement = 80, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[26] = { 82, 25, levelRequirement = 82, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[27] = { 84, 26, levelRequirement = 84, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[28] = { 86, 27, levelRequirement = 86, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[29] = { 88, 28, levelRequirement = 88, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[30] = { 90, 29, levelRequirement = 90, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[31] = { 91, 29, levelRequirement = 91, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[32] = { 92, 30, levelRequirement = 92, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[33] = { 93, 30, levelRequirement = 93, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[34] = { 94, 31, levelRequirement = 94, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[35] = { 95, 31, levelRequirement = 95, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[36] = { 96, 32, levelRequirement = 96, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[37] = { 97, 32, levelRequirement = 97, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[38] = { 98, 33, levelRequirement = 98, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[39] = { 99, 33, levelRequirement = 99, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
		[40] = { 100, 34, levelRequirement = 100, manaMultiplier = 100, statInterpolation = { 1, 1, }, },
	},
}
skills["SupportElementalPenetration"] = {
	name = "Elemental Penetration",
	description = "Supports any skill that hits enemies, making those hits penetrate enemy elemental resistances.",
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Damage, SkillType.Attack, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	qualityStats = {
		Default = {
			{ "elemental_damage_+%", 0.5 },
		},
	},
	stats = {
		"reduce_enemy_elemental_resistance_%",
	},
	levels = {
		[1] = { 14, levelRequirement = 31, manaMultiplier = 30, statInterpolation = { 1, }, },
		[2] = { 14, levelRequirement = 34, manaMultiplier = 30, statInterpolation = { 1, }, },
		[3] = { 15, levelRequirement = 36, manaMultiplier = 30, statInterpolation = { 1, }, },
		[4] = { 16, levelRequirement = 38, manaMultiplier = 30, statInterpolation = { 1, }, },
		[5] = { 17, levelRequirement = 40, manaMultiplier = 30, statInterpolation = { 1, }, },
		[6] = { 17, levelRequirement = 42, manaMultiplier = 30, statInterpolation = { 1, }, },
		[7] = { 18, levelRequirement = 44, manaMultiplier = 30, statInterpolation = { 1, }, },
		[8] = { 19, levelRequirement = 46, manaMultiplier = 30, statInterpolation = { 1, }, },
		[9] = { 20, levelRequirement = 48, manaMultiplier = 30, statInterpolation = { 1, }, },
		[10] = { 20, levelRequirement = 50, manaMultiplier = 30, statInterpolation = { 1, }, },
		[11] = { 21, levelRequirement = 52, manaMultiplier = 30, statInterpolation = { 1, }, },
		[12] = { 22, levelRequirement = 54, manaMultiplier = 30, statInterpolation = { 1, }, },
		[13] = { 23, levelRequirement = 56, manaMultiplier = 30, statInterpolation = { 1, }, },
		[14] = { 23, levelRequirement = 58, manaMultiplier = 30, statInterpolation = { 1, }, },
		[15] = { 24, levelRequirement = 60, manaMultiplier = 30, statInterpolation = { 1, }, },
		[16] = { 25, levelRequirement = 62, manaMultiplier = 30, statInterpolation = { 1, }, },
		[17] = { 26, levelRequirement = 64, manaMultiplier = 30, statInterpolation = { 1, }, },
		[18] = { 26, levelRequirement = 66, manaMultiplier = 30, statInterpolation = { 1, }, },
		[19] = { 27, levelRequirement = 68, manaMultiplier = 30, statInterpolation = { 1, }, },
		[20] = { 28, levelRequirement = 70, manaMultiplier = 30, statInterpolation = { 1, }, },
		[21] = { 29, levelRequirement = 72, manaMultiplier = 30, statInterpolation = { 1, }, },
		[22] = { 29, levelRequirement = 74, manaMultiplier = 30, statInterpolation = { 1, }, },
		[23] = { 30, levelRequirement = 76, manaMultiplier = 30, statInterpolation = { 1, }, },
		[24] = { 31, levelRequirement = 78, manaMultiplier = 30, statInterpolation = { 1, }, },
		[25] = { 32, levelRequirement = 80, manaMultiplier = 30, statInterpolation = { 1, }, },
		[26] = { 32, levelRequirement = 82, manaMultiplier = 30, statInterpolation = { 1, }, },
		[27] = { 33, levelRequirement = 84, manaMultiplier = 30, statInterpolation = { 1, }, },
		[28] = { 34, levelRequirement = 86, manaMultiplier = 30, statInterpolation = { 1, }, },
		[29] = { 35, levelRequirement = 88, manaMultiplier = 30, statInterpolation = { 1, }, },
		[30] = { 35, levelRequirement = 90, manaMultiplier = 30, statInterpolation = { 1, }, },
		[31] = { 36, levelRequirement = 91, manaMultiplier = 30, statInterpolation = { 1, }, },
		[32] = { 36, levelRequirement = 92, manaMultiplier = 30, statInterpolation = { 1, }, },
		[33] = { 36, levelRequirement = 93, manaMultiplier = 30, statInterpolation = { 1, }, },
		[34] = { 37, levelRequirement = 94, manaMultiplier = 30, statInterpolation = { 1, }, },
		[35] = { 37, levelRequirement = 95, manaMultiplier = 30, statInterpolation = { 1, }, },
		[36] = { 38, levelRequirement = 96, manaMultiplier = 30, statInterpolation = { 1, }, },
		[37] = { 38, levelRequirement = 97, manaMultiplier = 30, statInterpolation = { 1, }, },
		[38] = { 38, levelRequirement = 98, manaMultiplier = 30, statInterpolation = { 1, }, },
		[39] = { 39, levelRequirement = 99, manaMultiplier = 30, statInterpolation = { 1, }, },
		[40] = { 39, levelRequirement = 100, manaMultiplier = 30, statInterpolation = { 1, }, },
	},
}
skills["ElementalWarding"] = {
	name = "Elemental Warding",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.050000000745058,
	description = "Fires projectiles in all directions, converting all their physical damage to a random element, and grants a buff which makes you unaffected by curses for a duration. Removes curses on you when used.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Duration] = true, [SkillType.Buff] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	parts = {
		{
			name = "Convert to fire",
		},
		{
			name = "Convert to cold",
		},
		{
			name = "Convert to lightning",
		},
	},
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToFire", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 1 }),
		mod("SkillPhysicalDamageConvertToCold", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("SkillPhysicalDamageConvertToLightning", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	constantStats = {
		{ "number_of_additional_projectiles", 16 },
		{ "elemental_strike_physical_damage_%_to_convert", 100 },
		{ "cast_on_melee_hit_if_cursed_%", 100 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"disable_visual_hit_effect",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, cooldown = 1, critChance = 7, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["EmbraceMadness"] = {
	name = "Embrace Madness",
	hidden = true,
	color = 4,
	description = "Grants Glorious Madness. Using this skill again will remove Glorious Madness and the Touched Debuffs it inflicts, but you will be unable to Embrace Madness again until the cooldown expires.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, [SkillType.HasReservation] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "embrace_madness_amount_of_cooldown_to_gain_ms", 8000 },
		{ "glorious_madness_timer_ms", 2000 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 1, levelRequirement = 1, storedUses = 1, },
	},
}
skills["Envy"] = {
	name = "Envy",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.0999999046326,
	incrementalEffectiveness = 0.023000000044703,
	description = "Casts an aura that adds chaos damage to the attacks and spells of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Chaos] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["attack_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	stats = {
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
		"spell_minimum_added_chaos_damage",
		"spell_maximum_added_chaos_damage",
		"active_skill_base_radius_+",
		"base_deal_no_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 0.5, 0.69999998807907, 0.44999998807907, 0.60000002384186, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[15] = { 0.5, 0.69999998807907, 0.44999998807907, 0.60000002384186, 14, cooldown = 1.2, levelRequirement = 60, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
		[25] = { 0.5, 0.69999998807907, 0.44999998807907, 0.60000002384186, 24, cooldown = 1.2, levelRequirement = 80, manaReservationPercent = 50, storedUses = 1, statInterpolation = { 3, 3, 3, 3, 1, }, },
	},
}
skills["FireAegis"] = {
	name = "Fire Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes fire damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking fire damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	statMap = {
		["aegis_unique_shield_max_value"] = {
			mod("FireAegisValue", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "aegis_unique_shield_max_value", 1000 },
		{ "aegis_recharge_delay_ms", 10000 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["FireBurstOnHit"] = {
	name = "Fire Burst",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5199999809265,
	incrementalEffectiveness = 0.043999999761581,
	description = "A burst of flame errupts from the location of a hit, dealing fire damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	constantStats = {
		{ "cast_on_hit_%", 100 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 2, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 7, storedUses = 1, statInterpolation = { 3, 3, }, },
		[5] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 11, storedUses = 1, statInterpolation = { 3, 3, }, },
		[6] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 3, }, },
		[7] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, }, },
		[8] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 3, }, },
		[9] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, }, },
		[10] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 32, storedUses = 1, statInterpolation = { 3, 3, }, },
		[11] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, 3, }, },
		[12] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, }, },
		[13] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, }, },
		[14] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, }, },
		[15] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, }, },
		[16] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 56, storedUses = 1, statInterpolation = { 3, 3, }, },
		[17] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, }, },
		[18] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, }, },
		[19] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 67, storedUses = 1, statInterpolation = { 3, 3, }, },
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
		[21] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, }, },
		[22] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, }, },
		[23] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, }, },
		[24] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, }, },
		[25] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, }, },
		[26] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
		[27] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, },
		[28] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, }, },
		[29] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, }, },
		[30] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 1.5, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["FieryImpactHeistMaceImplicit"] = {
	name = "Fiery Impact",
	hidden = true,
	color = 4,
	description = "Deals attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Melee] = true, [SkillType.InbuiltTrigger] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_fire", 60 },
	},
	stats = {
		"is_area_damage",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[10] = { baseMultiplier = 2.8, cooldown = 1.8, damageEffectiveness = 2.8, levelRequirement = 30, storedUses = 1, },
		[15] = { baseMultiplier = 3.5, cooldown = 1.6, damageEffectiveness = 3.5, levelRequirement = 50, storedUses = 1, },
		[20] = { baseMultiplier = 4.2, cooldown = 1.4, damageEffectiveness = 4.2, levelRequirement = 70, storedUses = 1, },
	},
}
skills["AtziriUniqueStaffFlameblast"] = {
	name = "Flames of Judgement",
	hidden = true,
	color = 3,
	baseEffectiveness = 4.0500001907349,
	incrementalEffectiveness = 0.055500000715256,
	description = "Creates markers at your location and a targeted location, which grow over time based on cast speed, then explode, dealing fire damage. Cannot be supported by Spell Cascade.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("triggerSource", "Queen's Demand"),
	},
	constantStats = {
		{ "base_chance_to_ignite_%", 100 },
		{ "base_reduce_enemy_fire_resistance_%", 50 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_has_trigger_from_unique_item",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -30, cooldown = 1.5, critChance = 6, damageEffectiveness = 8.5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["Focus"] = {
	name = "Focus",
	hidden = true,
	color = 2,
	description = "Focus your power, granting yourself the Focused buff.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	cannotBeSupported = true,
	baseFlags = {
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"base_skill_is_instant",
		"fixed_skill_effect_duration",
		"display_skill_fixed_duration_buff",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	levels = {
		[1] = { cooldown = 8, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SupportTriggerSpellFromHelmet"] = {
	name = "Focus",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	constantStats = {
		{ "skill_triggered_when_you_focus_chance_%", 100 },
	},
	stats = {
	},
	levels = {
		[1] = { PvPDamageMultiplier = -80, cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["FogOfWar"] = {
	name = "Fog of War",
	hidden = true,
	color = 4,
	description = "Creates a Smoke Cloud in an area, which blinds enemies within it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "chance_to_cast_when_your_trap_is_triggered_%", 100 },
	},
	stats = {
	},
	levels = {
		[20] = { cooldown = 1, levelRequirement = 65, storedUses = 1, },
	},
}
skills["GluttonyOfElements"] = {
	name = "Gluttony of Elements",
	hidden = true,
	color = 4,
	description = "Casts an aura that causes taking elemental damage to heal you and nearby allies instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["immune_to_curses"] = {
			--Display Only
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 40),
		mod("AvoidCurse", "BASE", 100, 0, 0, { type = "GlobalEffect", effectType = "Aura", unscalable = true }),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
	},
	stats = {
		"base_elemental_damage_heals",
		"cannot_gain_souls",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
		"immune_to_curses",
	},
	levels = {
		[1] = { cooldown = 0.5, levelRequirement = 1, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[20] = { cooldown = 0.5, levelRequirement = 1, soulPreventionDuration = 14, storedUses = 1, vaalStoredUses = 1, cost = { Soul = 100, }, },
	},
}
skills["GoreShockwave"] = {
	name = "Gore Shockwave",
	hidden = true,
	color = 1,
	description = "Deals attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	constantStats = {
		{ "attack_trigger_on_melee_hit_with_atleast_150_strength_%", 100 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_cooldown_speed_+%",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_base_radius_+",
		"base_cooldown_speed_+%",
	},
	levels = {
		[1] = { 1, 0, baseMultiplier = 2.307, cooldown = 1, damageEffectiveness = 2.307, levelRequirement = 1, storedUses = 1, statInterpolation = { 1, 1, }, },
		[5] = { 2, 8, baseMultiplier = 2.497, cooldown = 1, damageEffectiveness = 2.497, levelRequirement = 1, storedUses = 1, statInterpolation = { 1, 1, }, },
	},
}
skills["SupportGreaterSpellEcho"] = {
	name = "Greater Spell Echo",
	hidden = true,
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Multicastable, },
	addSkillTypes = { },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.Triggered, SkillType.HasReservation, SkillType.Vaal, SkillType.Instant, SkillType.NonRepeatable, SkillType.CreatesMinion, SkillType.NOT, SkillType.AND, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	statMap = {
		["support_greater_spell_echo_spell_damage_+%_final_per_repeat"] = {
			mod("RepeatPerRepeatDamage", "MORE", nil, 0, 0, { type = "Condition", var = "HaveBladeVortex", neg = true }, { type = "Condition", var = "CastOnFrostbolt", neg = true }, { type = "Condition", varList = {"averageRepeat", "alwaysFinalRepeat"} }),
		},
		["support_greater_spell_echo_area_of_effect_+%_per_repeat"] = {
			mod("RepeatPerRepeatAreaOfEffect", "INC", nil, 0, 0, { type = "Condition", var = "CastOnFrostbolt", neg = true }),
		},
	},
	baseMods = {
		flag("Condition:HaveGreaterSpellEcho"),
	},
	constantStats = {
		{ "base_spell_repeat_count", 2 },
		{ "support_greater_spell_echo_spell_damage_+%_final_per_repeat", 30 },
		{ "support_greater_spell_echo_area_of_effect_+%_per_repeat", 50 },
	},
	stats = {
	},
	levels = {
		[30] = { levelRequirement = 90, manaMultiplier = 40, },
	},
}
skills["Icestorm"] = {
	name = "Icestorm",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Icy bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies and chilling them, as well as causing patches of chilled ground. Skill damage is based on Intelligence.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Cascadable] = true, [SkillType.ChillingArea] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	fromItem = true,
	statMap = {
		["skill_effect_duration_per_100_int"] = {
			mod("Duration", "BASE", nil, 0, 0, { type = "PerStat", stat = "Int", div = 100 }),
			div = 1000,
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radiusSecondary", 22),
		skill("radiusLabel", "Ice projectile:"),
		skill("radiusSecondaryLabel", "Target area:"),
	},
	constantStats = {
		{ "spell_minimum_base_cold_damage_+_per_10_intelligence", 5 },
		{ "spell_maximum_base_cold_damage_+_per_10_intelligence", 7 },
		{ "base_skill_effect_duration", 1000 },
		{ "fire_storm_fireball_delay_ms", 200 },
		{ "skill_override_pvp_scaling_time_ms", 450 },
		{ "firestorm_drop_ground_ice_duration_ms", 500 },
		{ "skill_effect_duration_per_100_int", 100 },
		{ "firestorm_max_number_of_storms", 5 },
		{ "active_skill_base_area_of_effect_radius", 16 },
	},
	stats = {
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
		"skill_is_ice_storm",
	},
	levels = {
		[1] = { critChance = 6, levelRequirement = 1, cost = { Mana = 22, }, },
	},
}
skills["IcicleBurst"] = {
	name = "Icicle Burst",
	hidden = true,
	color = 4,
	description = "This attack fires icy projectiles in a circle around enemies you hit, dealing attack damage with all physical damage converted to cold.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cold] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "number_of_additional_projectiles", 8 },
		{ "trigger_on_hit_vs_frozen_enemy_%", 100 },
		{ "monster_projectile_variation", 38 },
		{ "skill_physical_damage_%_to_convert_to_cold", 100 },
	},
	stats = {
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"never_freeze",
	},
	levels = {
		[10] = { PvPDamageMultiplier = -80, baseMultiplier = 1.25, cooldown = 0.5, damageEffectiveness = 1.25, levelRequirement = 1, storedUses = 1, },
		[20] = { PvPDamageMultiplier = -80, baseMultiplier = 2, cooldown = 0.3, damageEffectiveness = 2, levelRequirement = 1, storedUses = 1, },
	},
}
skills["IllusoryWarp"] = {
	name = "Illusory Warp",
	hidden = true,
	color = 4,
	description = "Teleport to a target destination. Chilled ground is spread in an area around both where the caster was and where they teleported to.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cold] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 1500 },
	},
	stats = {
	},
	levels = {
		[20] = { cooldown = 3, levelRequirement = 1, storedUses = 1, cost = { Mana = 20, }, },
	},
}
skills["CatsStealthTriggeredIntimidatingCry"] = {
	name = "Intimidating Cry",
	hidden = true,
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. The user and nearby allies gain a buff that grants movement speed.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, [SkillType.Physical] = true, [SkillType.Triggered] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.25,
	fromItem = true,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("IntimidatingExertedAttacks", "BASE", nil),
		},
		["intimidating_cry_movement_speed_+%_per_5_power_up_to_cap"] = {
			mod("IntimidatingMovementSpeedPer5MP", "BASE", nil),
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	constantStats = {
		{ "intimidating_cry_movement_speed_+%_per_5_power_up_to_cap", 3 },
		{ "skill_empowers_next_x_melee_attacks", 2 },
		{ "warcry_speed_+%", 38 },
		{ "base_skill_effect_duration", 3400 },
	},
	stats = {
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"cast_on_lose_cats_stealth",
		"intimidating_cry_empowerd_attacks_deal_double_damage_display",
		"enemies_taunted_by_your_warcies_are_intimidated",
		"use_intimidating_cry_buff_visual_for_intimidate",
	},
	levels = {
		[20] = { cooldown = 8, levelRequirement = 70, storedUses = 1, cost = { Mana = 19, }, },
	},
}
skills["SupportCastOnManaSpent"] = {
	name = "Kitava's Thirst",
	hidden = true,
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"support_cast_on_mana_spent",
	},
	levels = {
		[1] = { PvPDamageMultiplier = -80, cooldown = 0.1, levelRequirement = 1, storedUses = 1, },
	},
}
skills["LightningAegis"] = {
	name = "Lightning Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes lightning damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking lightning damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	statMap = {
		["aegis_unique_shield_max_value"] = {
			mod("LightningAegisValue", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "aegis_unique_shield_max_value", 1000 },
		{ "active_skill_display_aegis_variation", 3 },
		{ "aegis_recharge_delay_ms", 10000 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["LightningBolt"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 3,
	baseEffectiveness = 8,
	incrementalEffectiveness = 0.035000000149012,
	description = "A bolt of lightning strikes an area, dealing lightning damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggered] = true, [SkillType.Lightning] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = output.Cooldown
	end,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "cast_on_crit_%", 100 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 2, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, }, },
		[4] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 7, storedUses = 1, statInterpolation = { 3, 3, }, },
		[5] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 11, storedUses = 1, statInterpolation = { 3, 3, }, },
		[6] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 3, }, },
		[7] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, }, },
		[8] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 3, }, },
		[9] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, }, },
		[10] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 32, storedUses = 1, statInterpolation = { 3, 3, }, },
		[11] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, 3, }, },
		[12] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, }, },
		[13] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, }, },
		[14] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, }, },
		[15] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, }, },
		[16] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 56, storedUses = 1, statInterpolation = { 3, 3, }, },
		[17] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, }, },
		[18] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, }, },
		[19] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 67, storedUses = 1, statInterpolation = { 3, 3, }, },
		[20] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
		[21] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, }, },
		[22] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, }, },
		[23] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, }, },
		[24] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, }, },
		[25] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, }, },
		[26] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
		[27] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, },
		[28] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, }, },
		[29] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, }, },
		[30] = { 0.10000000149012, 1.8999999761581, cooldown = 0.5, critChance = 7.5, damageEffectiveness = 4.4, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SupportTriggerBowSkillOnBowAttack"] = {
	name = "Maloney's Mechanism",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.RangedAttack, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.Vaal, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[1] = { cooldown = 1, levelRequirement = 1, storedUses = 1, },
	},
}
skills["ManifestDancingDervishes"] = {
	name = "Manifest Dancing Dervishes",
	hidden = true,
	color = 4,
	description = "Manifests two Dancing Dervishes to fight by your side. While a Dancing Dervish is manifested, you have Onslaught and cannot use Weapons. Cannot be supported by supports that would create other minions.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.MinionsPersistWhenSkillRemoved] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Movement] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"UniqueAnimatedWeapon",
	},
	minionUses = {
		["Weapon 1"] = true,
	},
	statMap = {
		["attack_damage_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "INC", nil, ModFlag.Attack) }),
		},
		["attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("DisableWeapons", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		mod("Condition:Onslaught", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		skill("minionLevel", 65),
	},
	constantStats = {
		{ "attack_speed_+%", 25 },
		{ "attack_damage_+%", 110 },
		{ "chance_to_cast_on_rampage_tier_%", 100 },
		{ "minion_movement_speed_+%", 30 },
		{ "minion_grants_rampage_kill_to_parent_on_hitting_rare_or_unique_enemy_%", 25 },
	},
	stats = {
		"disable_weapons",
		"infinite_minion_duration",
	},
	levels = {
		[15] = { cooldown = 0.5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SupportUniqueMjolnerLightningSpellsCastOnHit"] = {
	name = "Mjolner",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Lightning, SkillType.Triggerable, SkillType.AND, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"unique_mjolner_lightning_spells_triggered",
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
		"no_cost",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 0, manaMultiplier = -100, storedUses = 1, },
	},
}
skills["TriggeredMoltenStrike"] = {
	name = "Molten Burst",
	hidden = true,
	color = 1,
	description = "Launch molten projectiles from the point of impact, causing AoE attack damage to enemies where they land.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		flag("CannotSplit"),
	},
	constantStats = {
		{ "number_of_additional_projectiles", 3 },
		{ "attack_trigger_on_melee_hit_%", 20 },
	},
	stats = {
		"show_number_of_projectiles",
		"base_is_projectile",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[16] = { baseMultiplier = 1.7, cooldown = 0.15, damageEffectiveness = 1.7, levelRequirement = 1, storedUses = 1, },
	},
}
skills["PenanceMark"] = {
	name = "Penance Mark",
	hidden = true,
	color = 3,
	description = "Curses a single enemy, causing them to spawn multiple phantasms when hit. The phantasms will be allies of the marked enemy with the same monster level. They cast a projectile spell which deals physical damage, and are immune to curses and knockback. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "brand_skill_stat_descriptions",
	castTime = 0.5,
	fromTree = true,
	baseFlags = {
		spell = true,
		curse = true,
		duration = true,
		mark = true,
	},
	baseMods = {
		skill("debuff", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "penance_mark_summon_phantasms_when_hit", 3 },
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[20] = { levelRequirement = 70, cost = { Mana = 33, }, },
	},
}
skills["PhysicalAegis"] = {
	name = "Physical Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes physical damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking physical damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	statMap = {
		["aegis_unique_shield_max_value"] = {
			mod("PhysicalAegisValue", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "aegis_unique_shield_max_value", 1000 },
		{ "active_skill_display_aegis_variation", 4 },
		{ "aegis_recharge_delay_ms", 10000 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["SupportTriggerSpellOnAttack"] = {
	name = "Poet's Pen",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["Portal"] = {
	name = "Portal",
	baseTypeName = "Portal",
	color = 4,
	baseEffectiveness = 0,
	description = "Creates a portal to the current area's town.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cast_speed_+%", 3 },
		},
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { levelRequirement = 10, },
		[2] = { levelRequirement = 10, },
		[3] = { levelRequirement = 10, },
		[4] = { levelRequirement = 10, },
		[5] = { levelRequirement = 10, },
		[6] = { levelRequirement = 10, },
		[7] = { levelRequirement = 10, },
		[8] = { levelRequirement = 10, },
		[9] = { levelRequirement = 10, },
		[10] = { levelRequirement = 10, },
	},
}
skills["QueensDemand"] = {
	name = "Queen's Demand",
	hidden = true,
	color = 4,
	description = "Alternates triggering Flames of Judgement and Storm of Judgement",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
	},
	stats = {
		"queens_demand_effect",
	},
	levels = {
		[20] = { levelRequirement = 70, cost = { Mana = 64, }, },
	},
}
skills["PrimalAegis"] = {
	name = "Primal Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes elemental damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking elemental damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromTree = true,
	baseFlags = {
	},
	constantStats = {
		{ "active_skill_display_aegis_variation", 2 },
		{ "aegis_recharge_delay_ms", 5000 },
		{ "aegis_unique_shield_max_value_per_allocated_notable", 75 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["Pacify"] = {
	name = "Pacify",
	hidden = true,
	color = 3,
	description = "Curses all targets in an area, having no effect at first, but causing them to deal no damage once 60% of the curse's duration has expired.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	fromTree = true,
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
	},
	stats = {
		"curse_pacifies_after_60%",
		"base_deal_no_damage",
		"display_skill_fixed_duration_buff",
	},
	levels = {
		[20] = { levelRequirement = 70, cost = { Mana = 33, }, },
	},
}
skills["Ravenous"] = {
	name = "Ravenous",
	hidden = true,
	color = 3,
	description = "Consumes a targeted corpse, granting you a buff that gives you bonuses against enemies of the same monster category as the corpse.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	statMap = {
		["ravenous_buff_magnitude"] = {
			{
				mod("DamageTaken", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectCond = "RavenousCorpseConsumed" }),
				mult = -1,
			},
			{
				mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectCond = "RavenousCorpseConsumed" }),
			},
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "ravenous_buff_magnitude", 15 },
	},
	stats = {
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, cost = { Mana = 33, }, },
	},
}
skills["RaiseSpiders"] = {
	name = "Raise Spiders",
	hidden = true,
	color = 3,
	description = "Raise two spectral spiders from each nearby corpse that will attack your enemies with Viper Strike. Each raised spider grants you increased Attack Speed and increased Damage with Poison. Enemies will not engage the spiders directly, and they are immune to damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsAreUndamageable] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SpiderMinion",
	},
	statMap = {
		["summoned_spider_grants_attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "RaisedSpider" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Raised Spider" }),
		},
		["summoned_spider_grants_poison_damage_+%"] = {
			mod("Damage", "INC", nil, 0, KeywordFlag.Poison, { type = "Multiplier", var = "RaisedSpider" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Raised Spider" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "chance_to_cast_on_kill_%_target_self", 100 },
		{ "base_skill_effect_duration", 30000 },
		{ "number_of_spider_minions_allowed", 20 },
		{ "summoned_spider_grants_attack_speed_+%", 2 },
		{ "summoned_spider_grants_poison_damage_+%", 15 },
		{ "damage_+%_vs_players", -85 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
		"take_no_actions_while_parent_dead",
		"minion_dies_when_parent_dies",
		"minions_cannot_taunt_enemies",
	},
	levels = {
		[1] = { cooldown = 2, levelRequirement = 75, storedUses = 1, },
		[20] = { cooldown = 2, levelRequirement = 84, storedUses = 1, },
	},
}
skills["UniqueMirageWarriors"] = {
	name = "Reflection",
	hidden = true,
	color = 4,
	description = "When you attack with The Saviour and deal a critical strike, this skill can summon a Mirage Saviour. Summoned Mirage Saviours will fight for you using whichever of your attack skills you dealt the critical strike with that caused them to be summoned. Mirage Saviours will not be resummoned using the same skills if you already have the maximum number of them.",
	skillTypes = { [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["skill_used_by_mirage_warrior_damage_+%_final"] = {
			mod("SaviourMirageWarriorLessDamage", "BASE", nil),
		},
		["maximum_number_of_mirage_warriors"] = {
			mod("SaviourMirageWarriorMaxCount", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "maximum_number_of_mirage_warriors", 2 },
		{ "skill_used_by_mirage_warrior_damage_+%_final", -50 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"display_mirage_warriors_no_spirit_strikes",
		"force_lite_skill_effects",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 1, },
	},
}
skills["SupportTriggerSpellOnUnarmedMeleeCriticalHit"] = {
	name = "Seven Teachings",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	statMap = {
		["spell_is_triggered_on_hit"] = {
			skill("triggeredBySevenTeachings", true, { type = "SkillType", skillType = SkillType.Triggerable }, { type = "SkillType", skillType = SkillType.Spell }),
			skill("triggerOnCrit", true, { type = "SkillType", skillType = SkillType.Triggerable }, { type = "SkillType", skillType = SkillType.Spell }),
		},
	},
	stats = {
		"spell_is_triggered_on_hit",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["ShadeForm"] = {
	name = "Shade Form",
	hidden = true,
	color = 4,
	description = "Makes you immune to physical damage, and harder for enemies to detect, for a duration.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Buff] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 3000 },
		{ "stealth_+%", 100 },
		{ "trigger_on_skill_use_from_chest_%", 20 },
	},
	stats = {
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	levels = {
		[20] = { cooldown = 40, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonShaperApparition"] = {
	name = "Summon Shaper Memory",
	hidden = true,
	color = 4,
	description = "Consume Remembrance to summon a memory of the Shaper, which will use a skill once before fading away.",
	skillTypes = { [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "display_shaper_memory_uses_skill_once", 1 },
	},
	stats = {
	},
	levels = {
		[20] = { levelRequirement = 0, },
	},
}
skills["ShaperApparitionTeleportSlam"] = {
	name = "Shaper's Devastation",
	hidden = true,
	color = 4,
	description = "Shaper's Memory uses this attack for you to teleport to an enemy and attack with a powerful blow, dealing area damage based on your weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_disabled_unless_cloned", 3 },
		{ "active_skill_ailment_damage_+%_final", -70 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"is_area_damage",
		"global_always_hit",
	},
	notMinionStat = {
		"active_skill_attack_speed_+%_final",
	},
	levels = {
		[20] = { 25, baseMultiplier = 41, damageEffectiveness = 41, levelRequirement = 72, statInterpolation = { 1, }, },
	},
}
skills["ShaperApparitionBeam"] = {
	name = "Shaper's Ire",
	hidden = true,
	color = 4,
	baseEffectiveness = 9,
	incrementalEffectiveness = 0.052000001072884,
	description = "Shaper's Memory casts this spell for you to fire a damaging beam for a duration that deals damage over time to things in it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.DamageOverTime] = true, [SkillType.Duration] = true, [SkillType.DegenOnlySpellDamage] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_disabled_unless_cloned", 3 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"base_cold_damage_to_deal_per_minute",
		"base_lightning_damage_to_deal_per_minute",
		"spell_damage_modifiers_apply_to_skill_dot",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[20] = { 50.000001117587, 50.000001117587, 50.000001117587, levelRequirement = 72, statInterpolation = { 3, 3, 3, }, },
	},
}
skills["ShaperApparitionProjectiles"] = {
	name = "Shaper's Despair",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.052000001072884,
	description = "Shaper's Memory casts this spell for you to fire piercing projectiles in front of you that deal cold damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.Cold] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Multicastable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	fromItem = true,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "skill_disabled_unless_cloned", 3 },
		{ "skill_repeat_count", 2 },
		{ "display_fires_x_times", 3 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_reduce_enemy_cold_resistance_%",
		"base_is_projectile",
		"always_pierce",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 200, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["ShieldShatter"] = {
	name = "Shield Shatter",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.68000000715256,
	incrementalEffectiveness = 0.045000001788139,
	description = "Your shield shatters, dealing physical spell damage to enemies in an area, based on the shield's quality. For a short duration after this, you will be unable to block and will gain no defences from your shield, but your spells will deal added physical damage.",
	skillTypes = { [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	statMap = {
		["spell_minimum_base_physical_damage_per_shield_quality"] = {
			skill("PhysicalMin", nil, { type = "Multiplier", var = "QualityOnWeapon 2" }),
		},
		["spell_maximum_base_physical_damage_per_shield_quality"] = {
			skill("PhysicalMax", nil, { type = "Multiplier", var = "QualityOnWeapon 2" }),
		},
		["buff_added_spell_minimum_base_physical_damage_per_shield_quality"] = {
			mod("PhysicalMin", "BASE", nil, ModFlag.Spell, 0, { type = "Multiplier", var = "QualityOnWeapon 2" }, { type = "Condition", var = "BlockedRecently"}, { type = "GlobalEffect", effectType = "Buff"}),
		},
		["buff_added_spell_maximum_base_physical_damage_per_shield_quality"] = {
			mod("PhysicalMax", "BASE", nil, ModFlag.Spell, 0, { type = "Multiplier", var = "QualityOnWeapon 2" }, { type = "Condition", var = "BlockedRecently"}, { type = "GlobalEffect", effectType = "Buff"}),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "trigger_on_block_%_chance", 100 },
		{ "base_skill_effect_duration", 4000 },
		{ "active_skill_ailment_damage_+%_final", -40 },
	},
	stats = {
		"spell_minimum_base_physical_damage_per_shield_quality",
		"spell_maximum_base_physical_damage_per_shield_quality",
		"buff_added_spell_minimum_base_physical_damage_per_shield_quality",
		"buff_added_spell_maximum_base_physical_damage_per_shield_quality",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, 2, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, 15, 23, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, },
	},
}
skills["TriggeredShockedGround"] = {
	name = "Shock Ground",
	hidden = true,
	color = 4,
	description = "Creates a patch of Shocked Ground in a radius around you.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Lightning] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, [SkillType.ElementalStatus] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("ShockedGroundEffect", "BASE", 15),
	},
	constantStats = {
		{ "cast_when_hit_%", 100 },
		{ "base_skill_effect_duration", 5000 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SpectralSpirits"] = {
	name = "Spectral Spirits",
	hidden = true,
	color = 3,
	description = "Summons three invulnerable spectral skulls that rush at nearby enemies and attack them rapidly. Enemies will not engage these spirits, and can pass through them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsAreUndamageable] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedEssenceSpirit",
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "active_skill_minion_added_damage_+%_final", -15 },
		{ "number_of_monsters_to_summon", 3 },
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"take_no_actions_while_parent_dead",
		"minion_dies_when_parent_dies",
		"minions_cannot_taunt_enemies",
		"no_cost",
		"infinite_minion_duration",
	},
	levels = {
		[1] = { levelRequirement = 1, },
		[2] = { levelRequirement = 2, },
		[3] = { levelRequirement = 4, },
		[4] = { levelRequirement = 7, },
		[5] = { levelRequirement = 11, },
		[6] = { levelRequirement = 16, },
		[7] = { levelRequirement = 20, },
		[8] = { levelRequirement = 24, },
		[9] = { levelRequirement = 28, },
		[10] = { levelRequirement = 32, },
		[11] = { levelRequirement = 36, },
		[12] = { levelRequirement = 40, },
		[13] = { levelRequirement = 44, },
		[14] = { levelRequirement = 48, },
		[15] = { levelRequirement = 52, },
		[16] = { levelRequirement = 56, },
		[17] = { levelRequirement = 60, },
		[18] = { levelRequirement = 64, },
		[19] = { levelRequirement = 67, },
		[20] = { levelRequirement = 70, },
		[21] = { levelRequirement = 72, },
		[22] = { levelRequirement = 74, },
		[23] = { levelRequirement = 76, },
		[24] = { levelRequirement = 78, },
		[25] = { levelRequirement = 80, },
		[26] = { levelRequirement = 82, },
		[27] = { levelRequirement = 84, },
		[28] = { levelRequirement = 86, },
		[29] = { levelRequirement = 88, },
		[30] = { levelRequirement = 90, },
	},
}
skills["SpiritBurst"] = {
	name = "Spirit Burst",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.875,
	incrementalEffectiveness = 0.03999999910593,
	description = "Consumes a spirit charge to fire projectiles which deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "trigger_on_skill_use_%_if_you_have_a_spirit_charge", 100 },
		{ "number_of_additional_projectiles", 6 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"projectiles_nova",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, critChance = 6, damageEffectiveness = 1.2, levelRequirement = 70, statInterpolation = { 3, 3, }, },
	},
}
skills["StalkingPustule"] = {
	name = "Stalking Pustule",
	hidden = true,
	color = 2,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.0337999984622,
	description = "A corpse near the targeted location explodes, dealing damage in a small area and creating an orb which moves towards nearby enemies before dealing spell damage in a larger area. The explosion of the corpse is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Chaos] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	statMap = {
		["volatile_dead_core_explosion_radius_+"] = {
			skill("radius", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
	},
	baseMods = {
		skill("radiusLabel", "Orb explosion:"),
		skill("radiusSecondaryLabel", "Corpse explosion:"),
	},
	constantStats = {
		{ "volatile_dead_base_number_of_corpses_to_consume", 1 },
		{ "corpse_explosion_monster_life_%_chaos", 9 },
		{ "volatile_dead_max_cores_allowed", 13 },
		{ "chance_to_cast_on_kill_%", 100 },
		{ "active_skill_base_area_of_effect_radius", 30 },
		{ "active_skill_base_secondary_area_of_effect_radius", 15 },
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
	},
	levels = {
		[15] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 2, critChance = 5, damageEffectiveness = 1.4, levelRequirement = 59, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["TriggeredStarfall"] = {
	name = "Starfall",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Stars fall, raining destruction down over an area. Falling stars deal Attack Damage.\nCannot be Supported by Trigger Support Gems.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, [SkillType.Triggered] = true, [SkillType.Cooldown] = true, [SkillType.InbuiltTrigger] = true, [SkillType.DisallowTriggerSupports] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "skill_art_variation", 11 },
		{ "attack_trigger_on_melee_critical_hit_%", 100 },
	},
	stats = {
		"base_number_of_projectiles",
		"base_is_projectile",
		"is_area_damage",
		"cannot_pierce",
	},
	levels = {
		[20] = { 22, baseMultiplier = 0.6, cooldown = 0.15, damageEffectiveness = 0.6, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["StormCascadeTriggered"] = {
	name = "Storm Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.7555999755859,
	incrementalEffectiveness = 0.034600000828505,
	description = "Lightning crackles in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.Physical] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 5 },
		{ "skill_physical_damage_%_to_convert_to_lightning", 100 },
		{ "active_skill_base_radius_+", 3 },
		{ "cast_on_attack_use_%", 100 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 31, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 37, storedUses = 1, statInterpolation = { 3, 3, }, },
		[5] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, }, },
		[6] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 42, storedUses = 1, statInterpolation = { 3, 3, }, },
		[7] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, }, },
		[8] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 3, }, },
		[9] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, }, },
		[10] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 50, storedUses = 1, statInterpolation = { 3, 3, }, },
		[11] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, }, },
		[12] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 54, storedUses = 1, statInterpolation = { 3, 3, }, },
		[13] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 56, storedUses = 1, statInterpolation = { 3, 3, }, },
		[14] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 3, }, },
		[15] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, }, },
		[16] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 3, }, },
		[17] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, }, },
		[18] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 3, }, },
		[19] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
		[21] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, }, },
		[22] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, }, },
		[23] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, }, },
		[24] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, }, },
		[25] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, }, },
		[26] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
		[27] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, },
		[28] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, }, },
		[29] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, }, },
		[30] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.25, critChance = 5, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AtziriUniqueStaffStormCall"] = {
	name = "Storm of Judgement",
	hidden = true,
	color = 3,
	baseEffectiveness = 4.0549998283386,
	incrementalEffectiveness = 0.040500000119209,
	description = "Creates a number of markers around the targeted location, which will explode after a duration, dealing lightning damage. Cannot be supported by Spell Cascade.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Lightning] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("triggerSource", "Queen's Demand"),
	},
	constantStats = {
		{ "base_chance_to_shock_%", 100 },
		{ "atziri_unique_staff_storm_call_number_of_markers_to_place", 12 },
		{ "shock_effect_+%", 50 },
		{ "base_reduce_enemy_lightning_resistance_%", 50 },
		{ "base_skill_effect_duration", 2000 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"console_skill_dont_chase",
		"atziri_do_not_gain_skill_charges",
		"skill_has_trigger_from_unique_item",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[20] = { 0.69999998807907, 1.2999999523163, PvPDamageMultiplier = -50, cooldown = 1.5, critChance = 6, damageEffectiveness = 3.2, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SummonArbalists"] = {
	name = "Summon Arbalists",
	hidden = true,
	color = 4,
	description = "Summons Arbalist minions which use projectile attacks.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Physical] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.CreatesMinion] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedArbalists",
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "base_number_of_arbalists", 2 },
	},
	stats = {
		"cast_on_gain_skill",
		"minions_cannot_taunt_enemies",
		"no_cost",
		"infinite_minion_duration",
	},
	levels = {
		[20] = { levelRequirement = 70, },
	},
}
skills["SummonBeastialRhoa"] = {
	name = "Summon Bestial Rhoa",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Rhoa. In addition to its melee attack, the Bestial Rhoa uses a charge and has an aura that intimidates enemies. Enemies will not engage this minion directly, and they are immune to damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"RhoaUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	constantStats = {
		{ "base_number_of_beast_minions_allowed", 1 },
		{ "minion_maximum_life_+%", 30 },
		{ "display_minion_monster_type", 12 },
		{ "base_display_minion_actor_level", 70 },
	},
	stats = {
		"infinite_minion_duration",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, cost = { Mana = 30, }, },
	},
}
skills["SummonBeastialSnake"] = {
	name = "Summon Bestial Snake",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Snake. The Bestial Snake fires powerful chaos projectile attacks. Enemies will not engage this minion directly, and they are immune to damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Chains] = true, [SkillType.RangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SnakeSpitUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	constantStats = {
		{ "base_number_of_beast_minions_allowed", 1 },
		{ "minion_maximum_life_+%", 30 },
		{ "display_minion_monster_type", 14 },
		{ "base_display_minion_actor_level", 70 },
		{ "alternate_minion", 2 },
	},
	stats = {
		"infinite_minion_duration",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, cost = { Mana = 30, }, },
	},
}
skills["SummonBeastialUrsa"] = {
	name = "Summon Bestial Ursa",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Ursa. In addition to its melee attack, the Bestial Ursa uses a powerful Ground Slam and Rallying Cry. Enemies will not engage this minion directly, and they are immune to damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"DropBearUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	constantStats = {
		{ "base_number_of_beast_minions_allowed", 1 },
		{ "minion_maximum_life_+%", 30 },
		{ "display_minion_monster_type", 13 },
		{ "base_display_minion_actor_level", 70 },
		{ "alternate_minion", 1 },
	},
	stats = {
		"infinite_minion_duration",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, cost = { Mana = 30, }, },
	},
}
skills["SummonDoedresEffigy"] = {
	name = "Summon Doedre's Effigy",
	hidden = true,
	color = 4,
	description = "Summons an effigy of Doedre, which will project auras of all the curse skill gems socketed in Doedre's Skin. These curses have less effectiveness.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	fromItem = true,
	baseFlags = {
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 10000 },
		{ "base_number_of_effigies_allowed", 3 },
	},
	stats = {
	},
	levels = {
		[20] = { levelRequirement = 70, cost = { Mana = 50, }, },
	},
}
skills["SupportCursePillarTriggerCurses"] = {
	name = "Doedre's Effigy",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.AppliesCurse, SkillType.Hex, SkillType.AND, },
	addSkillTypes = { SkillType.InbuiltTrigger, SkillType.Area, SkillType.Aura, SkillType.AuraAffectsEnemies, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.RemoteMined, SkillType.Trapped, },
	ignoreMinionTypes = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
		skill("manaReservationPercent", 0),
	},
	constantStats = {
		{ "number_of_additional_curses_allowed", 5 },
	},
	stats = {
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[20] = { levelRequirement = 70, },
	},
}
skills["SummonElementalRelic"] = {
	name = "Summon Elemental Relic",
	hidden = true,
	color = 4,
	description = "Summons a Relic of a random element that stays near you. Depending on the element chosen, the relic minion will have an Anger, Hatred, or Wrath aura. These relics explode when they die, dealing elemental damage to enemies around them. If you already have a relic of the chosen element, its duration will be refreshed instead of summoning a new one.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.RandomElement] = true, [SkillType.CreatesMinion] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	minionSkillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Aura] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"GuardianRelicAll",
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "display_minion_monster_type", 24 },
		{ "guardian_relic_explode_on_death_for_%_life_as_element_damage", 100 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "skill_triggered_by_nearby_allies_kill_or_hit_rare_unique_%_chance", 25 },
	},
	stats = {
		"base_skill_effect_duration",
	},
	notMinionStat = {
		"base_skill_effect_duration",
	},
	levels = {
		[20] = { 5000, cooldown = 0.3, levelRequirement = 4, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["SummonHarbingerOfTheArcaneUber"] = {
	name = "Summon Greater Harbinger of the Arcane",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion has two buff spells it will cast on you: Arcane Surge, granting increased Cast Speed and Mana Regeneration, and a buff that grants Chance to Shock and Lightning Penetration.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 6 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfBrutalityUber"] = {
	name = "Summon Greater Harbinger of Brutality",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. When you are near a rare or unique enemy, the minion will occasionally grant you a buff giving significantly increased Damage, Attack Speed, and Movement Speed, reducing the Damage you take, and causing Bleeding Enemies that you Kill to Explode, dealing 10% of their maximum Life as Physical Damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 11 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfDirectionsUber"] = {
	name = "Summon Greater Harbinger of Directions",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will cast a random buff on you that grants one or all of the following: Fire 2 additional Projectiles, Chain 2 additional times, Projectiles Pierce 2 additional targets, or Projectiles Fork then Fork an additional time.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 9 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfFocusUber"] = {
	name = "Summon Greater Harbinger of Focus",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. While you are channelling, the minion will occasionally cast a buff on you that reduces the Damage you take, makes you avoid all Stuns and Elemental Ailments, and prevents Curses affecting you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 8 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfStormsUber"] = {
	name = "Summon Greater Harbinger of Storms",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally apply a Chill or Shock with increased effect to an enemy that chains to other nearby enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.NonHitChill] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 10 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfTimeUber"] = {
	name = "Summon Greater Harbinger of Time",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally create an aura on you that increases the Action Speed of you and all allies near you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("ActionSpeed", "INC", 10, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Greater Harbinger of Time", modCond = "GreaterHarbingerOfTime" }),
		skill("buffAllies", true),
	},
	constantStats = {
		{ "alternate_minion", 7 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfTheArcane"] = {
	name = "Summon Harbinger of the Arcane",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally cast Arcane Surge on you, granting increased Cast Speed and Mana Regeneration.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfFocusAscendancy"] = {
	name = "Summon Visiting Harbinger of Focus",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. While you are channelling, the minion will occasionally cast a buff on you that reduces the Damage you take, makes you avoid all Stuns and Elemental Ailments, and prevents Curses affecting you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromTree = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 14 },
		{ "number_of_harbinger_focus_ascendancy_minions_allowed", 1 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfTimeAscendancy"] = {
	name = "Summon Visiting Harbinger of Time",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally create an aura on you that increases the Action Speed of you and all allies near you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromTree = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("ActionSpeed", "INC", 10, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Harbinger of Time", modCond = "HarbingerOfTime" }),
		skill("buffAllies", true),
	},
	constantStats = {
		{ "alternate_minion", 13 },
		{ "number_of_harbinger_time_ascendancy_minions_allowed", 1 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfTheArcaneAscendancy"] = {
	name = "Summon Visiting Harbinger of the Arcane",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion has two buff spells it will cast on you: Arcane Surge, granting increased Cast Speed and Mana Regeneration, and a buff that grants Chance to Shock and Lightning Penetration.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromTree = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 12 },
		{ "number_of_harbinger_arcane_ascendancy_minions_allowed", 1 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfBrutality"] = {
	name = "Summon Harbinger of Brutality",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. When you are near a rare or unique enemy, the minion will occasionally grant you a buff giving significantly increased Damage, Attack Speed, and Movement Speed, and reducing the Damage you take.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 5 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfDirections"] = {
	name = "Summon Harbinger of Directions",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will cast a random buff on you that grants one or all of the following: 1 additional Projectile, +1 Chain, Pierce 1 additional Target, or Projectiles Fork.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 3 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfFocus"] = {
	name = "Summon Harbinger of Focus",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. While you are channelling, the minion will occasionally cast a buff on you that reduces the Damage you take, and makes you avoid all Stuns and Elemental Ailments.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 2 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfStorms"] = {
	name = "Summon Harbinger of Storms",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally apply a Chill or Shock to an enemy that chains to other nearby enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.NonHitChill] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "alternate_minion", 4 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonHarbingerOfTime"] = {
	name = "Summon Harbinger of Time",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally create an aura on you that increases the Action Speed of you, and all allies and enemies near you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.MinionsAreUndamageable] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("ActionSpeed", "INC", 10, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Harbinger of Time", modCond = "HarbingerOfTime" }),
		skill("buffAllies", true),
	},
	constantStats = {
		{ "alternate_minion", 1 },
	},
	stats = {
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["TriggeredSummonGhostOnKill"] = {
	name = "Triggered Summon Phantasm",
	hidden = true,
	color = 3,
	description = "Summons a Phantasm minion, which uses a piercing projectile spell that deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedPhantasm",
	},
	statMap = {
		["base_number_of_support_ghosts_allowed"] = {
			mod("ActivePhantasmLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "trigger_on_corpse_consume_%_chance", 100 },
		{ "base_skill_effect_duration", 15000 },
		{ "base_number_of_support_ghosts_allowed", 11 },
		{ "phantasm_minimum_added_physical_damage_to_grant", 48 },
		{ "phantasm_maximum_added_physical_damage_to_grant", 74 },
	},
	stats = {
		"skill_can_own_support_ghosts",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[25] = { levelRequirement = 80, manaMultiplier = 20, },
	},
}
skills["SummonSentinelOfRadiance"] = {
	name = "Summon Sentinel of Radiance",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.0517001152039,
	incrementalEffectiveness = 0.043200001120567,
	description = "Summons a Sentinel of Radiance which follows you and attacks enemies in melee, while burning enemies around it and taking a portion of damage from hits for you. You can only have one Sentinel of Radiance.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	minionSkillTypes = { [SkillType.DamageOverTime] = true, [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, },
	statDescriptionScope = "single_minion_spell_skill_stat_descriptions",
	castTime = 0.75,
	fromTree = true,
	minionList = {
		"GuardianSentinel",
	},
	statMap = {
		["radiant_sentinel_minion_fire_%_of_life_to_deal_nearby_per_minute"] = {
			mod("MinionModifier", "LIST", { mod = mod("Multiplier:GuardianSentinelFireAuraBaseDamage", "BASE", nil) }),
			div = 60,
			mod("ExtraMinionSkill", "LIST", { skillId = "GuardianSentinelFireAura" }),
		},
		["radiant_sentinel_minion_burning_effect_radius"] = {
			mod("MinionModifier", "LIST", { mod = mod("Multiplier:GuardianSentinelFireAuraRadius", "BASE", nil) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "display_minion_monster_type", 23 },
		{ "base_skill_effect_duration", 20000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
	},
	stats = {
		"radiant_sentinel_minion_burning_effect_radius",
		"radiant_sentinel_minion_fire_%_of_life_to_deal_nearby_per_minute",
	},
	levels = {
		[20] = { 40, 1200, critChance = 6, damageEffectiveness = 2, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { Mana = 40, }, },
	},
}
skills["SummonSpectralWolf"] = {
	name = "Summon Spectral Wolf",
	hidden = true,
	color = 4,
	description = "Summons a spectral wolf companion that attacks nearby enemies and dies after a duration. Each spectral wolf grants you a buff that adds damage to your attacks. If you have the maximum number of them, refreshes the duration and life of an existing one instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, [SkillType.Buff] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedSpectralWolf",
	},
	statMap = {
		["spectral_wolf_grants_attack_minimum_added_physical_damage"] = {
			mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "Multiplier", var = "SpectralWolfCount" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spectral Wolf" }),
		},
		["spectral_wolf_grants_attack_maximum_added_physical_damage"] = {
			mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "Multiplier", var = "SpectralWolfCount" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spectral Wolf" }),
		},
		["modifiers_to_claw_critical_strike_chance_apply_minion_critical_strike_chance"] = {
			flag("ClawCritChanceAppliesToMinions"),
		},
		["modifiers_to_claw_critical_strike_multiplier_apply_minion_critical_strike_multiplier"] = {
			flag("ClawCritMultiplierAppliesToMinions"),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 30000 },
		{ "number_of_wolves_allowed", 10 },
		{ "display_minion_monster_type", 8 },
		{ "base_display_minion_actor_level", 65 },
	},
	stats = {
		"chance_to_cast_on_kill_%_target_self",
		"spectral_wolf_grants_attack_minimum_added_physical_damage",
		"spectral_wolf_grants_attack_maximum_added_physical_damage",
		"skill_has_trigger_from_unique_item",
		"spell_uncastable_if_triggerable",
		"modifiers_to_claw_critical_strike_chance_apply_minion_critical_strike_chance",
		"modifiers_to_claw_critical_strike_multiplier_apply_minion_critical_strike_multiplier",
	},
	notMinionStat = {
		"chance_to_cast_on_kill_%_target_self",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[10] = { 100, 3, 6, levelRequirement = 55, statInterpolation = { 1, 1, 1, }, },
		[25] = { 0, 8, 16, levelRequirement = 78, statInterpolation = { 0, 1, 1, }, },
	},
}
skills["SummonTauntingContraption"] = {
	name = "Summon Taunting Contraption",
	hidden = true,
	color = 4,
	description = "Summons a Taunting Contraption that taunts nearby enemies to attack it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Buff] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	constantStats = {
		{ "cast_on_flask_use_%", 100 },
		{ "display_minion_monster_type", 17 },
		{ "base_display_minion_actor_level", 70 },
		{ "minion_maximum_life_+%", 150 },
		{ "base_skill_effect_duration", 8000 },
	},
	stats = {
		"base_deal_no_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[20] = { cooldown = 8, levelRequirement = 70, storedUses = 1, },
	},
}
skills["SummonVoidSpawn"] = {
	name = "Summon Void Spawn",
	hidden = true,
	color = 3,
	description = "Summon a Void Spawn minion, which casts a lightning projectile spell with a chance to shock enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"VoidSpawn",
	},
	statMap = {
		["void_spawn_withered_on_hit_chance_%"] = {
			flag("Condition:CanWither"),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	constantStats = {
		{ "base_number_of_void_spawns_allowed", 4 },
		{ "display_minion_monster_type", 27 },
		{ "void_spawn_withered_on_hit_chance_%", 100 },
		{ "void_spawn_withered_base_duration_ms", 2000 },
		{ "triggered_by_item_buff", 1 },
	},
	stats = {
		"base_display_minion_actor_level",
		"infinite_minion_duration",
	},
	levels = {
		[20] = { 70, levelRequirement = 70, statInterpolation = { 1, }, },
	},
}
skills["VolatileAnomaly"] = {
	name = "Summon Volatile Anomaly",
	hidden = true,
	color = 3,
	baseEffectiveness = 3.4818000793457,
	incrementalEffectiveness = 0.035599999129772,
	description = "Creates an orb which moves towards nearby enemies, exploding after a duration or when it gets close enough. The explosion deals cold spell damage in an area, and leaves behind a Vortex on the ground for a secondary duration which continues to deal cold damage over time and chill enemies caught in it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cold] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	constantStats = {
		{ "chance_to_cast_on_kill_%", 20 },
		{ "base_skill_effect_duration", 8000 },
		{ "base_secondary_skill_effect_duration", 4000 },
		{ "ground_maelstrom_art_variation", 5 },
		{ "chilled_ground_base_magnitude_override", 10 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_cold_damage_to_deal_per_minute",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_damage_modifiers_apply_to_skill_dot",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 83.333335195979, PvPDamageMultiplier = -80, cooldown = 2, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, 3, }, },
	},
}
skills["SummonMirageChieftain"] = {
	name = "Tawhoa's Chosen",
	hidden = true,
	color = 1,
	description = "This skill is triggered when you use a Slam or Strike skill, and summons a Mirage Chieftain who will use that Slam or Strike skill once before dissipating.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Instant] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	statMap = {
		["skill_used_by_mirage_chieftain_damage_+%_final"] = {
			mod("ChieftainMirageChieftainMoreDamage", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "trigger_on_slam_or_strike_%_chance", 100 },
		{ "base_skill_effect_duration", 3000 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { cooldown = 1, levelRequirement = 1, storedUses = 1, },
		[20] = { cooldown = 1, levelRequirement = 1, storedUses = 1, },
	},
}
skills["TentacleSmash"] = {
	name = "Tentacle Whip",
	hidden = true,
	color = 4,
	description = "This attack causes three otherworldly tentacles to strike the ground around you, each dealing your attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "attack_trigger_on_kill_%", 20 },
	},
	stats = {
		"is_area_damage",
		"attack_unusable_if_triggerable",
	},
	levels = {
		[20] = { PvPDamageMultiplier = -80, baseMultiplier = 2.5, cooldown = 2, levelRequirement = 70, storedUses = 1, },
	},
}
skills["ThirstForBlood"] = {
	name = "Thirst for Blood",
	hidden = true,
	color = 4,
	description = "Reserves some of your life to cause bleeding you inflict to be stronger, and grant life regeneration based on the number bleeding enemies nearby.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["vampiric_icon_max_bleeding_beam_targets"] = {
			mod("Multiplier:ThirstForBloodMaxTargets", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
		["skill_life_regeneration_per_minute_per_affected_enemy"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "Multiplier", var = "NearbyBleedingEnemies", limitVar = "ThirstForBloodMaxTargets" }, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
		["vampiric_icon_bleeding_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Bleed, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
	},
	constantStats = {
		{ "vampiric_icon_max_bleeding_beam_targets", 5 },
		{ "skill_life_regeneration_per_minute_per_affected_enemy", 24000 },
		{ "vampiric_icon_bleeding_damage_+%_final", 20 },
	},
	stats = {
	},
	levels = {
		[20] = { cooldown = 1.2, levelRequirement = 70, lifeReservationPercent = 10, storedUses = 1, },
	},
}
skills["SupportTriggerSpellOnSkillUse"] = {
	name = "Trigger Craft",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	constantStats = {
		{ "spell_has_trigger_from_crafted_item_mod", 1 },
	},
	stats = {
	},
	levels = {
		[1] = { PvPDamageMultiplier = -80, cooldown = 8, levelRequirement = 1, manaMultiplier = 150, storedUses = 1, },
		[2] = { PvPDamageMultiplier = -80, cooldown = 4, levelRequirement = 1, manaMultiplier = 150, storedUses = 1, },
	},
}
skills["SupportTriggerElementalSpellOnBlock"] = {
	name = "SupportTriggerElementalSpellOnBlock",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, SkillType.Fire, SkillType.Cold, SkillType.OR, SkillType.Lightning, SkillType.OR, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"trigger_effect_group_on_block",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SupportTriggerSpellOnKill"] = {
	name = "Squirming Terror",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	stats = {
		"chance_to_cast_on_kill_%",
	},
	notMinionStat = {
		"chance_to_cast_on_kill_%",
	},
	levels = {
		[1] = { 20, cooldown = 0.5, levelRequirement = 1, storedUses = 1, statInterpolation = { 1, }, },
	},
}
skills["Twister"] = {
	name = "Twister",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.1300001144409,
	incrementalEffectiveness = 0.02559999935329,
	description = "Launches an unpredictable, piercing twister projectile that moves randomly for a duration, repeatedly dealing damage to enemies it intersects.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	fromItem = true,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 2500 },
		{ "cast_on_gain_avians_flight_or_avians_might_%", 100 },
		{ "global_chance_to_blind_on_hit_%", 25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectiles_nova",
		"always_pierce",
		"spell_uncastable_if_triggerable",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, PvPDamageMultiplier = -80, cooldown = 0.1, critChance = 6, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["Unhinge"] = {
	name = "Unhinge",
	hidden = true,
	color = 4,
	description = "Relinquish your grip on reality.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	stats = {
		"display_unhinge_grant_insane",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, storedUses = 1, },
	},
}
skills["UnseenStrike"] = {
	name = "Unseen Strike",
	hidden = true,
	color = 2,
	description = "Launches a spinning blade that deals weapon damage to enemies. If firing multiple projectiles, they will be fired in a circle.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Triggerable] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		forceMainHand = true,
	},
	stats = {
		"skill_has_trigger_from_unique_item",
		"projectiles_nova",
		"base_is_projectile",
	},
	levels = {
		[20] = { baseMultiplier = 2.5, damageEffectiveness = 2.5, levelRequirement = 70, },
	},
}
skills["VaalBreach"] = {
	name = "Vaal Breach",
	baseTypeName = "Vaal Breach",
	color = 4,
	baseEffectiveness = 0,
	description = "Creates a breach, making you vulnerable to its powerful inhabitants.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
	},
	qualityStats = {
		Default = {
			{ "base_cast_speed_+%", 3 },
		},
	},
	stats = {
		"base_deal_no_damage",
		"display_vaal_breach_no_drops_xp",
		"cannot_cancel_skill_before_contact_point",
		"skill_cannot_be_stunned_before_contact_point",
	},
	levels = {
		[1] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[2] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[3] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[4] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[5] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[6] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[7] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[8] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[9] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
		[10] = { levelRequirement = 10, soulPreventionDuration = 40, vaalStoredUses = 1, cost = { Soul = 100, }, },
	},
}
skills["VoidGaze"] = {
	name = "Void Gaze",
	hidden = true,
	color = 3,
	description = "Applies a debuff to Enemies, removing some of their resistance to Chaos damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Chaos] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.21,
	fromItem = true,
	statMap = {
		["base_chaos_damage_resistance_%"] = {
			mod("ChaosResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "base_chaos_damage_resistance_%", -20 },
		{ "base_skill_effect_duration", 10000 },
		{ "cast_on_skill_use_%", 100 },
	},
	stats = {
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { cooldown = 2, levelRequirement = 40, storedUses = 1, },
	},
}
skills["VoidShot"] = {
	name = "Void Shot",
	hidden = true,
	color = 4,
	description = "Fires an arrow which decelerates to the target location, the arrow will then become unstable and explode dealing weapon damage in an area, converting half of the physical damage to cold damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cold] = true, [SkillType.ProjectilesFromUser] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "trigger_on_skill_use_%_if_you_have_a_void_arrow", 100 },
		{ "skill_physical_damage_%_to_convert_to_cold", 50 },
		{ "active_skill_area_damage_+%_final", 100 },
	},
	stats = {
		"base_is_projectile",
		"skill_can_fire_arrows",
		"base_skill_show_average_damage_instead_of_dps",
		"attack_unusable_if_triggerable",
		"quality_display_active_skill_area_damage_is_gem",
	},
	levels = {
		[20] = { PvPDamageMultiplier = -80, baseMultiplier = 0.65, damageEffectiveness = 0.65, levelRequirement = 70, },
	},
}
skills["TriggerSummonedAncestorAhuana"] = {
	name = "Summon Spirit of Ahuana",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Ramako tribe to fight alongside you for a duration. This minion grants you a buff which prevents additional damage from suppressed spells. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralAhuanaMinion",
	},
	statMap = {
		["ancestral_buff_base_spell_damage_%_suppressed"] = {
			mod("SpellSuppressionEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Ahuana" }, { type = "Multiplier", var = "RamakoTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_ramako_tattoo"] = {
			mod("Multiplier:RamakoTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "RamakoTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_ramako_tattoo", 20 },
		{ "ancestral_buff_base_spell_damage_%_suppressed", 10 },
	},
	stats = {
		"trigger_on_suppress_hit_from_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_suppress_hit_from_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorAkoya"] = {
	name = "Summon Spirit of Akoya",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Tukohama tribe to fight alongside you for a duration. This minion grants you a buff which regenerates rage. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralAkoyaMinion",
	},
	statMap = {
		["ancestral_buff_base_rage_regeneration_per_minute"] = {
			mod("RageRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Akoya" }, { type = "Multiplier", var = "TukohamaTattooEffect", noFloor = true }),
			div = 60,
		},
		["ancestral_embrace_effect_+%_per_tukohama_tattoo"] = {
			mod("Multiplier:TukohamaTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "TukohamaTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_tukohama_tattoo", 20 },
		{ "ancestral_buff_base_rage_regeneration_per_minute", 300 },
	},
	stats = {
		"trigger_on_reaching_maximum_rage_in_presence_of_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_reaching_maximum_rage_in_presence_of_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorIkiaho"] = {
	name = "Summon Spirit of Ikiaho",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Arohongui tribe to fight alongside you for a duration. This minion grants you a buff which makes travel skills recover cooldowns faster. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralIkiahoMinion",
	},
	statMap = {
		["ancestral_buff_travel_skill_cooldown_speed_+%"] = {
			mod("CooldownRecovery", "INC", nil, 0, 0, { type = "SkillType", skillType = SkillType.Travel }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Ikiaho" }, { type = "Multiplier", var = "ArohonguiTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_arohongui_tattoo"] = {
			mod("Multiplier:ArohonguiTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "ArohonguiTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_arohongui_tattoo", 20 },
		{ "ancestral_buff_travel_skill_cooldown_speed_+%", 100 },
	},
	stats = {
		"trigger_on_travel_skill_use_in_presence_of_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_travel_skill_use_in_presence_of_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorKahuturoa"] = {
	name = "Summon Spirit of Kahuturoa",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Rongokurai tribe to fight alongside you for a duration. This minion grants you a buff which lets a percentage of your armour protect against all damage types. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralKahuturoaMinion",
	},
	statMap = {
		["ancestral_buff_armour_%_applies_to_all_damage_from_hits"] = {
			mod("ArmourAppliesToFireDamageTaken", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kahuturoa" }, { type = "Multiplier", var = "RongokuraiTattooEffect", noFloor = true }),
			mod("ArmourAppliesToColdDamageTaken", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kahuturoa" }, { type = "Multiplier", var = "RongokuraiTattooEffect", noFloor = true }),
			mod("ArmourAppliesToLightningDamageTaken", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kahuturoa" }, { type = "Multiplier", var = "RongokuraiTattooEffect", noFloor = true }),
			mod("ArmourAppliesToChaosDamageTaken", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kahuturoa" }, { type = "Multiplier", var = "RongokuraiTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_rongokurai_tattoo"] = {
			mod("Multiplier:RongokuraiTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "RongokuraiTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_rongokurai_tattoo", 20 },
		{ "ancestral_buff_armour_%_applies_to_all_damage_from_hits", 10 },
	},
	stats = {
		"trigger_on_crit_by_unique_enemy",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_crit_by_unique_enemy",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorKaom"] = {
	name = "Summon Spirit of Kaom",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Ngamahu tribe to fight alongside you for a duration. This minion grants you a buff which allows totems to take some damage from hits for you. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralKaomMinion",
	},
	statMap = {
		["ancestral_buff_damage_removed_from_your_nearest_totem_before_life_or_es_%"] = {
			mod("takenFromTotemsBeforeYou", "BASE", nil, 0, 0, { type = "Condition", var = "HaveTotem" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kaom" }, { type = "Multiplier", var = "NgamahuTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_ngamahu_tattoo"] = {
			mod("Multiplier:NgamahuTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "NgamahuTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_ngamahu_tattoo", 20 },
		{ "ancestral_buff_damage_removed_from_your_nearest_totem_before_life_or_es_%", 15 },
	},
	stats = {
		"trigger_on_totem_death_in_presence_of_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_totem_death_in_presence_of_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorKiloava"] = {
	name = "Summon Spirit of Kiloava",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Valako tribe to fight alongside you for a duration. This minion grants you a buff which recovers life, mana and energy shield when you block. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralKiloavaMinion",
	},
	statMap = {
		["ancestral_buff_recover_%_of_maximum_life_mana_energy_shield_on_block"] = {
			mod("Multiplier:KiloavaRecoverOnBlock", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "ValakoTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_valako_tattoo"] = {
			mod("Multiplier:ValakoTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "ValakoTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	baseMods = {
		mod("LifeOnBlock", "BASE", 1, 0, 0, { type = "PercentStat", stat = "Life", percentVar = "KiloavaRecoverOnBlock", floor = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kiloava" }),
		mod("EnergyShieldOnBlock", "BASE", 1, 0, 0, { type = "PercentStat", stat = "EnergyShield", percentVar = "KiloavaRecoverOnBlock", floor = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kiloava" }),
		mod("ManaOnBlock", "BASE", 1, 0, 0, { type = "PercentStat", stat = "Mana", percentVar = "KiloavaRecoverOnBlock", floor = true }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Kiloava" }),
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_valako_tattoo", 20 },
		{ "ancestral_buff_recover_%_of_maximum_life_mana_energy_shield_on_block", 5 },
	},
	stats = {
		"trigger_on_block_hit_from_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_block_hit_from_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorMaata"] = {
	name = "Summon Spirit of Maata",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Tawhoa tribe to fight alongside you for a duration. This minion grants you a buff which refills flasks. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralMaataMinion",
	},
	statMap = {
		["ancestral_buff_flask_charges_recovered_per_3_seconds"] = {
			mod("FlaskChargesGenerated", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Maata" }, { type = "Multiplier", var = "TawhoaTattooEffect", noFloor = true }),
			div = 3,
		},
		["ancestral_embrace_effect_+%_per_tawhoa_tattoo"] = {
			mod("Multiplier:TawhoaTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "TawhoaTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_tawhoa_tattoo", 20 },
		{ "ancestral_buff_flask_charges_recovered_per_3_seconds", 5 },
	},
	stats = {
		"trigger_on_reaching_low_life_in_presence_of_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_reaching_low_life_in_presence_of_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorRakiata"] = {
	name = "Summon Spirit of Rakiata",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Tasalio tribe to fight alongside you for a duration. This minion grants you a buff which prevents your action speed being lowered. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralRakiataMinion",
	},
	statMap = {
		["ancestral_buff_action_speed_+%_minimum_value"] = {
			mod("MinimumActionSpeed", "MAX", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Rakiata" }, { type = "Multiplier", var = "TasalioTattooEffect", noFloor = true, base = 100 }),
		},
		["ancestral_embrace_effect_+%_per_tasalio_tattoo"] = {
			mod("Multiplier:TasalioTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "TasalioTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_tasalio_tattoo", 20 },
		{ "ancestral_buff_action_speed_+%_minimum_value", 10 },
	},
	stats = {
		"trigger_on_crit_vs_marked_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_crit_vs_marked_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorTawhanuku"] = {
	name = "Summon Spirit of Tawhanuku",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Hinekora tribe to fight alongside you for a duration. This minion grants you a buff which regenerates mana. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralTawhanukuMinion",
	},
	statMap = {
		["ancestral_buff_base_mana_regeneration_rate_per_minute"] = {
			mod("ManaRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Tawhanuku" }, { type = "Multiplier", var = "HinekoraTattooEffect", noFloor = true }),
			div = 60,
		},
		["ancestral_embrace_effect_+%_per_hinekora_tattoo"] = {
			mod("Multiplier:HinekoraTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "HinekoraTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_hinekora_tattoo", 20 },
		{ "ancestral_buff_base_mana_regeneration_rate_per_minute", 6000 },
	},
	stats = {
		"trigger_on_es_recharge_in_presence_of_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_es_recharge_in_presence_of_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["TriggerSummonedAncestorUtula"] = {
	name = "Summon Spirit of Utula",
	hidden = true,
	color = 4,
	description = "Summons an immortal chieftain minion of the Kitava tribe to fight alongside you for a duration. This minion grants you a buff which makes a percentage of your leech recover instantly. Shares a Cooldown with other Spirit Chieftain Skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Cooldown] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromTree = true,
	minionList = {
		"AncestralUtulaMinion",
	},
	statMap = {
		["ancestral_buff_leech_%_is_instant"] = {
			mod("InstantLifeLeech", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Utula" }, { type = "Multiplier", var = "KitavaTattooEffect", noFloor = true }),
			mod("InstantManaLeech", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Utula" }, { type = "Multiplier", var = "KitavaTattooEffect", noFloor = true }),
			mod("InstantEnergyShieldLeech", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Spirit of Utula" }, { type = "Multiplier", var = "KitavaTattooEffect", noFloor = true }),
		},
		["ancestral_embrace_effect_+%_per_kitava_tattoo"] = {
			mod("Multiplier:KitavaTattooEffect", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }, { type = "Multiplier", var = "KitavaTattoo", base = 1 }),
			div = 100,
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 12000 },
		{ "minion_actor_level_is_user_level_up_to_maximum", 85 },
		{ "ancestral_embrace_effect_+%_per_kitava_tattoo", 20 },
		{ "ancestral_buff_leech_%_is_instant", 25 },
	},
	stats = {
		"trigger_on_taking_savage_hit_from_unique",
		"chance_to_cast_on_kill_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	notMinionStat = {
		"trigger_on_taking_savage_hit_from_unique",
	},
	levels = {
		[1] = { cooldown = 80, levelRequirement = 0, storedUses = 1, },
		[2] = { 10, cooldown = 20, levelRequirement = 0, storedUses = 1, statInterpolation = { 1, }, },
		[20] = { cooldown = 20, levelRequirement = 0, storedUses = 1, },
	},
}
skills["SupportUniqueCastCurseOnCurse"] = {
	name = "Vixen's Entrapment",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.AppliesCurse, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.AuraAffectsEnemies, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	constantStats = {
		{ "cast_when_cast_curse_%", 100 },
	},
	stats = {
		"cannot_cast_curses",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 0, storedUses = 1, },
	},
}
skills["SupportTriggerFireSpellOnHit"] = {
	name = "SupportTriggerFireSpellOnHit",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, SkillType.Fire, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	isTrigger = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	statMap = {
		["spell_is_triggered_on_hit"] = {
			skill("triggeredBySettlersEnchantTrigger", true)
		}
	},
	stats = {
		"spell_is_triggered_on_hit",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["EnemyExplode"] = {
	name = "On Kill Monster Explosion",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true },
	castTime = 0,
	parts = {
		{
			name = "This Source Only",
		},
		{
			name = "This Source Only, Ignoring Chance",
		},
		{
			name = "Average Of All Sources",
		},
	},
	preDamageFunc = function(activeSkill, output)
		output.ExplodeChance = 0
		if activeSkill.skillPart ~= 3 then
			local allExplodeMods = activeSkill.skillModList:Tabulate("LIST", activeSkill.skillCfg, "ExplodeMod")
			for _, explodeMod in ipairs(allExplodeMods) do
				local activeEffectSource = activeSkill.activeEffect.srcInstance.explodeSource.modSource or "Tree:"..activeSkill.activeEffect.srcInstance.explodeSource.id
				if explodeMod.mod.source == activeEffectSource then
					local explodeMod = explodeMod.value
					if explodeMod.type == "RandomElement" then
						activeSkill.skillData["FireEffectiveExplodePercentage"] = explodeMod.amount / 3
						activeSkill.skillData["ColdEffectiveExplodePercentage"] = explodeMod.amount / 3
						activeSkill.skillData["LightningEffectiveExplodePercentage"] = explodeMod.amount / 3
					else
						activeSkill.skillData[explodeMod.type.."EffectiveExplodePercentage"] = explodeMod.amount
					end
					output.ExplodeChance = activeSkill.skillPart == 2 and 1 or explodeMod.chance
				end
			end
		else
			local typeAmountChances = { }
			local explodeModList = activeSkill.skillModList:List(activeSkill.skillCfg, "ExplodeMod")
			for _, explodeMod in ipairs(explodeModList) do
				local amountChance = typeAmountChances[explodeMod.type] or {}
				amountChance[explodeMod.amount] = (amountChance[explodeMod.amount] or 0) + explodeMod.chance
				typeAmountChances[explodeMod.type] = amountChance
			end
			for type, amountChance in pairs(typeAmountChances) do
				local physExplodeChance = 0
				for amount, chance in pairs(amountChance) do
					local amountXChance = amount * chance
					if type == "RandomElement" then
						activeSkill.skillData["FireEffectiveExplodePercentage"] = (activeSkill.skillData["FireEffectiveExplodePercentage"] or 0) + amountXChance / 3
						activeSkill.skillData["ColdEffectiveExplodePercentage"] = (activeSkill.skillData["ColdEffectiveExplodePercentage"] or 0) + amountXChance / 3
						activeSkill.skillData["LightningEffectiveExplodePercentage"] = (activeSkill.skillData["LightningEffectiveExplodePercentage"] or 0) + amountXChance / 3
					else
						activeSkill.skillData[type.."EffectiveExplodePercentage"] = (activeSkill.skillData[type.."EffectiveExplodePercentage"] or 0) + amountXChance
					end
					if type == "Physical" then
						physExplodeChance = 1 - ((1 - physExplodeChance) * (1 - chance))
					end
					output.ExplodeChance = 1 - ((1 - output.ExplodeChance) * (1 - chance))
				end
				if type == "Physical" and physExplodeChance ~= 0 then
					activeSkill.skillModList:NewMod("CalcArmourAsThoughDealing", "MORE", 100 / math.min(physExplodeChance, 1) - 100)
				end
			end
		end
		output.ExplodeChance = math.min(output.ExplodeChance * 100, 100)
	end,
	baseMods = {
		skill("radius", 22),
		skill("showAverage", true),
		skill("explodeCorpse", true),
		skill("corpseExplosionLifeMultiplier", 0),
		skill("hitChanceIsExplodeChance", true, { type = "SkillPart", skillPart = 1 }),
	},
	baseFlags = {
		area = true,
		monsterExplode = true
	},
	stats = {
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"damage_cannot_be_reflected",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { damageEffectiveness = 1, baseMultiplier = 1, levelRequirement = 1, }
	}
}
