import * as React from 'react';
import Svg, { SvgProps, G, Path, Defs, LinearGradient, Stop, ClipPath, Rect } from 'react-native-svg';

const JoplinCloudIcon: React.FC<SvgProps> = props => {
	return <Svg
		viewBox='0 0 84 84'
		fill='none'
		{...props}
	>
		<G clipPath='url(#a)'>
			<Path fill='url(#b)' d='M0 0h84v84H0z'/>
			<Path
				fill='#fff'
				d='M73.706 49.825c0 3.732-1.534 7.148-4.007 9.592a13.714 13.714 0 0 1-9.675 3.973h-8.199v-7.065h8.2c1.818 0 3.436-.723 4.635-1.904 1.19-1.188 1.92-2.784 1.92-4.596 0-1.804-.73-3.408-1.92-4.597a6.539 6.539 0 0 0-4.636-1.903h-6.933l.386-3.882c.042-.4.059-.79.059-1.197 0-3.3-1.342-6.251-3.513-8.412a11.964 11.964 0 0 0-8.484-3.483c-3.328 0-6.304 1.33-8.484 3.483-2.18 2.16-3.513 5.112-3.513 8.412 0 .399.017.798.06 1.197l.385 3.882h-6.154c-1.819 0-3.437.723-4.636 1.903-1.19 1.189-1.92 2.785-1.92 4.597 0 1.803.73 3.408 1.92 4.596a6.539 6.539 0 0 0 4.636 1.904h9.935a8.854 8.854 0 0 0 4.82-2.452 8.705 8.705 0 0 0 2.59-6.201v-7.523h-7.217v-2.726c0-2.32 1.903-4.215 4.25-4.215h9.968v14.464c0 4.14-1.685 8.187-4.636 11.105-2.6 2.585-6.078 4.19-9.733 4.53l-.923.083h-9.062c-3.764 0-7.21-1.52-9.674-3.973a13.483 13.483 0 0 1 0-19.185 13.673 13.673 0 0 1 8.35-3.906c.452-4.464 2.48-8.487 5.507-11.488a19.154 19.154 0 0 1 13.523-5.552 19.16 19.16 0 0 1 13.522 5.552 18.842 18.842 0 0 1 5.5 11.446c3.554.141 6.782 1.613 9.129 3.948a13.428 13.428 0 0 1 4.024 9.593z'
				strokeWidth={1.3}
			/>
		</G>
		<Defs>
			<LinearGradient
				id='b'
				x1={3}
				x2={78}
				y1={4}
				y2={79}
				gradientUnits='userSpaceOnUse'
			>
				<Stop offset={0.14} stopColor='#3873DB'/>
				<Stop offset={0.974} stopColor='#163467'/>
			</LinearGradient>
			<ClipPath id='a'>
				<Rect width={84} height={84} fill='#fff' rx={20} />
			</ClipPath>
		</Defs>
	</Svg>;
};

export default JoplinCloudIcon;
