package story_event_history

import (
	"elichika/client/request"
	"elichika/client/response"
	"elichika/config"
	"elichika/handler/common"
	"elichika/item"
	"elichika/router"
	"elichika/subsystem/user_content"
	"elichika/subsystem/user_story_event_history"
	"elichika/userdata"
	"elichika/utils"

	"encoding/json"

	"github.com/gin-gonic/gin"
)

func unlockStory(ctx *gin.Context) {
	req := request.UnlockStoryEventHistoryRequest{}
	err := json.Unmarshal(*ctx.MustGet("reqBody").(*json.RawMessage), &req)
	utils.CheckErr(err)

	session := ctx.MustGet("session").(*userdata.Session)

	user_story_event_history.UnlockEventStory(session, req.EventStoryMasterId)
	if config.Conf.ResourceConfig().ConsumeMiscItems {
		user_content.RemoveContent(session, item.MemoryKey)
	}

	common.JsonResponse(ctx, response.UserModelResponse{
		UserModel: &session.UserModel,
	})
}

func init() {
	router.AddHandler("/", "POST", "/storyEventHistory/unlockStory", unlockStory)
}
