package live

import (
	"elichika/client/request"
	"elichika/handler/common"
	"elichika/router"
	"elichika/subsystem/user_live"
	"elichika/userdata"
	"elichika/utils"

	"encoding/json"

	"github.com/gin-gonic/gin"
)

func skip(ctx *gin.Context) {
	req := request.SkipLiveRequest{}
	err := json.Unmarshal(*ctx.MustGet("reqBody").(*json.RawMessage), &req)
	utils.CheckErr(err)

	session := ctx.MustGet("session").(*userdata.Session)

	resp := user_live.SkipLive(session, req)

	common.JsonResponse(ctx, &resp)
}

func init() {
	router.AddHandler("/", "POST", "/live/skip", skip)
}
