package client

import (
	"elichika/generic"
)

// user_model and user_model_diff both use this, just that the outer key is different
// might be possible to mod the client to only use one thing, but maybe there will be some part where it matter
type UserModel struct {
	UserStatus                                                                 UserStatus                                                              `json:"user_status"` // is a pointer
	UserMemberByMemberId                                                       generic.Dictionary[int32, UserMember]                                   `json:"user_member_by_member_id" table:"u_member" key:"member_master_id"`
	UserCardByCardId                                                           generic.Dictionary[int32, UserCard]                                     `json:"user_card_by_card_id" table:"u_card" key:"card_master_id"`
	UserSuitBySuitId                                                           generic.Dictionary[int32, UserSuit]                                     `json:"user_suit_by_suit_id" table:"u_suit" key:"suit_master_id"`
	UserLiveDeckById                                                           generic.Dictionary[int32, UserLiveDeck]                                 `json:"user_live_deck_by_id" table:"u_live_deck" key:"user_live_deck_id"`
	UserLivePartyById                                                          generic.Dictionary[int32, UserLiveParty]                                `json:"user_live_party_by_id" table:"u_live_party" key:"party_id"`
	UserLessonDeckById                                                         generic.Dictionary[int32, UserLessonDeck]                               `json:"user_lesson_deck_by_id" table:"u_lesson_deck" key:"user_lesson_deck_id"`
	UserLiveMvDeckById                                                         generic.Dictionary[int32, UserLiveMvDeck]                               `json:"user_live_mv_deck_by_id" table:"u_live_mv_deck" key:"live_master_id"`
	UserLiveMvDeckCustomById                                                   generic.Dictionary[int32, UserLiveMvDeck]                               `json:"user_live_mv_deck_custom_by_id" table:"u_live_mv_deck_custom" key:"live_master_id"`
	UserLiveDifficultyByDifficultyId                                           generic.Dictionary[int32, UserLiveDifficulty]                           `json:"user_live_difficulty_by_difficulty_id" table:"u_live_difficulty" key:"live_difficulty_id"`
	UserStoryMainByStoryMainId                                                 generic.Dictionary[int32, UserStoryMain]                                `json:"user_story_main_by_story_main_id" table:"u_story_main" key:"story_main_master_id"`
	UserStoryMainSelectedByStoryMainCellId                                     generic.Dictionary[int32, UserStoryMainSelected]                        `json:"user_story_main_selected_by_story_main_cell_id" table:"u_story_main_selected" key:"story_main_cell_id"`
	UserVoiceByVoiceId                                                         generic.Dictionary[int32, UserVoice]                                    `json:"user_voice_by_voice_id" table:"u_voice" key:"navi_voice_master_id"`
	UserEmblemByEmblemId                                                       generic.Dictionary[int32, UserEmblem]                                   `json:"user_emblem_by_emblem_id" table:"u_emblem" key:"emblem_m_id"`
	UserGachaTicketByTicketId                                                  generic.Dictionary[int32, UserGachaTicket]                              `json:"user_gacha_ticket_by_ticket_id" table:"u_content"`
	UserGachaPointByPointId                                                    generic.Dictionary[int32, UserGachaPoint]                               `json:"user_gacha_point_by_point_id" table:"u_content"`
	UserLessonEnhancingItemByItemId                                            generic.Dictionary[int32, UserLessonEnhancingItem]                      `json:"user_lesson_enhancing_item_by_item_id" table:"u_content"`
	UserTrainingMaterialByItemId                                               generic.Dictionary[int32, UserTrainingMaterial]                         `json:"user_training_material_by_item_id" table:"u_content"`
	UserGradeUpItemByItemId                                                    generic.Dictionary[int32, UserGradeUpItem]                              `json:"user_grade_up_item_by_item_id" table:"u_content"`
	UserCustomBackgroundById                                                   generic.Dictionary[int32, UserCustomBackground]                         `json:"user_custom_background_by_id" table:"u_custom_background" key:"custom_background_master_id"`
	UserStorySideById                                                          generic.Dictionary[int32, UserStorySide]                                `json:"user_story_side_by_id" table:"u_story_side" key:"story_side_master_id"`
	UserStoryMemberById                                                        generic.Dictionary[int32, UserStoryMember]                              `json:"user_story_member_by_id" table:"u_story_member" key:"story_member_master_id"`
	UserCommunicationMemberDetailBadgeById                                     generic.Dictionary[int32, UserCommunicationMemberDetailBadge]           `json:"user_communication_member_detail_badge_by_id" table:"u_communication_member_detail_badge" key:"member_master_id"`
	UserStoryEventHistoryById                                                  generic.Dictionary[int32, UserStoryEventHistory]                        `json:"user_story_event_history_by_id" table:"u_story_event_history" key:"story_event_id"`
	UserRecoveryLpById                                                         generic.Dictionary[int32, UserRecoveryLp]                               `json:"user_recovery_lp_by_id" table:"u_content"`
	UserRecoveryApById                                                         generic.Dictionary[int32, UserRecoveryAp]                               `json:"user_recovery_ap_by_id" table:"u_content"`
	UserMissionByMissionId                                                     generic.Dictionary[int32, UserMission]                                  `json:"user_mission_by_mission_id" table:"u_mission" key:"mission_m_id"`
	UserDailyMissionByMissionId                                                generic.Dictionary[int32, UserDailyMission]                             `json:"user_daily_mission_by_mission_id" table:"u_daily_mission" key:"mission_m_id"`
	UserWeeklyMissionByMissionId                                               generic.Dictionary[int32, UserWeeklyMission]                            `json:"user_weekly_mission_by_mission_id" table:"u_weekly_mission" key:"mission_m_id"`
	UserInfoTriggerBasicByTriggerId                                            generic.Dictionary[int64, UserInfoTriggerBasic]                         `json:"user_info_trigger_basic_by_trigger_id" table:"u_info_trigger_basic" key:"trigger_id"`
	UserInfoTriggerCardGradeUpByTriggerId                                      generic.Dictionary[int64, UserInfoTriggerCardGradeUp]                   `json:"user_info_trigger_card_grade_up_by_trigger_id" table:"u_info_trigger_card_grade_up" key:"trigger_id"`
	UserInfoTriggerMemberGuildSupportItemExpiredByTriggerId                    generic.Dictionary[int64, UserInfoTriggerMemberGuildSupportItemExpired] `json:"user_info_trigger_member_guild_support_item_expired_by_trigger_id" table:"u_info_trigger_member_guild_support_item_expired" key:"trigger_id"`
	UserInfoTriggerMemberLoveLevelUpByTriggerId                                generic.Dictionary[int64, UserInfoTriggerMemberLoveLevelUp]             `json:"user_info_trigger_member_love_level_up_by_trigger_id" table:"u_info_trigger_member_love_level_up" key:"trigger_id"`
	UserAccessoryByUserAccessoryId                                             generic.Dictionary[int64, UserAccessory]                                `json:"user_accessory_by_user_accessory_id" table:"u_accessory" key:"user_accessory_id"`
	UserAccessoryLevelUpItemById                                               generic.Dictionary[int32, UserAccessoryLevelUpItem]                     `json:"user_accessory_level_up_item_by_id" table:"u_content"`
	UserAccessoryRarityUpItemById                                              generic.Dictionary[int32, UserAccessoryRarityUpItem]                    `json:"user_accessory_rarity_up_item_by_id" table:"u_content"`
	UserUnlockScenesByEnum                                                     generic.Dictionary[int32, UserUnlockScene]                              `json:"user_unlock_scenes_by_enum" table:"u_unlock_scenes" key:"unlock_scene_type"`
	UserSceneTipsByEnum                                                        generic.Dictionary[int32, UserSceneTips]                                `json:"user_scene_tips_by_enum" table:"u_scene_tips" key:"scene_tips_type"`
	UserRuleDescriptionById                                                    generic.Dictionary[int32, UserRuleDescription]                          `json:"user_rule_description_by_id" table:"u_rule_description" key:"rule_description_id"`
	UserExchangeEventPointById                                                 generic.Dictionary[int32, UserExchangeEventPoint]                       `json:"user_exchange_event_point_by_id" table:"u_content"`
	UserSchoolIdolFestivalIdRewardMissionById                                  generic.Dictionary[int32, UserSchoolIdolFestivalIdRewardMission]        `json:"user_school_idol_festival_id_reward_mission_by_id" table:"u_school_idol_festival_id_reward_mission" key:"school_idol_festival_id_reward_mission_master_id"`
	UserGpsPresentReceivedById                                                 generic.Dictionary[int32, UserGpsPresentReceived]                       `json:"user_gps_present_received_by_id" table:"u_gps_present_received" key:"campaign_id"`
	UserEventMarathonByEventMasterId                                           generic.Dictionary[int32, UserEventMarathon]                            `json:"user_event_marathon_by_event_master_id" table:"u_event_marathon" key:"event_master_id"`
	UserEventMiningByEventMasterId                                             generic.Dictionary[int32, UserEventMining]                              `json:"user_event_mining_by_event_master_id" table:"u_event_mining" key:"event_master_id"`
	UserEventCoopByEventMasterId                                               generic.Dictionary[int32, UserEventCoop]                                `json:"user_event_coop_by_event_master_id" table:"u_event_coop" key:"event_master_id"`
	UserLiveSkipTicketById                                                     generic.Dictionary[int32, UserLiveSkipTicket]                           `json:"user_live_skip_ticket_by_id" table:"u_content"`
	UserStoryEventUnlockItemById                                               generic.Dictionary[int32, UserStoryEventUnlockItem]                     `json:"user_story_event_unlock_item_by_id" table:"u_content"`
	UserEventMarathonBoosterById                                               generic.Dictionary[int32, UserEventMarathonBooster]                     `json:"user_event_marathon_booster_by_id" table:"u_content"`
	UserReferenceBookById                                                      generic.Dictionary[int32, UserReferenceBook]                            `json:"user_reference_book_by_id" table:"u_reference_book" key:"reference_book_id"`
	UserReviewRequestProcessFlowById                                           generic.Dictionary[int64, UserReviewRequestProcessFlow]                 `json:"user_review_request_process_flow_by_id" table:"u_review_request_process_flow" key:"review_request_id"`
	UserTowerByTowerId                                                         generic.Dictionary[int32, UserTower]                                    `json:"user_tower_by_tower_id" table:"u_tower" key:"tower_id"`
	UserRecoveryTowerCardUsedCountItemByRecoveryTowerCardUsedCountItemMasterId generic.Dictionary[int32, UserRecoveryTowerCardUsedCountItem]           `json:"user_recovery_tower_card_used_count_item_by_recovery_tower_card_used_count_item_master_id" table:"u_content"`
	UserStoryLinkageById                                                       generic.Dictionary[int32, UserStoryLinkage]                             `json:"user_story_linkage_by_id" table:"u_story_linkage" key:"story_linkage_cell_master_id"`
	UserSubscriptionStatusById                                                 generic.Dictionary[int32, UserSubscriptionStatus]                       `json:"user_subscription_status_by_id" table:"u_subscription_status" key:"subscription_master_id"`
	UserStoryMainPartDigestMovieById                                           generic.Dictionary[int32, UserStoryMainPartDigestMovie]                 `json:"user_story_main_part_digest_movie_by_id" table:"u_story_main_part_digest_movie" key:"story_main_part_master_id"`
	UserMemberGuildById                                                        generic.Dictionary[int32, UserMemberGuild]                              `json:"user_member_guild_by_id" table:"u_member_guild" key:"member_guild_id"`
	UserMemberGuildSupportItemById                                             generic.Dictionary[int32, UserMemberGuildSupportItem]                   `json:"user_member_guild_support_item_by_id" table:"u_member_guild_support_item" key:"support_item_id"`
	UserDailyTheaterByDailyTheaterId                                           generic.Dictionary[int32, UserDailyTheater]                             `json:"user_daily_theater_by_daily_theater_id" table:"u_daily_theater" key:"daily_theater_id"`
	UserPlayListById                                                           generic.Dictionary[int32, UserPlayList]                                 `json:"user_play_list_by_id" table:"u_play_list" key:"user_play_list_id"`
	UserSetProfileById                                                         generic.Dictionary[int32, UserSetProfile]                               `json:"user_set_profile_by_id" table:"u_set_profile" key:"user_set_profile_id"`
	UserSteadyVoltageRankingById                                               generic.Dictionary[int32, UserSteadyVoltageRanking]                     `json:"user_steady_voltage_ranking_by_id" table:"u_steady_voltage_ranking" key:"steady_voltage_ranking_master_id"`
	UserSif2DataLinkById                                                       generic.Dictionary[int32, UserSif2DataLink]                             `json:"user_sif_2_data_link_by_id" table:"u_sif_2_data_link" key:"sif_2_id"`
}
