/*
 * Decompiled with CFR 0.152.
 */
package net.whitegem.pixeldungeon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Game;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.windows.WndError;
import com.watabou.utils.BitmapCache;
import net.whitegem.pixeldungeon.LanguageFactory;

public class VersionUtil {
    public static boolean shown = false;
    public static int checkState = 0;

    public static void check() {
        if (checkState == 3) {
            return;
        }
        if (checkState == 0) {
            VersionUtil.checkGithubIsLatest();
        } else {
            switch (checkState) {
                case 1: {
                    break;
                }
                case 2: {
                    if (shown) break;
                    Game.scene().add(new WndError("This version of Chinese translation has expired."));
                    LanguageFactory.INSTANCE.setLanguage("en");
                    PixelScene.font1x = BitmapText.Font.colorMarked(BitmapCache.get("font1x.png"), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
                    PixelScene.font1x.baseLine = 6.0f;
                    PixelScene.font1x.tracking = -1.0f;
                    PixelScene.font15x = BitmapText.Font.colorMarked(BitmapCache.get("font15x.png"), 12, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
                    PixelScene.font15x.baseLine = 9.0f;
                    PixelScene.font15x.tracking = -1.0f;
                    PixelScene.font2x = BitmapText.Font.colorMarked(BitmapCache.get("font2x.png"), 14, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
                    PixelScene.font2x.baseLine = 11.0f;
                    PixelScene.font2x.tracking = -1.0f;
                    PixelScene.font25x = BitmapText.Font.colorMarked(BitmapCache.get("font25x.png"), 17, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
                    PixelScene.font25x.baseLine = 13.0f;
                    PixelScene.font25x.tracking = -1.0f;
                    PixelScene.font3x = BitmapText.Font.colorMarked(BitmapCache.get("font3x.png"), 22, 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
                    PixelScene.font3x.baseLine = 17.0f;
                    PixelScene.font3x.tracking = -2.0f;
                    shown = true;
                }
            }
        }
    }

    private static void checkGithubIsLatest() {
        checkState = 1;
        String version = Game.version;
        if (version.equals("???")) {
            checkState = 3;
            return;
        }
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl("https://api.github.com/repos/WiseClock/localized-pixel-dungeon-gdx/releases");
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                String result = httpResponse.getResultAsString();
                if (result == null) {
                    checkState = 2;
                    return;
                }
                JsonValue root = new JsonReader().parse(result);
                String versionNewest = root.get(0).getString("tag_name");
                if (Game.version.equals(versionNewest)) {
                    checkState = 3;
                    return;
                }
                checkState = 2;
            }

            @Override
            public void failed(Throwable t) {
                checkState = 2;
            }

            @Override
            public void cancelled() {
                checkState = 2;
            }
        });
    }
}

