/*
 * Decompiled with CFR 0.152.
 */
package net.whitegem.pixeldungeon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Translator {
    private String language;
    private HashMap<String, String> translation;

    public Translator(String language) {
        this.language = language;
        this.translation = new HashMap();
        FileHandle file = Gdx.files.internal("translation/" + language + ".txt");
        BufferedReader reader = new BufferedReader(file.reader("UTF8"));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().equals("") && !line.trim().startsWith("#")) {
                    lines.add(line.trim());
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (lines.size() % 2 != 0) {
            Gdx.app.log("Translator", "ERROR READING FILE translation/" + language + ".txt", new Exception("Lines of original texts and translated texts in the translation file do not match."));
        }
        for (int i = 0; i < lines.size(); i += 2) {
            String trans = (String)lines.get(i + 1);
            this.translation.put(((String)lines.get(i)).toLowerCase(), trans);
        }
    }

    public String fixWrap(String inText) {
        boolean hasChinese = false;
        for (char c : inText.toCharArray()) {
            if (!Translator.isChinese(c)) continue;
            hasChinese = true;
            break;
        }
        if (!hasChinese) {
            return inText;
        }
        return inText;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public String[] splitWords(String paragraph) {
        if (this.language.equals("en")) {
            String[] pre = Pattern.compile("\\s+").split(paragraph);
            ArrayList<String> tmp = new ArrayList<String>();
            for (String s : pre) {
                tmp.add(s);
                tmp.add(" ");
            }
            return tmp.toArray(new String[tmp.size()]);
        }
        ArrayList<String> words = new ArrayList<String>();
        int start = 0;
        int end = 1;
        while (start != paragraph.length()) {
            String str = paragraph.substring(start, end);
            if (str.length() == 1 && (Translator.isChinese(str.charAt(0)) || str.equals(" "))) {
                words.add(str);
                ++start;
                ++end;
                continue;
            }
            if (end == paragraph.length()) {
                words.add(str.trim());
                start = end++;
                continue;
            }
            String endStr = paragraph.substring(end - 1, end);
            String endStrNext = paragraph.substring(end, end + 1);
            if (endStr.equals(" ") || endStr.matches("\\p{P}") && !endStrNext.matches("[0-9]") || endStr.matches("[0-9]") && !endStrNext.matches("[0-9]") && !endStrNext.matches("\\p{P}")) {
                words.add(str);
                start = end;
            }
            ++end;
        }
        return words.toArray(new String[words.size()]);
    }

    public boolean hasKey(String key) {
        return this.translation.containsKey(key.toLowerCase());
    }

    public String translate(String originalText) {
        if (this.hasKey(originalText)) {
            return this.translation.get(originalText.toLowerCase());
        }
        return originalText;
    }
}

