/*
 * Decompiled with CFR 0.152.
 */
package net.whitegem.pixeldungeon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.watabou.noosa.BitmapText;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.utils.BitmapCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.whitegem.pixeldungeon.LanguageFactory;

public class LanguageUtil {
    private static String code = "en";
    private static HashMap<String, FontSettings> fonts = new HashMap();

    private static void getCode() {
        fonts.clear();
        if (Gdx.files.internal("translation/language.settings").exists()) {
            FileHandle file = Gdx.files.internal("translation/language.settings");
            BufferedReader reader = new BufferedReader(file.reader("UTF8"));
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (!line.trim().equals("") && !line.trim().startsWith("#")) {
                        lines.add(line.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            HashMap<String, String> settings = new HashMap<String, String>();
            if (lines.size() > 0) {
                for (String line : lines) {
                    String[] pieces = line.split("=");
                    if (pieces.length != 2) continue;
                    settings.put(pieces[0].toLowerCase(), pieces[1]);
                }
                if (settings.containsKey("lang") && settings.containsKey("font1x") && settings.containsKey("font15x") && settings.containsKey("font2x") && settings.containsKey("font25x") && settings.containsKey("font3x")) {
                    code = (String)settings.get("lang");
                    fonts.put("font1x", new FontSettings((String)settings.get("font1x")));
                    fonts.put("font15x", new FontSettings((String)settings.get("font15x")));
                    fonts.put("font2x", new FontSettings((String)settings.get("font2x")));
                    fonts.put("font25x", new FontSettings((String)settings.get("font25x")));
                    fonts.put("font3x", new FontSettings((String)settings.get("font3x")));
                }
            }
        }
    }

    public static void setLanguage() {
        LanguageUtil.getCode();
        LanguageFactory.INSTANCE.setLanguage(code);
        if (!code.equals("en")) {
            PixelScene.font1x = BitmapText.Font.colorMarked(BitmapCache.get(LanguageUtil.fonts.get((Object)"font1x").png), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", LanguageUtil.fonts.get((Object)"font1x").fnt, LanguageUtil.fonts.get((Object)"font1x").scale);
            PixelScene.font1x.baseLine = fonts.get("font1x").getBaseline(7.0f);
            PixelScene.font1x.tracking = -1.0f;
            PixelScene.font15x = BitmapText.Font.colorMarked(BitmapCache.get(LanguageUtil.fonts.get((Object)"font15x").png), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", LanguageUtil.fonts.get((Object)"font15x").fnt, LanguageUtil.fonts.get((Object)"font15x").scale);
            PixelScene.font15x.baseLine = fonts.get("font15x").getBaseline(10.0f);
            PixelScene.font15x.tracking = -1.0f;
            PixelScene.font2x = BitmapText.Font.colorMarked(BitmapCache.get(LanguageUtil.fonts.get((Object)"font2x").png), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", LanguageUtil.fonts.get((Object)"font2x").fnt, LanguageUtil.fonts.get((Object)"font2x").scale);
            PixelScene.font2x.baseLine = fonts.get("font2x").getBaseline(12.0f);
            PixelScene.font2x.tracking = -1.0f;
            PixelScene.font25x = BitmapText.Font.colorMarked(BitmapCache.get(LanguageUtil.fonts.get((Object)"font25x").png), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", LanguageUtil.fonts.get((Object)"font25x").fnt, LanguageUtil.fonts.get((Object)"font25x").scale);
            PixelScene.font25x.baseLine = fonts.get("font25x").getBaseline(18.0f);
            PixelScene.font25x.tracking = -1.0f;
            PixelScene.font3x = BitmapText.Font.colorMarked(BitmapCache.get(LanguageUtil.fonts.get((Object)"font3x").png), 0, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", LanguageUtil.fonts.get((Object)"font3x").fnt, LanguageUtil.fonts.get((Object)"font3x").scale);
            PixelScene.font3x.baseLine = fonts.get("font3x").getBaseline(22.0f);
            PixelScene.font3x.tracking = -1.0f;
        }
    }

    private static class FontSettings {
        protected String fnt;
        protected String png;
        protected float baseline = -1.0f;
        protected int scale = -1;

        public FontSettings(String line) {
            String[] pieces = line.split(",");
            float b = -1.0f;
            int s = 1;
            String f = "";
            String p = "";
            switch (pieces.length) {
                case 4: {
                    p = pieces[3];
                    s = Integer.parseInt(pieces[2]);
                }
                case 2: {
                    b = Float.parseFloat(pieces[1]);
                }
                case 1: {
                    f = pieces[0];
                }
            }
            this.fnt = "translation/" + f + ".fnt";
            this.png = p.equals("") ? "translation/" + f + ".png" : "translation/" + p + ".png";
            this.baseline = b;
            this.scale = s;
        }

        public float getBaseline(float def) {
            return this.baseline == -1.0f ? def : this.baseline;
        }
    }
}

