/*
 * Decompiled with CFR 0.152.
 */
package net.whitegem.pixeldungeon;

import net.whitegem.pixeldungeon.StoredFormat;
import net.whitegem.pixeldungeon.Translator;

public class LanguageFactory {
    public static final LanguageFactory INSTANCE = new LanguageFactory();
    private Translator translator;
    public StoredFormat stored = new StoredFormat();
    public String language = "chs";

    private LanguageFactory() {
        this.translator = new Translator(this.language);
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public String translate(String originalText) {
        System.out.println("Translating >>> " + originalText);
        String textTemp = originalText.replace("\n", "\\n").trim().toLowerCase();
        if (this.translator.hasKey(textTemp)) {
            return this.translator.translate(textTemp).replace("\\n", "\n");
        }
        if (this.translator.hasKey(textTemp.replaceAll("\\.$", ""))) {
            return this.translator.translate(textTemp.replaceAll("\\.$", "")).replace("\\n", "\n") + ".";
        }
        return originalText;
    }

    public boolean hasKey(String key) {
        return this.translator.hasKey(key = key.trim().replace("\n", "\\n")) || this.translator.hasKey(key.replaceAll("\\.$", ""));
    }

    public String fixWrap(String inText) {
        return this.translator.fixWrap(inText);
    }

    public void addFormatTranslation(String formattedText, String format, Object ... args) {
        System.out.println("Utils.format >>> " + formattedText + " ||| " + format + " ||| " + args);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            System.out.println(args[i]);
            if (this.stored.contains(args[i].toString().toLowerCase())) {
                args[i] = this.stored.get(args[i].toString().toLowerCase());
                continue;
            }
            if (this.stored.contains(args[i].toString().toLowerCase().replaceAll("\\.$", ""))) {
                args[i] = this.stored.get(args[i].toString().toLowerCase().replaceAll("\\.$", ""));
                continue;
            }
            if (!this.hasKey(args[i].toString().trim().toLowerCase())) continue;
            System.out.println(this.translate(args[i].toString()));
            args[i] = this.translate(args[i].toString().trim());
        }
        if (this.hasKey(format)) {
            this.stored.put(formattedText.toLowerCase(), String.format(this.translate(format), args));
        } else {
            this.stored.put(formattedText.toLowerCase(), String.format(format, args));
        }
    }

    public String[] splitWords(String paragraph) {
        return this.translator.splitWords(paragraph);
    }

    public static String getTranslation(String text) {
        System.out.println("Getting translation for >>> " + text);
        if (!LanguageFactory.INSTANCE.language.equals("en")) {
            String s = null;
            if (text != null && LanguageFactory.INSTANCE.stored.contains(text.toLowerCase())) {
                s = LanguageFactory.INSTANCE.stored.get(text.toLowerCase());
            } else if (text != null && LanguageFactory.INSTANCE.stored.contains(text.toLowerCase().replaceAll("\\.$", ""))) {
                s = LanguageFactory.INSTANCE.stored.get(text.toLowerCase().replaceAll("\\.$", "")) + ".";
            }
            if (text != null) {
                text = s == null ? INSTANCE.translate(text) : s;
                text = INSTANCE.fixWrap(text);
            }
        }
        return text;
    }
}

