/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import java.util.LinkedList;

public class Signal<T> {
    private LinkedList<Listener<T>> listeners = new LinkedList();
    private boolean canceled;
    private boolean stackMode;

    public Signal() {
        this(false);
    }

    public Signal(boolean stackMode) {
        this.stackMode = stackMode;
    }

    public void add(Listener<T> listener) {
        if (!this.listeners.contains(listener)) {
            if (this.stackMode) {
                this.listeners.addFirst(listener);
            } else {
                this.listeners.addLast(listener);
            }
        }
    }

    public void remove(Listener<T> listener) {
        this.listeners.remove(listener);
    }

    public void removeAll() {
        this.listeners.clear();
    }

    public void replace(Listener<T> listener) {
        this.removeAll();
        this.add(listener);
    }

    public int numListeners() {
        return this.listeners.size();
    }

    public void dispatch(T t) {
        Listener[] list = this.listeners.toArray(new Listener[0]);
        this.canceled = false;
        for (int i = 0; i < list.length; ++i) {
            Listener listener = list[i];
            if (!this.listeners.contains(listener)) continue;
            listener.onSignal(t);
            if (!this.canceled) continue;
            return;
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public static interface Listener<T> {
        public void onSignal(T var1);
    }
}

