/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import java.util.Collection;
import java.util.HashMap;

public class Random {
    public static float Float(float min, float max) {
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static float Float(float max) {
        return (float)(Math.random() * (double)max);
    }

    public static float Float() {
        return (float)Math.random();
    }

    public static int Int(int max) {
        return max > 0 ? (int)(Math.random() * (double)max) : 0;
    }

    public static int Int(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min));
    }

    public static int IntRange(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static int NormalIntRange(int min, int max) {
        return min + (int)((Math.random() + Math.random()) * (double)(max - min + 1) / 2.0);
    }

    public static int chances(float[] chances) {
        int length = chances.length;
        float sum = chances[0];
        for (int i = 1; i < length; ++i) {
            sum += chances[i];
        }
        float value = Random.Float(sum);
        sum = chances[0];
        for (int i = 0; i < length; ++i) {
            if (value < sum) {
                return i;
            }
            sum += chances[i + 1];
        }
        return 0;
    }

    public static <K> K chances(HashMap<K, Float> chances) {
        int size = chances.size();
        Object[] values = chances.keySet().toArray();
        float[] probs = new float[size];
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            probs[i] = chances.get(values[i]).floatValue();
            sum += probs[i];
        }
        float value = Random.Float(sum);
        sum = probs[0];
        for (int i = 0; i < size; ++i) {
            if (value < sum) {
                return (K)values[i];
            }
            sum += probs[i + 1];
        }
        return null;
    }

    public static int index(Collection<?> collection) {
        return (int)(Math.random() * (double)collection.size());
    }

    public static <T> T oneOf(T ... array) {
        return array[(int)(Math.random() * (double)array.length)];
    }

    public static <T> T element(T[] array) {
        return Random.element(array, array.length);
    }

    public static <T> T element(T[] array, int max) {
        return array[(int)(Math.random() * (double)max)];
    }

    public static <T> T element(Collection<? extends T> collection) {
        int size = collection.size();
        return (T)(size > 0 ? collection.toArray()[Random.Int(size)] : null);
    }

    public static <T> void shuffle(T[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            int j = Random.Int(i, array.length);
            if (j == i) continue;
            T t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static <U, V> void shuffle(U[] u, V[] v) {
        for (int i = 0; i < u.length - 1; ++i) {
            int j = Random.Int(i, u.length);
            if (j == i) continue;
            U ut = u[i];
            u[i] = u[j];
            u[j] = ut;
            V vt = v[i];
            v[i] = v[j];
            v[j] = vt;
        }
    }
}

