/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import java.util.Arrays;
import java.util.LinkedList;

public class PathFinder {
    public static int[] distance;
    private static boolean[] goals;
    private static int[] queue;
    private static int size;
    private static int[] dir;

    public static void setMapSize(int width, int height) {
        int size = width * height;
        if (PathFinder.size != size) {
            PathFinder.size = size;
            distance = new int[size];
            goals = new boolean[size];
            queue = new int[size];
            dir = new int[]{-1, 1, -width, width, -width - 1, -width + 1, width - 1, width + 1};
        }
    }

    public static Path find(int from, int to, boolean[] passable) {
        if (!PathFinder.buildDistanceMap(from, to, passable)) {
            return null;
        }
        Path result = new Path();
        int s = from;
        do {
            int minD = distance[s];
            int mins = s;
            for (int i = 0; i < dir.length; ++i) {
                int n = s + dir[i];
                int thisD = distance[n];
                if (thisD >= minD) continue;
                minD = thisD;
                mins = n;
            }
            s = mins;
            result.add(s);
        } while (s != to);
        return result;
    }

    public static int getStep(int from, int to, boolean[] passable) {
        if (!PathFinder.buildDistanceMap(from, to, passable)) {
            return -1;
        }
        int minD = distance[from];
        int best = from;
        for (int i = 0; i < dir.length; ++i) {
            int step = from + dir[i];
            int stepD = distance[step];
            if (stepD >= minD) continue;
            minD = stepD;
            best = step;
        }
        return best;
    }

    public static int getStepBack(int cur, int from, boolean[] passable) {
        int d = PathFinder.buildEscapeDistanceMap(cur, from, 2.0f, passable);
        for (int i = 0; i < size; ++i) {
            PathFinder.goals[i] = distance[i] == d;
        }
        if (!PathFinder.buildDistanceMap(cur, goals, passable)) {
            return -1;
        }
        int s = cur;
        int minD = distance[s];
        int mins = s;
        for (int i = 0; i < dir.length; ++i) {
            int n = s + dir[i];
            int thisD = distance[n];
            if (thisD >= minD) continue;
            minD = thisD;
            mins = n;
        }
        return mins;
    }

    private static boolean buildDistanceMap(int from, int to, boolean[] passable) {
        if (from == to) {
            return false;
        }
        Arrays.fill(distance, Integer.MAX_VALUE);
        boolean pathFound = false;
        int head = 0;
        int tail = 0;
        PathFinder.queue[tail++] = to;
        PathFinder.distance[to] = 0;
        while (head < tail) {
            int step;
            if ((step = queue[head++]) == from) {
                pathFound = true;
                break;
            }
            int nextDistance = distance[step] + 1;
            for (int i = 0; i < dir.length; ++i) {
                int n = step + dir[i];
                if (n != from && (n < 0 || n >= size || !passable[n] || distance[n] <= nextDistance)) continue;
                PathFinder.queue[tail++] = n;
                PathFinder.distance[n] = nextDistance;
            }
        }
        return pathFound;
    }

    public static void buildDistanceMap(int to, boolean[] passable, int limit) {
        Arrays.fill(distance, Integer.MAX_VALUE);
        int head = 0;
        int tail = 0;
        PathFinder.queue[tail++] = to;
        PathFinder.distance[to] = 0;
        while (head < tail) {
            int step;
            int nextDistance;
            if ((nextDistance = distance[step = queue[head++]] + 1) > limit) {
                return;
            }
            for (int i = 0; i < dir.length; ++i) {
                int n = step + dir[i];
                if (n < 0 || n >= size || !passable[n] || distance[n] <= nextDistance) continue;
                PathFinder.queue[tail++] = n;
                PathFinder.distance[n] = nextDistance;
            }
        }
    }

    private static boolean buildDistanceMap(int from, boolean[] to, boolean[] passable) {
        if (to[from]) {
            return false;
        }
        Arrays.fill(distance, Integer.MAX_VALUE);
        boolean pathFound = false;
        int head = 0;
        int tail = 0;
        for (int i = 0; i < size; ++i) {
            if (!to[i]) continue;
            PathFinder.queue[tail++] = i;
            PathFinder.distance[i] = 0;
        }
        while (head < tail) {
            int step;
            if ((step = queue[head++]) == from) {
                pathFound = true;
                break;
            }
            int nextDistance = distance[step] + 1;
            for (int i = 0; i < dir.length; ++i) {
                int n = step + dir[i];
                if (n != from && (n < 0 || n >= size || !passable[n] || distance[n] <= nextDistance)) continue;
                PathFinder.queue[tail++] = n;
                PathFinder.distance[n] = nextDistance;
            }
        }
        return pathFound;
    }

    private static int buildEscapeDistanceMap(int cur, int from, float factor, boolean[] passable) {
        Arrays.fill(distance, Integer.MAX_VALUE);
        int destDist = Integer.MAX_VALUE;
        int head = 0;
        int tail = 0;
        PathFinder.queue[tail++] = from;
        PathFinder.distance[from] = 0;
        int dist = 0;
        while (head < tail) {
            int step;
            if ((dist = distance[step = queue[head++]]) > destDist) {
                return destDist;
            }
            if (step == cur) {
                destDist = (int)((float)dist * factor) + 1;
            }
            int nextDistance = dist + 1;
            for (int i = 0; i < dir.length; ++i) {
                int n = step + dir[i];
                if (n < 0 || n >= size || !passable[n] || distance[n] <= nextDistance) continue;
                PathFinder.queue[tail++] = n;
                PathFinder.distance[n] = nextDistance;
            }
        }
        return dist;
    }

    private static void buildDistanceMap(int to, boolean[] passable) {
        Arrays.fill(distance, Integer.MAX_VALUE);
        int head = 0;
        int tail = 0;
        PathFinder.queue[tail++] = to;
        PathFinder.distance[to] = 0;
        while (head < tail) {
            int step = queue[head++];
            int nextDistance = distance[step] + 1;
            for (int i = 0; i < dir.length; ++i) {
                int n = step + dir[i];
                if (n < 0 || n >= size || !passable[n] || distance[n] <= nextDistance) continue;
                PathFinder.queue[tail++] = n;
                PathFinder.distance[n] = nextDistance;
            }
        }
    }

    static {
        size = 0;
    }

    public static class Path
    extends LinkedList<Integer> {
    }
}

