/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.utils.Bundlable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Bundle {
    private static final String CLASS_NAME = "__className";
    private static HashMap<String, String> aliases = new HashMap();
    private JSONObject data;
    private static final char XOR_KEY = '\u001f';

    public Bundle() {
        this(new JSONObject());
    }

    public String toString() {
        return this.data.toString();
    }

    private Bundle(JSONObject data) {
        this.data = data;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public boolean contains(String key) {
        return !this.data.isNull(key);
    }

    public boolean getBoolean(String key) {
        return this.data.optBoolean(key);
    }

    public int getInt(String key) {
        return this.data.optInt(key);
    }

    public float getFloat(String key) {
        return (float)this.data.optDouble(key);
    }

    public String getString(String key) {
        return this.data.optString(key);
    }

    public Bundle getBundle(String key) {
        return new Bundle(this.data.optJSONObject(key));
    }

    private Bundlable get() {
        try {
            Class cl;
            String clName = this.getString(CLASS_NAME);
            if (aliases.containsKey(clName)) {
                clName = aliases.get(clName);
            }
            if ((cl = ClassReflection.forName(clName)) != null) {
                Bundlable object = (Bundlable)ClassReflection.newInstance(cl);
                object.restoreFromBundle(this);
                return object;
            }
            return null;
        }
        catch (Exception e2) {
            Object e2 = null;
            return null;
        }
    }

    public Bundlable get(String key) {
        return this.getBundle(key).get();
    }

    public <E extends Enum<E>> E getEnum(String key, Class<E> enumClass) {
        try {
            return Enum.valueOf(enumClass, this.data.getString(key));
        }
        catch (JSONException e) {
            return (E)((Enum[])enumClass.getEnumConstants())[0];
        }
    }

    public int[] getIntArray(String key) {
        try {
            JSONArray array = this.data.getJSONArray(key);
            int length = array.length();
            int[] result = new int[length];
            for (int i = 0; i < length; ++i) {
                result[i] = array.getInt(i);
            }
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean[] getBooleanArray(String key) {
        try {
            JSONArray array = this.data.getJSONArray(key);
            int length = array.length();
            boolean[] result = new boolean[length];
            for (int i = 0; i < length; ++i) {
                result[i] = array.getBoolean(i);
            }
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String[] getStringArray(String key) {
        try {
            JSONArray array = this.data.getJSONArray(key);
            int length = array.length();
            String[] result = new String[length];
            for (int i = 0; i < length; ++i) {
                result[i] = array.getString(i);
            }
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Collection<Bundlable> getCollection(String key) {
        ArrayList<Bundlable> list = new ArrayList<Bundlable>();
        try {
            JSONArray array = this.data.getJSONArray(key);
            for (int i = 0; i < array.length(); ++i) {
                list.add(new Bundle(array.getJSONObject(i)).get());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return list;
    }

    public void put(String key, boolean value) {
        try {
            this.data.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, int value) {
        try {
            this.data.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, float value) {
        try {
            this.data.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, String value) {
        try {
            this.data.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, Bundle bundle) {
        try {
            this.data.put(key, bundle.data);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, Bundlable object) {
        if (object != null) {
            try {
                Bundle bundle = new Bundle();
                bundle.put(CLASS_NAME, object.getClass().getName());
                object.storeInBundle(bundle);
                this.data.put(key, bundle.data);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void put(String key, Enum<?> value) {
        if (value != null) {
            try {
                this.data.put(key, value.name());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void put(String key, int[] array) {
        try {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < array.length; ++i) {
                jsonArray.put(i, array[i]);
            }
            this.data.put(key, jsonArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, boolean[] array) {
        try {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < array.length; ++i) {
                jsonArray.put(i, array[i]);
            }
            this.data.put(key, jsonArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, String[] array) {
        try {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < array.length; ++i) {
                jsonArray.put(i, array[i]);
            }
            this.data.put(key, jsonArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void put(String key, Collection<? extends Bundlable> collection) {
        JSONArray array = new JSONArray();
        for (Bundlable bundlable : collection) {
            Bundle bundle = new Bundle();
            bundle.put(CLASS_NAME, bundlable.getClass().getName());
            bundlable.storeInBundle(bundle);
            array.put(bundle.data);
        }
        try {
            this.data.put(key, array);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public static Bundle read(InputStream stream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            int count = reader.read(buffer);
            while (count > 0) {
                int i = 0;
                while (i < count) {
                    int n = i++;
                    buffer[n] = (char)(buffer[n] ^ 0x1F);
                }
                builder.append(buffer, 0, count);
                count = reader.read(buffer);
            }
            JSONObject json = (JSONObject)new JSONTokener(builder.toString()).nextValue();
            reader.close();
            return new Bundle(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Bundle read(byte[] bytes) {
        try {
            JSONObject json = (JSONObject)new JSONTokener(new String(bytes)).nextValue();
            return new Bundle(json);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static boolean write(Bundle bundle, OutputStream stream) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
            char[] chars = bundle.data.toString().toCharArray();
            int i = 0;
            while (i < chars.length) {
                int n = i++;
                chars[n] = (char)(chars[n] ^ 0x1F);
            }
            writer.write(chars);
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void addAlias(Class<?> cl, String alias) {
        aliases.put(alias, cl.getName());
    }
}

