/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import com.watabou.gdx.GdxTexture;
import java.util.HashMap;

public class BitmapCache {
    private static final String DEFAULT = "__default";
    private static HashMap<String, Layer> layers = new HashMap();

    public static GdxTexture get(String assetName) {
        return BitmapCache.get(DEFAULT, assetName);
    }

    public static GdxTexture get(String layerName, String assetName) {
        Layer layer;
        if (!layers.containsKey(layerName)) {
            layer = new Layer();
            layers.put(layerName, layer);
        } else {
            layer = layers.get(layerName);
        }
        if (layer.containsKey(assetName)) {
            return (GdxTexture)layer.get(assetName);
        }
        GdxTexture bmp = new GdxTexture(assetName);
        layer.put(assetName, bmp);
        return bmp;
    }

    public static void clear(String layerName) {
        if (layers.containsKey(layerName)) {
            layers.get(layerName).clear();
            layers.remove(layerName);
        }
    }

    public static void clear() {
        for (Layer layer : layers.values()) {
            layer.clear();
        }
        layers.clear();
    }

    private static class Layer
    extends HashMap<Object, GdxTexture> {
        private Layer() {
        }

        @Override
        public void clear() {
            for (GdxTexture bmp : this.values()) {
                bmp.dispose();
            }
            super.clear();
        }
    }
}

