/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.Wandmaker;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;

public class WndWandmaker
extends Window {
    private static final String TXT_MESSAGE = "Oh, I see you have succeeded! I do hope it hasn't troubled you too much. As I promised, you can choose one of my high quality wands.";
    private static final String TXT_BATTLE = "Battle wand";
    private static final String TXT_NON_BATTLE = "Non-battle wand";
    private static final String TXT_FARAWELL = "Good luck in your quest, %s!";
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float GAP = 2.0f;

    public WndWandmaker(final Wandmaker wandmaker, final Item item) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(item.image(), null));
        titlebar.label(Utils.capitalize(item.name()));
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        BitmapTextMultiline message = PixelScene.createMultiline(TXT_MESSAGE, 6.0f);
        message.maxWidth = 120;
        message.measure();
        message.y = titlebar.bottom() + 2.0f;
        this.add(message);
        RedButton btnBattle = new RedButton(TXT_BATTLE){

            @Override
            protected void onClick() {
                WndWandmaker.this.selectReward(wandmaker, item, Wandmaker.Quest.wand1);
            }
        };
        btnBattle.setRect(0.0f, message.y + message.height() + 2.0f, 120.0f, 18.0f);
        this.add(btnBattle);
        RedButton btnNonBattle = new RedButton(TXT_NON_BATTLE){

            @Override
            protected void onClick() {
                WndWandmaker.this.selectReward(wandmaker, item, Wandmaker.Quest.wand2);
            }
        };
        btnNonBattle.setRect(0.0f, btnBattle.bottom() + 2.0f, 120.0f, 18.0f);
        this.add(btnNonBattle);
        this.resize(120, (int)btnNonBattle.bottom());
    }

    private void selectReward(Wandmaker wandmaker, Item item, Wand reward) {
        this.hide();
        item.detach(Dungeon.hero.belongings.backpack);
        reward.identify();
        if (reward.doPickUp(Dungeon.hero)) {
            GLog.i(Utils.format("You now have %s", reward.name()), new Object[0]);
        } else {
            Dungeon.level.drop((Item)reward, (int)wandmaker.pos).sprite.drop();
        }
        wandmaker.yell(Utils.format(TXT_FARAWELL, Dungeon.hero.className()));
        wandmaker.destroy();
        wandmaker.sprite.die();
        Wandmaker.Quest.complete();
    }
}

