/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Game;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Button;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Window;
import java.util.ArrayList;

public class WndTabbed
extends Window {
    protected ArrayList<Tab> tabs = new ArrayList();
    protected Tab selected;

    public WndTabbed() {
        super(0, 0, Chrome.get(Chrome.Type.TAB_SET));
    }

    protected Tab add(Tab tab) {
        tab.setPos(this.tabs.size() == 0 ? (float)(-this.chrome.marginLeft() + 1) : this.tabs.get(this.tabs.size() - 1).right(), this.height);
        tab.select(false);
        super.add(tab);
        this.tabs.add(tab);
        return tab;
    }

    public void select(int index) {
        this.select(this.tabs.get(index));
    }

    public void select(Tab tab) {
        if (tab != this.selected) {
            for (Tab t : this.tabs) {
                if (t == this.selected) {
                    t.select(false);
                    continue;
                }
                if (t != tab) continue;
                t.select(true);
            }
            this.selected = tab;
        }
    }

    @Override
    public void resize(int w, int h) {
        this.width = w;
        this.height = h;
        this.chrome.size(this.width + this.chrome.marginHor(), this.height + this.chrome.marginVer());
        this.camera.resize((int)this.chrome.width, this.chrome.marginTop() + this.height + this.tabHeight());
        this.camera.x = (int)((float)Game.width - this.camera.screenWidth()) / 2;
        this.camera.y = (int)((float)Game.height - this.camera.screenHeight()) / 2;
        for (Tab tab : this.tabs) {
            this.remove(tab);
        }
        ArrayList<Tab> tabs = new ArrayList<Tab>(this.tabs);
        this.tabs.clear();
        for (Tab tab : tabs) {
            this.add(tab);
        }
    }

    protected int tabHeight() {
        return 25;
    }

    protected void onClick(Tab tab) {
        this.select(tab);
    }

    @Override
    protected void onKeyDown(NoosaInputProcessor.Key key) {
        if (key.code == 61) {
            int next = 0;
            for (int j = 0; j < this.tabs.size(); ++j) {
                Tab t = this.tabs.get(j);
                if (t != this.selected) continue;
                next = (j + 1) % this.tabs.size();
                break;
            }
            this.select(next);
        }
    }

    protected class LabeledTab
    extends Tab {
        private BitmapText btLabel;

        public LabeledTab(String label) {
            this.btLabel.text(label);
            this.btLabel.measure();
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.btLabel = PixelScene.createText(9.0f);
            this.add(this.btLabel);
        }

        @Override
        protected void layout() {
            super.layout();
            this.btLabel.x = PixelScene.align(this.x + (this.width - this.btLabel.width()) / 2.0f);
            this.btLabel.y = PixelScene.align(this.y + (this.height - this.btLabel.baseLine()) / 2.0f) - 1.0f;
            if (!this.selected) {
                this.btLabel.y -= 2.0f;
            }
        }

        @Override
        protected void select(boolean value) {
            super.select(value);
            this.btLabel.am = this.selected ? 1.0f : 0.6f;
        }
    }

    protected class Tab
    extends Button<GameAction> {
        protected final int CUT = 5;
        protected boolean selected;
        protected NinePatch bg;

        protected Tab() {
        }

        @Override
        protected void layout() {
            super.layout();
            if (this.bg != null) {
                this.bg.x = this.x;
                this.bg.y = this.y;
                this.bg.size(this.width, this.height);
            }
        }

        protected void select(boolean value) {
            this.selected = value;
            boolean bl = this.active = !this.selected;
            if (this.bg != null) {
                this.remove(this.bg);
            }
            this.bg = Chrome.get(this.selected ? Chrome.Type.TAB_SELECTED : Chrome.Type.TAB_UNSELECTED);
            this.addToBack(this.bg);
            this.layout();
        }

        @Override
        protected void onClick() {
            Sample.INSTANCE.play("snd_click.mp3", 0.7f, 0.7f, 1.2f);
            WndTabbed.this.onClick(this);
        }
    }
}

