/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Game;
import com.watabou.noosa.TouchArea;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.utils.SparseArray;

public class WndStory
extends Window {
    private static final int WIDTH = 120;
    private static final int MARGIN = 6;
    private static final float bgR = 0.77f;
    private static final float bgG = 0.73f;
    private static final float bgB = 0.62f;
    public static final int ID_SEWERS = 0;
    public static final int ID_PRISON = 1;
    public static final int ID_CAVES = 2;
    public static final int ID_METROPOLIS = 3;
    public static final int ID_HALLS = 4;
    private static final SparseArray<String> CHAPTERS = new SparseArray();
    private BitmapTextMultiline tf;
    private float delay;

    public WndStory(String text) {
        super(0, 0, Chrome.get(Chrome.Type.SCROLL));
        this.tf = PixelScene.createMultiline(text, 7.0f);
        this.tf.maxWidth = 108;
        this.tf.measure();
        this.tf.ra = 0.77f;
        this.tf.ga = 0.73f;
        this.tf.ba = 0.62f;
        this.tf.rm = -0.77f;
        this.tf.gm = -0.73f;
        this.tf.bm = -0.62f;
        this.tf.x = 6.0f;
        this.add(this.tf);
        this.add(new TouchArea(this.chrome){

            @Override
            protected void onClick(NoosaInputProcessor.Touch touch) {
                WndStory.this.hide();
            }
        });
        this.resize((int)(this.tf.width() + 12.0f), (int)Math.min(this.tf.height(), 180.0f));
    }

    @Override
    public void update() {
        super.update();
        if (this.delay > 0.0f) {
            float f;
            this.delay -= Game.elapsed;
            if (f <= 0.0f) {
                this.tf.visible = true;
                this.chrome.visible = true;
            }
        }
    }

    public static void showChapter(int id) {
        if (Dungeon.chapters.contains(id)) {
            return;
        }
        String text = (String)CHAPTERS.get(id);
        if (text != null) {
            WndStory wnd = new WndStory(text);
            wnd.delay = 0.6f;
            if (0.6f > 0.0f) {
                wnd.tf.visible = false;
                wnd.chrome.visible = false;
            }
            Game.scene().add(wnd);
            Dungeon.chapters.add(id);
        }
    }

    static {
        CHAPTERS.put(0, "The Dungeon lies right beneath the City, its upper levels actually constitute the City's sewer system. Being nominally a part of the City, these levels are not that dangerous. No one will call it a safe place, but at least you won't need to deal with evil magic here.");
        CHAPTERS.put(1, "Many years ago an underground prison was built here for the most dangerous criminals. At the time it seemed like a very clever idea, because this place indeed was very hard to escape. But soon dark miasma started to permeate from below, driving prisoners and guards insane. In the end the prison was abandoned, though some convicts were left locked up here.");
        CHAPTERS.put(2, "The caves, which stretch down under the abandoned prison, are sparcely populated. They lie too deep to be exploited by the City and they are too poor in minerals to interest the dwarves. In the past there was a trade outpost somewhere here on the route between these two states, but it has perished since the decline of Dwarven Metropolis. Only omnipresent gnolls and subterranean animals dwell here now.");
        CHAPTERS.put(3, "Dwarven Metropolis was once the greatest of dwarven city-states. In its heyday the mechanized army of dwarves has successfully repelled the invasion of the old god and his demon army. But it is said, that the returning warriors have brought seeds of corruption with them, and that victory was the beginning of the end for the underground kingdom.");
        CHAPTERS.put(4, "In the past these levels were the outskirts of Metropolis. After the costly victory in the war with the old god dwarves were too weakened to clear them of remaining demons. Gradually demons have tightened their grip on this place and now it's called Demon Halls.\n\nVery few adventurers have ever descended this far...");
    }
}

