/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.Ghost;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.quest.DriedRose;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;

public class WndSadGhost
extends Window {
    private static final String TXT_ROSE = "Yes! Yes!!! This is it! Please give it to me! And you can take one of these items, maybe they will be useful to you in your journey...";
    private static final String TXT_RAT = "Yes! The ugly creature is slain and I can finally rest... Please take one of these items, maybe they will be useful to you in your journey...";
    private static final String TXT_WEAPON = "Ghost's weapon";
    private static final String TXT_ARMOR = "Ghost's armor";
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float GAP = 2.0f;

    public WndSadGhost(final Ghost ghost, final Item item) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(item.image(), null));
        titlebar.label(Utils.capitalize(item.name()));
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        BitmapTextMultiline message = PixelScene.createMultiline(item instanceof DriedRose ? TXT_ROSE : TXT_RAT, 6.0f);
        message.maxWidth = 120;
        message.measure();
        message.y = titlebar.bottom() + 2.0f;
        this.add(message);
        RedButton btnWeapon = new RedButton(TXT_WEAPON){

            @Override
            protected void onClick() {
                WndSadGhost.this.selectReward(ghost, item, Ghost.Quest.weapon);
            }
        };
        btnWeapon.setRect(0.0f, message.y + message.height() + 2.0f, 120.0f, 18.0f);
        this.add(btnWeapon);
        RedButton btnArmor = new RedButton(TXT_ARMOR){

            @Override
            protected void onClick() {
                WndSadGhost.this.selectReward(ghost, item, Ghost.Quest.armor);
            }
        };
        btnArmor.setRect(0.0f, btnWeapon.bottom() + 2.0f, 120.0f, 18.0f);
        this.add(btnArmor);
        this.resize(120, (int)btnArmor.bottom());
    }

    private void selectReward(Ghost ghost, Item item, Item reward) {
        this.hide();
        item.detach(Dungeon.hero.belongings.backpack);
        if (reward.doPickUp(Dungeon.hero)) {
            GLog.i(Utils.format("You now have %s", reward.name()), new Object[0]);
        } else {
            Dungeon.level.drop((Item)reward, (int)ghost.pos).sprite.drop();
        }
        ghost.yell("Farewell, adventurer!");
        ghost.die(null);
        Ghost.Quest.complete();
    }
}

