/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Journal;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.ScrollPane;
import com.watabou.pixeldungeon.ui.Window;
import java.util.Collections;

public class WndJournal
extends Window {
    private static final int WIDTH = 112;
    private static final int HEIGHT = 160;
    private static final int ITEM_HEIGHT = 18;
    private static final String TXT_TITLE = "Journal";
    private BitmapText txtTitle;
    private ScrollPane list;

    public WndJournal() {
        this.resize(112, 160);
        this.txtTitle = PixelScene.createText(TXT_TITLE, 9.0f);
        this.txtTitle.hardlight(0xFFFF44);
        this.txtTitle.measure();
        this.txtTitle.x = PixelScene.align(PixelScene.uiCamera, (112.0f - this.txtTitle.width()) / 2.0f);
        this.add(this.txtTitle);
        Component content = new Component();
        Collections.sort(Journal.records);
        float pos = 0.0f;
        for (Journal.Record rec : Journal.records) {
            ListItem item = new ListItem(rec.feature, rec.depth);
            item.setRect(0.0f, pos, 112.0f, 18.0f);
            content.add(item);
            pos += item.height();
        }
        content.setSize(112.0f, pos);
        this.list = new ScrollPane(content);
        this.add(this.list);
        this.list.setRect(0.0f, this.txtTitle.height(), 112.0f, 160.0f - this.txtTitle.height());
    }

    @Override
    protected void onKeyUp(NoosaInputProcessor.Key<GameAction> key) {
        if (key.action == GameAction.JOURNAL) {
            this.hide();
        } else {
            super.onKeyUp(key);
        }
    }

    private static class ListItem
    extends Component {
        private BitmapText feature;
        private BitmapText depth;
        private Image icon;

        public ListItem(Journal.Feature f, int d) {
            this.feature.text(f.desc);
            this.feature.measure();
            this.depth.text(Integer.toString(d));
            this.depth.measure();
            if (d == Dungeon.depth) {
                this.feature.hardlight(0xFFFF44);
                this.depth.hardlight(0xFFFF44);
            }
        }

        @Override
        protected void createChildren() {
            this.feature = PixelScene.createText(9.0f);
            this.add(this.feature);
            this.depth = new BitmapText(PixelScene.font1x);
            this.add(this.depth);
            this.icon = Icons.get(Icons.DEPTH);
            this.add(this.icon);
        }

        @Override
        protected void layout() {
            this.icon.x = this.width - this.icon.width;
            this.depth.x = this.icon.x - 1.0f - this.depth.width();
            this.depth.y = PixelScene.align(this.y + (this.height - this.depth.height()) / 2.0f);
            this.icon.y = this.depth.y - 1.0f;
            this.feature.y = PixelScene.align(this.depth.y + this.depth.baseLine() - this.feature.baseLine());
        }
    }
}

