/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;
import com.watabou.pixeldungeon.windows.WndBag;

public class WndItem
extends Window {
    private static final float BUTTON_WIDTH = 36.0f;
    private static final float BUTTON_HEIGHT = 16.0f;
    private static final float GAP = 2.0f;
    private static final int WIDTH = 120;

    public WndItem(final WndBag owner, final Item item) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(item.image(), item.glowing()));
        titlebar.label(Utils.capitalize(item.toString()));
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        if (item.levelKnown && item.level > 0) {
            titlebar.color(0x44FF44);
        } else if (item.levelKnown && item.level < 0) {
            titlebar.color(0xFF4444);
        }
        BitmapTextMultiline info = PixelScene.createMultiline(item.info(), 6.0f);
        info.maxWidth = 120;
        info.measure();
        info.x = titlebar.left();
        info.y = titlebar.bottom() + 2.0f;
        this.add(info);
        float y = info.y + info.height() + 2.0f;
        float x = 0.0f;
        if (Dungeon.hero.isAlive() && owner != null) {
            for (final String action : item.actions(Dungeon.hero)) {
                RedButton btn = new RedButton(action){

                    @Override
                    protected void onClick() {
                        item.execute(Dungeon.hero, action);
                        WndItem.this.hide();
                        owner.hide();
                    }
                };
                btn.setSize(Math.max(36.0f, btn.reqWidth()), 16.0f);
                if (x + btn.width() > 120.0f) {
                    x = 0.0f;
                    y += 18.0f;
                }
                btn.setPos(x, y);
                this.add(btn);
                x += btn.width() + 2.0f;
            }
        }
        this.resize(120, (int)(y + (x > 0.0f ? 16.0f : 0.0f)));
    }
}

