/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.CharSprite;
import com.watabou.pixeldungeon.ui.BuffIndicator;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndTitledMessage;
import net.whitegem.pixeldungeon.LanguageFactory;

public class WndInfoMob
extends WndTitledMessage {
    public WndInfoMob(Mob mob) {
        super(new MobTitle(mob), WndInfoMob.desc(mob));
    }

    private static String desc(Mob mob) {
        StringBuilder builder = new StringBuilder(LanguageFactory.getTranslation(mob.description()));
        builder.append("\n\n" + LanguageFactory.getTranslation(mob.state.status()) + ".");
        return builder.toString();
    }

    private static class MobTitle
    extends Component {
        private static final int COLOR_BG = -3407872;
        private static final int COLOR_LVL = -16716288;
        private static final int BAR_HEIGHT = 2;
        private static final int GAP = 2;
        private CharSprite image;
        private BitmapText name;
        private ColorBlock hpBg;
        private ColorBlock hpLvl;
        private BuffIndicator buffs;
        private float hp;

        public MobTitle(Mob mob) {
            this.hp = (float)mob.HP / (float)mob.HT;
            this.name = PixelScene.createText(Utils.capitalize(mob.name), 9.0f);
            this.name.hardlight(0xFFFF44);
            this.name.measure();
            this.add(this.name);
            this.image = mob.sprite();
            this.add(this.image);
            this.hpBg = new ColorBlock(1.0f, 1.0f, -3407872);
            this.add(this.hpBg);
            this.hpLvl = new ColorBlock(1.0f, 1.0f, -16716288);
            this.add(this.hpLvl);
            this.buffs = new BuffIndicator(mob);
            this.add(this.buffs);
        }

        @Override
        protected void layout() {
            this.image.x = 0.0f;
            this.image.y = Math.max(0.0f, this.name.height() + 2.0f + 2.0f - this.image.height);
            this.name.x = this.image.width + 2.0f;
            this.name.y = this.image.height - 2.0f - 2.0f - this.name.baseLine();
            float w = this.width - this.image.width - 2.0f;
            this.hpBg.size(w, 2.0f);
            this.hpLvl.size(w * this.hp, 2.0f);
            this.hpBg.x = this.hpLvl.x = this.image.width + 2.0f;
            this.hpBg.y = this.hpLvl.y = this.image.height - 2.0f;
            this.buffs.setPos(this.name.x + this.name.width() + 2.0f, this.name.y + this.name.baseLine() - 7.0f);
            this.height = this.hpBg.y + this.hpBg.height();
        }
    }
}

