/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;

public class WndInfoItem
extends Window {
    private static final String TXT_CHEST = "Chest";
    private static final String TXT_LOCKED_CHEST = "Locked chest";
    private static final String TXT_CRYSTAL_CHEST = "Crystal chest";
    private static final String TXT_TOMB = "Tomb";
    private static final String TXT_SKELETON = "Skeletal remains";
    private static final String TXT_WONT_KNOW = "You won't know what's inside until you open it!";
    private static final String TXT_NEED_KEY = "You won't know what's inside until you open it! But to open it you need a golden key.";
    private static final String TXT_INSIDE = "You can see %s inside, but to open the chest you need a golden key.";
    private static final String TXT_OWNER = "This ancient tomb may contain something useful, but its owner will most certainly object to checking.";
    private static final String TXT_REMAINS = "This is all that's left from one of your predecessors. Maybe it's worth checking for any valuables.";
    private static final float GAP = 2.0f;
    private static final int WIDTH = 120;

    public WndInfoItem(Heap heap) {
        if (heap.type == Heap.Type.HEAP || heap.type == Heap.Type.FOR_SALE) {
            Item item = heap.peek();
            int color = 0xFFFF44;
            if (item.levelKnown && item.level > 0) {
                color = 0x44FF44;
            } else if (item.levelKnown && item.level < 0) {
                color = 0xFF4444;
            }
            this.fillFields(item.image(), item.glowing(), color, item.toString(), item.info());
        } else {
            String info;
            String title;
            if (heap.type == Heap.Type.CHEST) {
                title = TXT_CHEST;
                info = TXT_WONT_KNOW;
            } else if (heap.type == Heap.Type.TOMB) {
                title = TXT_TOMB;
                info = TXT_OWNER;
            } else if (heap.type == Heap.Type.SKELETON) {
                title = TXT_SKELETON;
                info = TXT_REMAINS;
            } else if (heap.type == Heap.Type.CRYSTAL_CHEST) {
                title = TXT_CRYSTAL_CHEST;
                info = Utils.format(TXT_INSIDE, Utils.indefinite(heap.peek().name()));
            } else {
                title = TXT_LOCKED_CHEST;
                info = TXT_NEED_KEY;
            }
            this.fillFields(heap.image(), heap.glowing(), 0xFFFF44, title, info);
        }
    }

    public WndInfoItem(Item item) {
        int color = 0xFFFF44;
        if (item.levelKnown && item.level > 0) {
            color = 0x44FF44;
        } else if (item.levelKnown && item.level < 0) {
            color = 0xFF4444;
        }
        this.fillFields(item.image(), item.glowing(), color, item.toString(), item.info());
    }

    private void fillFields(int image, ItemSprite.Glowing glowing, int titleColor, String title, String info) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(image, glowing));
        titlebar.label(Utils.capitalize(title), titleColor);
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        BitmapTextMultiline txtInfo = PixelScene.createMultiline(info, 6.0f);
        txtInfo.maxWidth = 120;
        txtInfo.measure();
        txtInfo.x = titlebar.left();
        txtInfo.y = titlebar.bottom() + 2.0f;
        this.add(txtInfo);
        this.resize(120, (int)(txtInfo.y + txtInfo.height()));
    }
}

