/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.Imp;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.quest.DwarfToken;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;

public class WndImp
extends Window {
    private static final String TXT_MESSAGE = "Oh yes! You are my hero!\nRegarding your reward, I don't have cash with me right now, but I have something better for you. This is my family heirloom ring: my granddad took it off a dead paladin's finger.";
    private static final String TXT_REWARD = "Take the ring";
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float GAP = 2.0f;

    public WndImp(final Imp imp, final DwarfToken tokens) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(tokens.image(), null));
        titlebar.label(Utils.capitalize(tokens.name()));
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        BitmapTextMultiline message = PixelScene.createMultiline(TXT_MESSAGE, 6.0f);
        message.maxWidth = 120;
        message.measure();
        message.y = titlebar.bottom() + 2.0f;
        this.add(message);
        RedButton btnReward = new RedButton(TXT_REWARD){

            @Override
            protected void onClick() {
                WndImp.this.takeReward(imp, tokens, Imp.Quest.reward);
            }
        };
        btnReward.setRect(0.0f, message.y + message.height() + 2.0f, 120.0f, 18.0f);
        this.add(btnReward);
        this.resize(120, (int)btnReward.bottom());
    }

    private void takeReward(Imp imp, DwarfToken tokens, Item reward) {
        this.hide();
        tokens.detachAll(Dungeon.hero.belongings.backpack);
        reward.identify();
        if (reward.doPickUp(Dungeon.hero)) {
            GLog.i(Utils.format("You now have %s", reward.name()), new Object[0]);
        } else {
            Dungeon.level.drop((Item)reward, (int)imp.pos).sprite.drop();
        }
        imp.flee();
        Imp.Quest.complete();
    }
}

