/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.TextureFilm;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Statistics;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndCatalogus;
import com.watabou.pixeldungeon.windows.WndJournal;
import com.watabou.pixeldungeon.windows.WndTabbed;
import java.util.Locale;

public class WndHero
extends WndTabbed {
    private static final String TXT_STATS = "Stats";
    private static final String TXT_BUFFS = "Buffs";
    private static final String TXT_EXP = "Experience";
    private static final String TXT_STR = "Strength";
    private static final String TXT_HEALTH = "Health";
    private static final String TXT_GOLD = "Gold Collected";
    private static final String TXT_DEPTH = "Maximum Depth";
    private static final int WIDTH = 100;
    private static final int TAB_WIDTH = 40;
    private StatsTab stats;
    private BuffsTab buffs;
    private SmartTexture icons = TextureCache.get("large_buffs.png");
    private TextureFilm film = new TextureFilm(this.icons, 16, 16);

    public WndHero() {
        this.stats = new StatsTab();
        this.add(this.stats);
        this.buffs = new BuffsTab();
        this.add(this.buffs);
        this.add(new WndTabbed.LabeledTab(TXT_STATS){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndHero)WndHero.this).stats.visible = ((WndHero)WndHero.this).stats.active = this.selected;
            }
        });
        this.add(new WndTabbed.LabeledTab(TXT_BUFFS){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndHero)WndHero.this).buffs.visible = ((WndHero)WndHero.this).buffs.active = this.selected;
            }
        });
        for (WndTabbed.Tab tab : this.tabs) {
            tab.setSize(40.0f, this.tabHeight());
        }
        this.resize(100, (int)Math.max(this.stats.height(), this.buffs.height()));
        this.select(0);
    }

    protected void onKeyUp(NoosaInputProcessor.Key key) {
        if (key.action == GameAction.HERO_INFO) {
            this.hide();
        } else {
            super.onKeyUp(key);
        }
    }

    private class BuffsTab
    extends Group {
        private static final int GAP = 2;
        private float pos;

        public BuffsTab() {
            for (Buff buff : Dungeon.hero.buffs()) {
                this.buffSlot(buff);
            }
        }

        private void buffSlot(Buff buff) {
            int index = buff.icon();
            if (index != -1) {
                Image icon = new Image(WndHero.this.icons);
                icon.frame(WndHero.this.film.get(index));
                icon.y = this.pos;
                this.add(icon);
                BitmapText txt = PixelScene.createText(buff.toString(), 8.0f);
                txt.x = icon.width + 2.0f;
                txt.y = this.pos + (float)((int)(icon.height - txt.baseLine()) / 2);
                this.add(txt);
                this.pos += 2.0f + icon.height;
            }
        }

        public float height() {
            return this.pos;
        }
    }

    private class StatsTab
    extends Group {
        private static final String TXT_TITLE = "Level %d %s";
        private static final String TXT_CATALOGUS = "Catalogus";
        private static final String TXT_JOURNAL = "Journal";
        private static final int GAP = 5;
        private float pos;

        public StatsTab() {
            Hero hero = Dungeon.hero;
            BitmapText title = PixelScene.createText(Utils.format(TXT_TITLE, hero.lvl, hero.className()).toUpperCase(Locale.ENGLISH), 9.0f);
            title.hardlight(0xFFFF44);
            title.measure();
            this.add(title);
            RedButton btnCatalogus = new RedButton(TXT_CATALOGUS){

                @Override
                protected void onClick() {
                    WndHero.this.hide();
                    GameScene.show(new WndCatalogus());
                }
            };
            btnCatalogus.hotKey = GameAction.CATALOGUS;
            btnCatalogus.setRect(0.0f, title.y + title.height(), btnCatalogus.reqWidth() + 2.0f, btnCatalogus.reqHeight() + 2.0f);
            this.add(btnCatalogus);
            RedButton btnJournal = new RedButton(TXT_JOURNAL){

                @Override
                protected void onClick() {
                    WndHero.this.hide();
                    GameScene.show(new WndJournal());
                }
            };
            btnJournal.hotKey = GameAction.JOURNAL;
            btnJournal.setRect(btnCatalogus.right() + 1.0f, btnCatalogus.top(), btnJournal.reqWidth() + 2.0f, btnJournal.reqHeight() + 2.0f);
            this.add(btnJournal);
            this.pos = btnCatalogus.bottom() + 5.0f;
            this.statSlot(WndHero.TXT_STR, hero.STR());
            this.statSlot(WndHero.TXT_HEALTH, hero.HP + "/" + hero.HT);
            this.statSlot(WndHero.TXT_EXP, hero.exp + "/" + hero.maxExp());
            this.pos += 5.0f;
            this.statSlot(WndHero.TXT_GOLD, Statistics.goldCollected);
            this.statSlot(WndHero.TXT_DEPTH, Statistics.deepestFloor);
            this.pos += 5.0f;
        }

        private void statSlot(String label, String value) {
            BitmapText txt = PixelScene.createText(label, 8.0f);
            txt.y = this.pos;
            this.add(txt);
            txt = PixelScene.createText(value, 8.0f);
            txt.measure();
            txt.x = PixelScene.align(65.0f);
            txt.y = this.pos;
            this.add(txt);
            this.pos += 5.0f + txt.baseLine();
        }

        private void statSlot(String label, int value) {
            this.statSlot(label, Integer.toString(value));
        }

        public float height() {
            return this.pos;
        }
    }
}

