/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Group;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.actors.hero.HeroSubClass;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndTabbed;
import net.whitegem.pixeldungeon.LanguageFactory;

public class WndClass
extends WndTabbed {
    private static final String TXT_MASTERY = "Mastery";
    private static final int WIDTH = 110;
    private static final int TAB_WIDTH = 50;
    private HeroClass cl;
    private PerksTab tabPerks;
    private MasteryTab tabMastery;

    public WndClass(HeroClass cl) {
        this.cl = cl;
        this.tabPerks = new PerksTab();
        this.add(this.tabPerks);
        RankingTab tab = new RankingTab(Utils.capitalize(cl.title()), this.tabPerks);
        tab.setSize(50.0f, this.tabHeight());
        this.add(tab);
        if (Badges.isUnlocked(cl.masteryBadge())) {
            this.tabMastery = new MasteryTab();
            this.add(this.tabMastery);
            tab = new RankingTab(TXT_MASTERY, this.tabMastery);
            tab.setSize(50.0f, this.tabHeight());
            this.add(tab);
            this.resize((int)Math.max(this.tabPerks.width, this.tabMastery.width), (int)Math.max(this.tabPerks.height, this.tabMastery.height));
        } else {
            this.resize((int)this.tabPerks.width, (int)this.tabPerks.height);
        }
        this.select(0);
    }

    private class MasteryTab
    extends Group {
        private static final int MARGIN = 4;
        private BitmapTextMultiline normal;
        private BitmapTextMultiline highlighted;
        public float height;
        public float width;

        public MasteryTab() {
            String text = null;
            switch (WndClass.this.cl) {
                case WARRIOR: {
                    text = LanguageFactory.getTranslation(HeroSubClass.GLADIATOR.desc()) + "\n\n" + LanguageFactory.getTranslation(HeroSubClass.BERSERKER.desc());
                    break;
                }
                case MAGE: {
                    text = LanguageFactory.getTranslation(HeroSubClass.BATTLEMAGE.desc()) + "\n\n" + LanguageFactory.getTranslation(HeroSubClass.WARLOCK.desc());
                    break;
                }
                case ROGUE: {
                    text = LanguageFactory.getTranslation(HeroSubClass.FREERUNNER.desc()) + "\n\n" + LanguageFactory.getTranslation(HeroSubClass.ASSASSIN.desc());
                    break;
                }
                case HUNTRESS: {
                    text = LanguageFactory.getTranslation(HeroSubClass.SNIPER.desc()) + "\n\n" + LanguageFactory.getTranslation(HeroSubClass.WARDEN.desc());
                }
            }
            Window.Highlighter hl = new Window.Highlighter(text);
            this.normal = PixelScene.createMultiline(hl.text, 6.0f);
            this.normal.maxWidth = 102;
            this.normal.measure();
            this.normal.x = 4.0f;
            this.normal.y = 4.0f;
            this.add(this.normal);
            if (hl.isHighlighted()) {
                this.normal.mask = hl.inverted();
                this.highlighted = PixelScene.createMultiline(hl.text, 6.0f);
                this.highlighted.maxWidth = this.normal.maxWidth;
                this.highlighted.measure();
                this.highlighted.x = this.normal.x;
                this.highlighted.y = this.normal.y;
                this.add(this.highlighted);
                this.highlighted.mask = hl.mask;
                this.highlighted.hardlight(0xFFFF44);
            }
            this.height = this.normal.y + this.normal.height() + 4.0f;
            this.width = this.normal.x + this.normal.width() + 4.0f;
        }
    }

    private class PerksTab
    extends Group {
        private static final int MARGIN = 4;
        private static final int GAP = 4;
        private static final String DOT = "\u007f";
        public float height;
        public float width;

        public PerksTab() {
            float dotWidth = 0.0f;
            String[] items = WndClass.this.cl.perks();
            float pos = 4.0f;
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    pos += 4.0f;
                }
                BitmapText dot = PixelScene.createText(DOT, 6.0f);
                dot.x = 4.0f;
                dot.y = pos;
                if (dotWidth == 0.0f) {
                    dot.measure();
                    dotWidth = dot.width();
                }
                this.add(dot);
                BitmapTextMultiline item = PixelScene.createMultiline(items[i], 6.0f);
                item.x = dot.x + dotWidth;
                item.y = pos;
                item.maxWidth = (int)(102.0f - dotWidth);
                item.measure();
                this.add(item);
                pos += item.height();
                float w = item.width();
                if (!(w > this.width)) continue;
                this.width = w;
            }
            this.width += 4.0f + dotWidth;
            this.height = pos + 4.0f;
        }
    }

    private class RankingTab
    extends WndTabbed.LabeledTab {
        private Group page;

        public RankingTab(String label, Group page) {
            super(WndClass.this, label);
            this.page = page;
        }

        @Override
        protected void select(boolean value) {
            super.select(value);
            if (this.page != null) {
                this.page.visible = this.page.active = this.selected;
            }
        }
    }
}

