/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.pixeldungeon.actors.hero.HeroSubClass;
import com.watabou.pixeldungeon.items.TomeOfMastery;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.RedButton;
import com.watabou.pixeldungeon.ui.Window;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.IconTitle;
import net.whitegem.pixeldungeon.LanguageFactory;

public class WndChooseWay
extends Window {
    private static final String TXT_MESSAGE = "Which way will you follow?";
    private static final String TXT_CANCEL = "I'll decide later";
    private static final int WIDTH = 120;
    private static final int BTN_HEIGHT = 18;
    private static final float GAP = 2.0f;

    public WndChooseWay(final TomeOfMastery tome, final HeroSubClass way1, final HeroSubClass way2) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(new ItemSprite(tome.image(), null));
        titlebar.label(tome.name());
        titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add(titlebar);
        Window.Highlighter hl = new Window.Highlighter(LanguageFactory.getTranslation(way1.desc()) + "\n\n" + LanguageFactory.getTranslation(way2.desc()) + "\n\n" + LanguageFactory.getTranslation(TXT_MESSAGE));
        BitmapTextMultiline normal = PixelScene.createMultiline(hl.text, 6.0f);
        normal.maxWidth = 120;
        normal.measure();
        normal.x = titlebar.left();
        normal.y = titlebar.bottom() + 2.0f;
        this.add(normal);
        if (hl.isHighlighted()) {
            normal.mask = hl.inverted();
            BitmapTextMultiline highlighted = PixelScene.createMultiline(hl.text, 6.0f);
            highlighted.maxWidth = normal.maxWidth;
            highlighted.measure();
            highlighted.x = normal.x;
            highlighted.y = normal.y;
            this.add(highlighted);
            highlighted.mask = hl.mask;
            highlighted.hardlight(0xFFFF44);
        }
        RedButton btnWay1 = new RedButton(Utils.capitalize(way1.title())){

            @Override
            protected void onClick() {
                WndChooseWay.this.hide();
                tome.choose(way1);
            }
        };
        btnWay1.setRect(0.0f, normal.y + normal.height() + 2.0f, 59.0f, 18.0f);
        this.add(btnWay1);
        RedButton btnWay2 = new RedButton(Utils.capitalize(way2.title())){

            @Override
            protected void onClick() {
                WndChooseWay.this.hide();
                tome.choose(way2);
            }
        };
        btnWay2.setRect(btnWay1.right() + 2.0f, btnWay1.top(), btnWay1.width(), 18.0f);
        this.add(btnWay2);
        RedButton btnCancel = new RedButton(TXT_CANCEL){

            @Override
            protected void onClick() {
                WndChooseWay.this.hide();
            }
        };
        btnCancel.setRect(0.0f, btnWay2.bottom() + 2.0f, 120.0f, 18.0f);
        this.add(btnCancel);
        this.resize(120, (int)btnCancel.bottom());
    }
}

