/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.gltextures.TextureCache;
import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.hero.Belongings;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.items.bags.Bag;
import com.watabou.pixeldungeon.items.bags.ScrollHolder;
import com.watabou.pixeldungeon.items.bags.SeedPouch;
import com.watabou.pixeldungeon.items.bags.WandHolster;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.items.weapon.melee.MeleeWeapon;
import com.watabou.pixeldungeon.items.weapon.missiles.Boomerang;
import com.watabou.pixeldungeon.plants.Plant;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.ItemSlot;
import com.watabou.pixeldungeon.ui.QuickSlot;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndItem;
import com.watabou.pixeldungeon.windows.WndTabbed;
import com.watabou.utils.RectF;

public class WndBag
extends WndTabbed {
    protected static final int COLS = 4;
    protected static final int SLOT_SIZE = 28;
    protected static final int SLOT_MARGIN = 1;
    protected static final int TAB_WIDTH = 30;
    protected static final int TITLE_HEIGHT = 12;
    protected static final int ROWS = 6;
    private Listener listener;
    private Mode mode;
    private String title;
    protected int count;
    protected int col;
    protected int row;
    private static Mode lastMode;
    private static Bag lastBag;

    public WndBag(Bag bag, Listener listener, Mode mode, String title) {
        Bag[] bags;
        this.listener = listener;
        this.mode = mode;
        this.title = title;
        lastMode = mode;
        lastBag = bag;
        BitmapText txtTitle = PixelScene.createText(title != null ? title : Utils.capitalize(bag.name()), 9.0f);
        txtTitle.hardlight(0xFFFF44);
        txtTitle.measure();
        txtTitle.x = (int)(115.0f - txtTitle.width()) / 2;
        txtTitle.y = (int)(12.0f - txtTitle.height()) / 2;
        this.add(txtTitle);
        this.placeItems(bag);
        this.resize(115, 185);
        Belongings stuff = Dungeon.hero.belongings;
        for (Bag b : bags = new Bag[]{stuff.backpack, stuff.getItem(SeedPouch.class), stuff.getItem(ScrollHolder.class), stuff.getItem(WandHolster.class)}) {
            if (b == null) continue;
            BagTab tab = new BagTab(b);
            tab.setSize(30.0f, this.tabHeight());
            this.add(tab);
            tab.select(b == bag);
        }
    }

    @Override
    protected void onKeyUp(NoosaInputProcessor.Key<GameAction> key) {
        if (key.action == GameAction.BACKPACK) {
            this.hide();
        } else {
            super.onKeyUp(key);
        }
    }

    public static WndBag lastBag(Listener listener, Mode mode, String title) {
        if (mode == lastMode && lastBag != null && Dungeon.hero.belongings.backpack.contains(lastBag)) {
            return new WndBag(lastBag, listener, mode, title);
        }
        return new WndBag(Dungeon.hero.belongings.backpack, listener, mode, title);
    }

    public static WndBag seedPouch(Listener listener, Mode mode, String title) {
        SeedPouch pouch = Dungeon.hero.belongings.getItem(SeedPouch.class);
        return pouch != null ? new WndBag(pouch, listener, mode, title) : new WndBag(Dungeon.hero.belongings.backpack, listener, mode, title);
    }

    protected void placeItems(Bag container) {
        Belongings stuff = Dungeon.hero.belongings;
        this.placeItem(stuff.weapon != null ? stuff.weapon : new Placeholder(5));
        this.placeItem(stuff.armor != null ? stuff.armor : new Placeholder(6));
        this.placeItem(stuff.ring1 != null ? stuff.ring1 : new Placeholder(7));
        this.placeItem(stuff.ring2 != null ? stuff.ring2 : new Placeholder(7));
        for (Item item : container.items) {
            this.placeItem(item);
        }
        while (this.count - 4 < container.size) {
            this.placeItem(null);
        }
        if (container == Dungeon.hero.belongings.backpack) {
            this.row = 5;
            this.col = 3;
            this.placeItem(new Gold(Dungeon.gold));
        }
    }

    protected void placeItem(Item item) {
        int x = this.col * 29;
        int y = 12 + this.row * 29;
        this.add(new ItemButton(item).setPos(x, y));
        if (++this.col >= 4) {
            this.col = 0;
            ++this.row;
        }
        ++this.count;
    }

    @Override
    public void onMenuPressed() {
        if (this.listener == null) {
            this.hide();
        }
    }

    @Override
    public void onBackPressed() {
        if (this.listener != null) {
            this.listener.onSelect(null);
        }
        super.onBackPressed();
    }

    @Override
    protected void onClick(WndTabbed.Tab tab) {
        this.hide();
        GameScene.show(new WndBag(((BagTab)tab).bag, this.listener, this.mode, this.title));
    }

    @Override
    protected int tabHeight() {
        return 20;
    }

    public static interface Listener {
        public void onSelect(Item var1);
    }

    private class ItemButton
    extends ItemSlot {
        private static final int NORMAL = -11907772;
        private static final int EQUIPPED = -10262949;
        private Item item;
        private ColorBlock bg;

        public ItemButton(Item item) {
            super(item);
            this.item = item;
            if (item instanceof Gold) {
                this.bg.visible = false;
            }
            this.height = 28.0f;
            this.width = 28.0f;
        }

        @Override
        protected void createChildren() {
            this.bg = new ColorBlock(28.0f, 28.0f, -11907772);
            this.add(this.bg);
            super.createChildren();
        }

        @Override
        protected void layout() {
            this.bg.x = this.x;
            this.bg.y = this.y;
            super.layout();
        }

        @Override
        public void item(Item item) {
            super.item(item);
            if (item != null) {
                this.bg.texture(TextureCache.createSolid(item.isEquipped(Dungeon.hero) ? -10262949 : -11907772));
                if (item.cursed && item.cursedKnown) {
                    this.bg.ra = 0.2f;
                    this.bg.ga = -0.1f;
                } else if (!item.isIdentified()) {
                    this.bg.ra = 0.1f;
                    this.bg.ba = 0.1f;
                }
                if (item.name() == null) {
                    this.enable(false);
                } else {
                    this.enable(WndBag.this.mode == Mode.FOR_SALE && item.price() > 0 && (!item.isEquipped(Dungeon.hero) || !item.cursed) || WndBag.this.mode == Mode.UPGRADEABLE && item.isUpgradable() || WndBag.this.mode == Mode.UNIDENTIFED && !item.isIdentified() || WndBag.this.mode == Mode.QUICKSLOT && item.defaultAction != null || WndBag.this.mode == Mode.WEAPON && (item instanceof MeleeWeapon || item instanceof Boomerang) || WndBag.this.mode == Mode.ARMOR && item instanceof Armor || WndBag.this.mode == Mode.WAND && item instanceof Wand || WndBag.this.mode == Mode.SEED && item instanceof Plant.Seed || WndBag.this.mode == Mode.ALL);
                }
            } else {
                this.bg.color(-11907772);
            }
        }

        @Override
        protected void onTouchDown() {
            this.bg.brightness(1.5f);
            Sample.INSTANCE.play("snd_click.mp3", 0.7f, 0.7f, 1.2f);
        }

        @Override
        protected void onTouchUp() {
            this.bg.brightness(1.0f);
        }

        @Override
        protected void onClick() {
            if (WndBag.this.listener != null) {
                WndBag.this.hide();
                WndBag.this.listener.onSelect(this.item);
            } else if (NoosaInputProcessor.modifier) {
                this.onLongClick();
            } else {
                WndBag.this.add(new WndItem(WndBag.this, this.item));
            }
        }

        @Override
        protected boolean onLongClick() {
            if (WndBag.this.listener == null && this.item.defaultAction != null) {
                WndBag.this.hide();
                Dungeon.quickslot = this.item.stackable ? this.item.getClass() : this.item;
                QuickSlot.refresh();
                return true;
            }
            return false;
        }
    }

    private static class Placeholder
    extends Item {
        public Placeholder(int image) {
            this.name = null;
            this.image = image;
        }

        @Override
        public boolean isIdentified() {
            return true;
        }

        @Override
        public boolean isEquipped(Hero hero) {
            return true;
        }
    }

    private class BagTab
    extends WndTabbed.Tab {
        private Image icon;
        private Bag bag;

        public BagTab(Bag bag) {
            super(WndBag.this);
            this.bag = bag;
            this.icon = this.icon();
            this.add(this.icon);
        }

        @Override
        protected void select(boolean value) {
            super.select(value);
            this.icon.am = this.selected ? 1.0f : 0.6f;
        }

        @Override
        protected void layout() {
            super.layout();
            this.icon.copy(this.icon());
            this.icon.x = this.x + (this.width - this.icon.width) / 2.0f;
            this.icon.y = this.y + (this.height - this.icon.height) / 2.0f - 2.0f - (float)(!this.selected ? 1 : 0);
            if (!this.selected && this.icon.y < this.y + 5.0f) {
                RectF frame = this.icon.frame();
                this.icon.frame(new RectF(frame.left, frame.top + (this.y + 5.0f - this.icon.y) / (float)this.icon.texture.height, frame.right, frame.bottom));
                this.icon.y = this.y + 5.0f;
            }
        }

        private Image icon() {
            if (this.bag instanceof SeedPouch) {
                return Icons.get(Icons.SEED_POUCH);
            }
            if (this.bag instanceof ScrollHolder) {
                return Icons.get(Icons.SCROLL_HOLDER);
            }
            if (this.bag instanceof WandHolster) {
                return Icons.get(Icons.WAND_HOLSTER);
            }
            return Icons.get(Icons.BACKPACK);
        }
    }

    public static enum Mode {
        ALL,
        UNIDENTIFED,
        UPGRADEABLE,
        QUICKSLOT,
        FOR_SALE,
        WEAPON,
        ARMOR,
        WAND,
        SEED;

    }
}

