/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Image;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.effects.BadgeBanner;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Window;

public class WndBadge
extends Window {
    private static final int WIDTH = 120;
    private static final int MARGIN = 4;

    public WndBadge(Badges.Badge badge) {
        Image icon = BadgeBanner.image(badge.image);
        icon.scale.set(2.0f);
        this.add(icon);
        BitmapTextMultiline info = PixelScene.createMultiline(badge.description, 8.0f);
        info.maxWidth = 112;
        info.measure();
        float w = Math.max(icon.width(), info.width()) + 8.0f;
        icon.x = (w - icon.width()) / 2.0f;
        icon.y = 4.0f;
        float pos = icon.y + icon.height() + 4.0f;
        for (BitmapText line : new BitmapTextMultiline.LineSplitter(info).split()) {
            line.measure();
            line.x = PixelScene.align((w - line.width()) / 2.0f);
            line.y = PixelScene.align(pos);
            this.add(line);
            pos += line.height();
        }
        this.resize((int)w, (int)(pos + 4.0f));
        BadgeBanner.highlight(icon, badge.image);
    }
}

