/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.windows;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.utils.Utils;

public class IconTitle
extends Component {
    private static final float FONT_SIZE = 9.0f;
    private static final float GAP = 2.0f;
    protected Image imIcon;
    protected BitmapTextMultiline tfLabel;

    public IconTitle() {
    }

    public IconTitle(Item item) {
        this(new ItemSprite(item.image(), item.glowing()), Utils.capitalize(item.toString()));
    }

    public IconTitle(Image icon, String label) {
        this.icon(icon);
        this.label(label);
    }

    @Override
    protected void createChildren() {
        this.imIcon = new Image();
        this.add(this.imIcon);
        this.tfLabel = PixelScene.createMultiline(9.0f);
        this.tfLabel.hardlight(0xFFFF44);
        this.add(this.tfLabel);
    }

    @Override
    protected void layout() {
        this.imIcon.x = 0.0f;
        this.imIcon.y = 0.0f;
        this.tfLabel.x = PixelScene.align(PixelScene.uiCamera, this.imIcon.x + this.imIcon.width() + 2.0f);
        this.tfLabel.maxWidth = (int)(this.width - this.tfLabel.x);
        this.tfLabel.measure();
        this.tfLabel.y = PixelScene.align(PixelScene.uiCamera, this.imIcon.height > this.tfLabel.height() ? (this.imIcon.height() - this.tfLabel.baseLine()) / 2.0f : this.imIcon.y);
        this.height = Math.max(this.imIcon.y + this.imIcon.height(), this.tfLabel.y + this.tfLabel.height());
    }

    public void icon(Image icon) {
        this.remove(this.imIcon);
        this.imIcon = icon;
        this.add(this.imIcon);
    }

    public void label(String label) {
        this.tfLabel.text(label);
    }

    public void label(String label, int color) {
        this.tfLabel.text(label);
        this.tfLabel.hardlight(color);
    }

    public void color(int color) {
        this.tfLabel.hardlight(color);
    }
}

