/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.TouchArea;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.utils.Signal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Window
extends Group
implements Signal.Listener<NoosaInputProcessor.Key<GameAction>> {
    protected int width;
    protected int height;
    protected TouchArea blocker;
    protected NinePatch chrome;
    public static final int TITLE_COLOR = 0xFFFF44;

    public Window() {
        this(0, 0, Chrome.get(Chrome.Type.WINDOW));
    }

    public Window(int width, int height) {
        this(width, height, Chrome.get(Chrome.Type.WINDOW));
    }

    public Window(int width, int height, NinePatch chrome) {
        this.blocker = new TouchArea(0.0f, 0.0f, PixelScene.uiCamera.width, PixelScene.uiCamera.height){

            @Override
            protected void onClick(NoosaInputProcessor.Touch touch) {
                if (!Window.this.chrome.overlapsScreenPoint((int)touch.current.x, (int)touch.current.y)) {
                    Window.this.onBackPressed();
                }
            }
        };
        this.blocker.camera = PixelScene.uiCamera;
        this.add(this.blocker);
        this.chrome = chrome;
        this.width = width;
        this.height = height;
        chrome.x = -chrome.marginLeft();
        chrome.y = -chrome.marginTop();
        chrome.size((float)width - chrome.x + (float)chrome.marginRight(), (float)height - chrome.y + (float)chrome.marginBottom());
        this.add(chrome);
        this.camera = new Camera(0, 0, (int)chrome.width, (int)chrome.height, PixelScene.defaultZoom);
        this.camera.x = (int)((float)Game.width - (float)this.camera.width * this.camera.zoom) / 2;
        this.camera.y = (int)((float)Game.height - (float)this.camera.height * this.camera.zoom) / 2;
        this.camera.scroll.set(chrome.x, chrome.y);
        Camera.add(this.camera);
        Game.instance.getInputProcessor().addKeyListener(this);
    }

    public void resize(int w, int h) {
        this.width = w;
        this.height = h;
        this.chrome.size(this.width + this.chrome.marginHor(), this.height + this.chrome.marginVer());
        this.camera.resize((int)this.chrome.width, (int)this.chrome.height);
        this.camera.x = (int)((float)Game.width - this.camera.screenWidth()) / 2;
        this.camera.y = (int)((float)Game.height - this.camera.screenHeight()) / 2;
    }

    public void hide() {
        this.parent.erase(this);
        this.destroy();
    }

    @Override
    public void destroy() {
        super.destroy();
        Camera.remove(this.camera);
        Game.instance.getInputProcessor().removeKeyListener(this);
    }

    @Override
    public void onSignal(NoosaInputProcessor.Key<GameAction> key) {
        if (key.pressed) {
            switch (key.code) {
                case 4: 
                case 131: {
                    this.onBackPressed();
                    break;
                }
                case 82: {
                    this.onMenuPressed();
                    break;
                }
                default: {
                    this.onKeyDown(key);
                    break;
                }
            }
        } else {
            this.onKeyUp(key);
        }
        Game.instance.getInputProcessor().cancelKeyEvent();
    }

    protected void onKeyDown(NoosaInputProcessor.Key key) {
    }

    protected void onKeyUp(NoosaInputProcessor.Key<GameAction> key) {
    }

    public void onBackPressed() {
        this.hide();
    }

    public void onMenuPressed() {
    }

    protected static class Highlighter {
        private static final Pattern HIGHLIGHTER = Pattern.compile("_(.*?)_");
        private static final Pattern STRIPPER = Pattern.compile("[ \n]");
        public String text;
        public boolean[] mask;

        public Highlighter(String text) {
            String stripped = STRIPPER.matcher(text).replaceAll("");
            this.mask = new boolean[stripped.length()];
            Matcher m = HIGHLIGHTER.matcher(stripped);
            int pos = 0;
            int lastMatch = 0;
            while (m.find()) {
                int groupLen = m.group(1).length();
                for (int i = pos += m.start() - lastMatch; i < pos + groupLen; ++i) {
                    this.mask[i] = true;
                }
                pos += groupLen;
                lastMatch = m.end();
            }
            m.reset(text);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, m.group(1));
            }
            m.appendTail(sb);
            this.text = sb.toString();
        }

        public boolean[] inverted() {
            boolean[] result = new boolean[this.mask.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = !this.mask[i];
            }
            return result;
        }

        public boolean isHighlighted() {
            for (int i = 0; i < this.mask.length; ++i) {
                if (!this.mask[i]) continue;
                return true;
            }
            return false;
        }
    }
}

