/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Button;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.CellSelector;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.ui.GoldIndicator;
import com.watabou.pixeldungeon.ui.QuickSlot;
import com.watabou.pixeldungeon.windows.WndBag;
import com.watabou.pixeldungeon.windows.WndCatalogus;

public class Toolbar
extends Component {
    private Tool btnWait;
    private Tool btnSearch;
    private Tool btnInfo;
    private Tool btnResume;
    private Tool btnInventory;
    private Tool btnQuick;
    private PickedUpItem pickedUp;
    private boolean lastEnabled = true;
    private static CellSelector.Listener informer = new CellSelector.Listener(){

        @Override
        public void onSelect(Integer cell) {
            GameScene.examineCell(cell);
        }

        @Override
        public String prompt() {
            return "Select a cell to examine";
        }
    };

    public Toolbar() {
        this.height = this.btnInventory.height();
    }

    @Override
    protected void createChildren() {
        this.btnWait = new Tool(0, 7, 20, 24, GameAction.REST){

            @Override
            protected void onClick() {
                this.restOneTurn();
            }

            @Override
            protected boolean onLongClick() {
                this.restFull();
                return true;
            }

            private void restOneTurn() {
                Dungeon.hero.rest(false);
            }

            private void restFull() {
                Dungeon.hero.rest(true);
            }
        };
        this.add(this.btnWait);
        this.btnSearch = new Tool(20, 7, 20, 24, GameAction.SEARCH){

            @Override
            protected void onClick() {
                this.doSearch();
            }

            private void doSearch() {
                Dungeon.hero.search(true);
            }
        };
        this.add(this.btnSearch);
        this.btnInfo = new Tool(40, 7, 21, 24, GameAction.CELL_INFO){

            @Override
            protected void onClick() {
                this.getCellInfo();
            }

            private void getCellInfo() {
                GameScene.selectCell(informer);
            }
        };
        this.add(this.btnInfo);
        this.btnResume = new Tool(61, 7, 21, 24, GameAction.RESUME){

            @Override
            protected void onClick() {
                this.resume();
            }

            private void resume() {
                Dungeon.hero.resume();
            }
        };
        this.add(this.btnResume);
        this.btnInventory = new Tool(82, 7, 23, 24, GameAction.BACKPACK){
            private GoldIndicator gold;

            @Override
            protected void onClick() {
                this.showBackpack();
            }

            @Override
            protected boolean onLongClick() {
                this.showCatalogus();
                return true;
            }

            private void showBackpack() {
                GameScene.show(new WndBag(Dungeon.hero.belongings.backpack, null, WndBag.Mode.ALL, null));
            }

            private void showCatalogus() {
                GameScene.show(new WndCatalogus());
            }

            @Override
            protected void createChildren() {
                super.createChildren();
                this.gold = new GoldIndicator();
                this.add(this.gold);
            }

            @Override
            protected void layout() {
                super.layout();
                this.gold.fill(this);
            }
        };
        this.add(this.btnInventory);
        this.btnQuick = new QuickslotTool(105, 7, 22, 24);
        this.add(this.btnQuick);
        this.pickedUp = new PickedUpItem();
        this.add(this.pickedUp);
    }

    @Override
    protected void layout() {
        this.btnWait.setPos(this.x, this.y);
        this.btnSearch.setPos(this.btnWait.right(), this.y);
        this.btnInfo.setPos(this.btnSearch.right(), this.y);
        this.btnResume.setPos(this.btnInfo.right(), this.y);
        this.btnQuick.setPos(this.width - this.btnQuick.width(), this.y);
        this.btnInventory.setPos(this.btnQuick.left() - this.btnInventory.width(), this.y);
    }

    @Override
    public void update() {
        super.update();
        if (this.lastEnabled != Dungeon.hero.ready) {
            this.lastEnabled = Dungeon.hero.ready;
            for (Gizmo tool : this.members) {
                if (!(tool instanceof Tool)) continue;
                ((Tool)tool).enable(this.lastEnabled);
            }
        }
        boolean bl = this.btnResume.visible = Dungeon.hero.lastAction != null;
        if (!Dungeon.hero.isAlive()) {
            this.btnInventory.enable(true);
        }
    }

    public void pickup(Item item) {
        this.pickedUp.reset(item, this.btnInventory.centerX(), this.btnInventory.centerY());
    }

    private static class PickedUpItem
    extends ItemSprite {
        private static final float DISTANCE = 16.0f;
        private static final float DURATION = 0.2f;
        private float dstX;
        private float dstY;
        private float left;

        public PickedUpItem() {
            this.originToCenter();
            this.visible = false;
            this.active = false;
        }

        public void reset(Item item, float dstX, float dstY) {
            this.view(item.image(), item.glowing());
            this.visible = true;
            this.active = true;
            this.dstX = dstX - 8.0f;
            this.dstY = dstY - 8.0f;
            this.left = 0.2f;
            this.x = this.dstX - 16.0f;
            this.y = this.dstY - 16.0f;
            this.alpha(1.0f);
        }

        @Override
        public void update() {
            float f;
            super.update();
            this.left -= Game.elapsed;
            if (f <= 0.0f) {
                this.active = false;
                this.visible = false;
            } else {
                float p = this.left / 0.2f;
                this.scale.set((float)Math.sqrt(p));
                float offset = 16.0f * p;
                this.x = this.dstX - offset;
                this.y = this.dstY - offset;
            }
        }
    }

    private static class QuickslotTool
    extends Tool {
        private QuickSlot slot;

        public QuickslotTool(int x, int y, int width, int height) {
            super(x, y, width, height, null);
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.slot = new QuickSlot();
            this.add(this.slot);
        }

        @Override
        protected void layout() {
            super.layout();
            this.slot.setRect(this.x + 1.0f, this.y + 2.0f, this.width - 2.0f, this.height - 2.0f);
        }

        @Override
        public void enable(boolean value) {
            this.slot.enable(value);
            this.active = value;
        }
    }

    private static class Tool
    extends Button<GameAction> {
        private static final int BGCOLOR = 8093811;
        private Image base;

        public Tool(int x, int y, int width, int height, GameAction hotKey) {
            this.base.frame(x, y, width, height);
            this.width = width;
            this.height = height;
            this.hotKey = hotKey;
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.base = new Image("toolbar.png");
            this.add(this.base);
        }

        @Override
        protected void layout() {
            super.layout();
            this.base.x = this.x;
            this.base.y = this.y;
        }

        @Override
        protected void onTouchDown() {
            this.base.brightness(1.4f);
        }

        @Override
        protected void onTouchUp() {
            if (this.active) {
                this.base.resetColor();
            } else {
                this.base.tint(8093811, 0.7f);
            }
        }

        public void enable(boolean value) {
            if (value != this.active) {
                if (value) {
                    this.base.resetColor();
                } else {
                    this.base.tint(8093811, 0.7f);
                }
                this.active = value;
            }
        }
    }
}

