/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.SimpleButton;

public class Toast
extends Component {
    private static final float MARGIN_HOR = 2.0f;
    private static final float MARGIN_VER = 2.0f;
    protected NinePatch bg;
    protected SimpleButton close;
    protected BitmapText text;

    public Toast(String text) {
        this.text(text);
        this.width = this.text.width() + this.close.width() + (float)this.bg.marginHor() + 6.0f;
        this.height = Math.max(this.text.height(), this.close.height()) + (float)this.bg.marginVer() + 4.0f;
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.bg = Chrome.get(Chrome.Type.TOAST_TR);
        this.add(this.bg);
        this.close = new SimpleButton(Icons.get(Icons.CLOSE)){

            @Override
            protected void onClick() {
                Toast.this.onClose();
            }
        };
        this.add(this.close);
        this.text = PixelScene.createText(8.0f);
        this.add(this.text);
    }

    @Override
    protected void layout() {
        super.layout();
        this.bg.x = this.x;
        this.bg.y = this.y;
        this.bg.size(this.width, this.height);
        this.close.setPos(this.bg.x + this.bg.width() - (float)(this.bg.marginHor() / 2) - 2.0f - this.close.width(), this.y + (this.height - this.close.height()) / 2.0f);
        this.text.x = this.close.left() - 2.0f - this.text.width();
        this.text.y = this.y + (this.height - this.text.height()) / 2.0f;
        PixelScene.align(this.text);
    }

    public void text(String txt) {
        this.text.text(txt);
        this.text.measure();
    }

    protected void onClose() {
    }
}

