/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.TouchArea;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.ui.Button;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.effects.particles.BloodParticle;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.items.keys.IronKey;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.CharSprite;
import com.watabou.pixeldungeon.sprites.HeroSprite;
import com.watabou.pixeldungeon.ui.BuffIndicator;
import com.watabou.pixeldungeon.ui.Compass;
import com.watabou.pixeldungeon.ui.DangerIndicator;
import com.watabou.pixeldungeon.ui.LootIndicator;
import com.watabou.pixeldungeon.windows.WndCatalogus;
import com.watabou.pixeldungeon.windows.WndGame;
import com.watabou.pixeldungeon.windows.WndHero;
import com.watabou.pixeldungeon.windows.WndJournal;
import com.watabou.pixeldungeon.windows.WndSettings;

public class StatusPane
extends Component {
    private NinePatch shield;
    private Image avatar;
    private Emitter blood;
    private int lastTier = 0;
    private Image hp;
    private Image exp;
    private int lastLvl = -1;
    private int lastKeys = -1;
    private BitmapText level;
    private BitmapText depth;
    private BitmapText keys;
    private DangerIndicator danger;
    private LootIndicator loot;
    private BuffIndicator buffs;
    private Compass compass;
    private MenuButton btnMenu;

    @Override
    protected void createChildren() {
        this.shield = new NinePatch("status_pane.png", 80, 0, 48, 0);
        this.add(this.shield);
        this.add(new TouchArea<GameAction>(0.0f, 1.0f, 30.0f, 30.0f){

            @Override
            protected void onClick(NoosaInputProcessor.Touch touch) {
                CharSprite sprite = Dungeon.hero.sprite;
                if (!sprite.isVisible()) {
                    Camera.main.focusOn(sprite);
                }
                GameScene.show(new WndHero());
            }

            @Override
            public boolean onKeyUp(NoosaInputProcessor.Key<GameAction> key) {
                boolean handled = true;
                switch ((GameAction)((Object)key.action)) {
                    case HERO_INFO: {
                        this.onClick(null);
                        break;
                    }
                    case CATALOGUS: {
                        GameScene.show(new WndCatalogus());
                        break;
                    }
                    case JOURNAL: {
                        GameScene.show(new WndJournal());
                        break;
                    }
                    default: {
                        handled = false;
                    }
                }
                return handled;
            }
        });
        this.btnMenu = new MenuButton();
        this.add(this.btnMenu);
        this.avatar = HeroSprite.avatar(Dungeon.hero.heroClass, this.lastTier);
        this.add(this.avatar);
        this.blood = new Emitter();
        this.blood.pos(this.avatar);
        this.blood.pour(BloodParticle.FACTORY, 0.3f);
        this.blood.autoKill = false;
        this.blood.on = false;
        this.add(this.blood);
        this.compass = new Compass(Dungeon.level.exit);
        this.add(this.compass);
        this.hp = new Image("hp_bar.png");
        this.add(this.hp);
        this.exp = new Image("exp_bar.png");
        this.add(this.exp);
        this.level = new BitmapText(PixelScene.font1x);
        this.level.hardlight(16772004);
        this.add(this.level);
        this.depth = new BitmapText(Integer.toString(Dungeon.depth), PixelScene.font1x);
        this.depth.hardlight(13291458);
        this.depth.measure();
        this.add(this.depth);
        Dungeon.hero.belongings.countIronKeys();
        this.keys = new BitmapText(PixelScene.font1x);
        this.keys.hardlight(13291458);
        this.add(this.keys);
        this.danger = new DangerIndicator();
        this.add(this.danger);
        this.loot = new LootIndicator();
        this.add(this.loot);
        this.buffs = new BuffIndicator(Dungeon.hero);
        this.add(this.buffs);
    }

    @Override
    protected void layout() {
        this.height = 32.0f;
        this.shield.size(this.width, this.shield.height);
        this.avatar.x = PixelScene.align(this.camera(), this.shield.x + 15.0f - this.avatar.width / 2.0f);
        this.avatar.y = PixelScene.align(this.camera(), this.shield.y + 16.0f - this.avatar.height / 2.0f);
        this.compass.x = this.avatar.x + this.avatar.width / 2.0f - this.compass.origin.x;
        this.compass.y = this.avatar.y + this.avatar.height / 2.0f - this.compass.origin.y;
        this.hp.x = 30.0f;
        this.hp.y = 3.0f;
        this.depth.x = this.width - 24.0f - this.depth.width() - 18.0f;
        this.depth.y = 6.0f;
        this.keys.y = 6.0f;
        this.danger.setPos(this.width - this.danger.width(), 20.0f);
        this.loot.setPos(this.width - this.loot.width(), this.danger.bottom() + 2.0f);
        this.buffs.setPos(32.0f, 11.0f);
        this.btnMenu.setPos(this.width - this.btnMenu.width(), 1.0f);
    }

    @Override
    public void update() {
        int tier;
        int k;
        super.update();
        float health = (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
        if (health == 0.0f) {
            this.avatar.tint(0, 0.6f);
            this.blood.on = false;
        } else if (health < 0.25f) {
            this.avatar.tint(0xCC0000, 0.4f);
            this.blood.on = true;
        } else {
            this.avatar.resetColor();
            this.blood.on = false;
        }
        this.hp.scale.x = health;
        this.exp.scale.x = this.width / this.exp.width * (float)Dungeon.hero.exp / (float)Dungeon.hero.maxExp();
        if (Dungeon.hero.lvl != this.lastLvl) {
            if (this.lastLvl != -1) {
                Emitter emitter = (Emitter)this.recycle(Emitter.class);
                emitter.revive();
                emitter.pos(27.0f, 27.0f);
                emitter.burst(Speck.factory(1), 12);
            }
            this.lastLvl = Dungeon.hero.lvl;
            this.level.text(Integer.toString(this.lastLvl));
            this.level.measure();
            this.level.x = PixelScene.align(27.0f - this.level.width() / 2.0f);
            this.level.y = PixelScene.align(27.5f - this.level.baseLine() / 2.0f);
        }
        if ((k = IronKey.curDepthQuantity) != this.lastKeys) {
            this.lastKeys = k;
            this.keys.text(Integer.toString(this.lastKeys));
            this.keys.measure();
            this.keys.x = this.width - 8.0f - this.keys.width() - 18.0f;
        }
        if ((tier = Dungeon.hero.tier()) != this.lastTier) {
            this.lastTier = tier;
            this.avatar.copy(HeroSprite.avatar(Dungeon.hero.heroClass, tier));
        }
    }

    private static class MenuButton
    extends Button {
        private Image image;

        public MenuButton() {
            this.width = this.image.width + 4.0f;
            this.height = this.image.height + 4.0f;
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.image = new Image("status_pane.png", 114, 3, 12, 11);
            this.add(this.image);
        }

        @Override
        protected void layout() {
            super.layout();
            this.image.x = this.x + 2.0f;
            this.image.y = this.y + 2.0f;
        }

        @Override
        protected void onTouchDown() {
            this.image.brightness(1.5f);
            Sample.INSTANCE.play("snd_click.mp3");
        }

        @Override
        protected void onTouchUp() {
            this.image.resetColor();
        }

        @Override
        protected void onClick() {
            GameScene.show(new WndGame());
        }

        @Override
        protected boolean onLongClick() {
            GameScene.show(new WndSettings(true));
            return true;
        }
    }
}

