/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Camera;
import com.watabou.noosa.TouchArea;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;

public class ScrollPane
extends Component {
    protected TouchController controller;
    protected Component content;
    protected float minX;
    protected float minY;
    protected float maxX;
    protected float maxY;

    public ScrollPane(Component content) {
        this.content = content;
        this.addToBack(content);
        this.width = content.width();
        this.height = content.height();
        content.camera = new Camera(0, 0, 1, 1, PixelScene.defaultZoom);
        Camera.add(content.camera);
    }

    @Override
    public void destroy() {
        super.destroy();
        Camera.remove(this.content.camera);
    }

    public void scrollTo(float x, float y) {
        this.content.camera.scroll.set(x, y);
    }

    @Override
    protected void createChildren() {
        this.controller = new TouchController();
        this.add(this.controller);
    }

    @Override
    protected void layout() {
        this.content.setPos(0.0f, 0.0f);
        this.controller.x = this.x;
        this.controller.y = this.y;
        this.controller.width = this.width;
        this.controller.height = this.height;
        Point p = this.camera().cameraToScreen(this.x, this.y);
        Camera cs = this.content.camera;
        cs.x = p.x;
        cs.y = p.y;
        cs.resize((int)this.width, (int)this.height);
    }

    public Component content() {
        return this.content;
    }

    public void onClick(float x, float y) {
    }

    public class TouchController
    extends TouchArea {
        private float dragThreshold;
        private boolean dragging;
        private PointF lastPos;

        public TouchController() {
            super(0.0f, 0.0f, 0.0f, 0.0f);
            this.dragging = false;
            this.lastPos = new PointF();
            this.dragThreshold = PixelScene.defaultZoom * 8.0f;
        }

        @Override
        protected void onClick(NoosaInputProcessor.Touch touch) {
            if (this.dragging) {
                this.dragging = false;
            } else {
                PointF p = ScrollPane.this.content.camera.screenToCamera((int)touch.current.x, (int)touch.current.y);
                ScrollPane.this.onClick(p.x, p.y);
            }
        }

        @Override
        protected void onDrag(NoosaInputProcessor.Touch t) {
            if (this.dragging) {
                this.doScroll(t.current);
            } else if (PointF.distance(t.current, t.start) > this.dragThreshold) {
                this.dragging = true;
                this.lastPos.set(t.current);
            }
        }

        @Override
        public boolean onMouseScroll(int scroll) {
            PointF newPt = new PointF(this.lastPos);
            newPt.y -= (float)scroll * ScrollPane.this.content.camera.zoom * 2.0f;
            this.doScroll(newPt);
            return true;
        }

        private void doScroll(PointF current) {
            Camera c = ScrollPane.this.content.camera;
            c.scroll.offset(PointF.diff(this.lastPos, current).invScale(c.zoom));
            if (c.scroll.x + this.width > ScrollPane.this.content.width()) {
                c.scroll.x = ScrollPane.this.content.width() - this.width;
            }
            if (c.scroll.x < 0.0f) {
                c.scroll.x = 0.0f;
            }
            if (c.scroll.y + this.height > ScrollPane.this.content.height()) {
                c.scroll.y = ScrollPane.this.content.height() - this.height;
            }
            if (c.scroll.y < 0.0f) {
                c.scroll.y = 0.0f;
            }
            this.lastPos.set(current);
        }
    }
}

