/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Button;
import com.watabou.pixeldungeon.Chrome;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.PixelScene;

public class RedButton
extends Button<GameAction> {
    protected NinePatch bg;
    protected BitmapText text;
    protected Image icon;

    public RedButton(String label) {
        this.text.text(label);
        this.text.measure();
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.bg = Chrome.get(Chrome.Type.BUTTON);
        this.add(this.bg);
        this.text = PixelScene.createText(9.0f);
        this.add(this.text);
    }

    @Override
    protected void layout() {
        super.layout();
        this.bg.x = this.x;
        this.bg.y = this.y;
        this.bg.size(this.width, this.height);
        this.text.x = this.x + (float)((int)(this.width - this.text.width()) / 2);
        this.text.y = this.y + (float)((int)(this.height - this.text.baseLine()) / 2);
        if (this.icon != null) {
            this.icon.x = this.x + this.text.x - this.icon.width() - 2.0f;
            this.icon.y = this.y + (this.height - this.icon.height()) / 2.0f;
        }
    }

    @Override
    protected void onTouchDown() {
        this.bg.brightness(1.2f);
        Sample.INSTANCE.play("snd_click.mp3");
    }

    @Override
    protected void onTouchUp() {
        this.bg.resetColor();
    }

    public void enable(boolean value) {
        this.active = value;
        this.text.alpha(value ? 1.0f : 0.3f);
    }

    public void text(String value) {
        this.text.text(value);
        this.text.measure();
        this.layout();
    }

    public void icon(Image icon) {
        if (this.icon != null) {
            this.remove(this.icon);
        }
        this.icon = icon;
        if (this.icon != null) {
            this.add(this.icon);
            this.layout();
        }
    }

    public float reqWidth() {
        return this.text.width() + 4.0f;
    }

    public float reqHeight() {
        return this.text.baseLine() + 4.0f;
    }
}

