/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.input.NoosaInputProcessor;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Button;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.HealthIndicator;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.ItemSlot;
import com.watabou.pixeldungeon.windows.WndBag;

public class QuickSlot
extends Button<GameAction>
implements WndBag.Listener {
    private static final String TXT_SELECT_ITEM = "Select an item for the quickslot";
    private static QuickSlot instance;
    private Item itemInSlot;
    private ItemSlot slot;
    private Image crossB;
    private Image crossM;
    private boolean targeting = false;
    private Item lastItem = null;
    private Char lastTarget = null;

    public QuickSlot() {
        this.hotKey = GameAction.QUICKSLOT;
        this.item(QuickSlot.select());
        instance = this;
    }

    @Override
    public void destroy() {
        super.destroy();
        instance = null;
        this.lastItem = null;
        this.lastTarget = null;
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.slot = new ItemSlot(){

            @Override
            protected void onClick() {
                if (NoosaInputProcessor.modifier) {
                    this.onLongClick();
                    return;
                }
                if (QuickSlot.this.targeting) {
                    GameScene.handleCell(((QuickSlot)QuickSlot.this).lastTarget.pos);
                } else {
                    Item item = QuickSlot.select();
                    if (item == QuickSlot.this.lastItem) {
                        QuickSlot.this.useTargeting();
                    } else {
                        QuickSlot.this.lastItem = item;
                    }
                    item.execute(Dungeon.hero);
                }
            }

            @Override
            protected boolean onLongClick() {
                return QuickSlot.this.onLongClick();
            }

            @Override
            protected void onTouchDown() {
                this.icon.lightness(0.7f);
            }

            @Override
            protected void onTouchUp() {
                this.icon.resetColor();
            }
        };
        this.slot.hotKey = GameAction.QUICKSLOT;
        this.add(this.slot);
        this.crossB = Icons.TARGET.get();
        this.crossB.visible = false;
        this.add(this.crossB);
        this.crossM = new Image();
        this.crossM.copy(this.crossB);
    }

    @Override
    protected void layout() {
        super.layout();
        this.slot.fill(this);
        this.crossB.x = PixelScene.align(this.x + (this.width - this.crossB.width) / 2.0f);
        this.crossB.y = PixelScene.align(this.y + (this.height - this.crossB.height) / 2.0f);
    }

    @Override
    protected void onClick() {
        GameScene.selectItem(this, WndBag.Mode.QUICKSLOT, TXT_SELECT_ITEM);
    }

    @Override
    protected boolean onLongClick() {
        this.onClick();
        return true;
    }

    private static Item select() {
        if (Dungeon.quickslot instanceof Item) {
            return (Item)Dungeon.quickslot;
        }
        if (Dungeon.quickslot != null) {
            Object item = Dungeon.hero.belongings.getItem((Class)Dungeon.quickslot);
            return item != null ? item : Item.virtual((Class)Dungeon.quickslot);
        }
        return null;
    }

    @Override
    public void onSelect(Item item) {
        if (item != null) {
            Dungeon.quickslot = item.stackable ? item.getClass() : item;
            QuickSlot.refresh();
        }
    }

    public void item(Item item) {
        this.slot.item(item);
        this.itemInSlot = item;
        this.enableSlot();
    }

    public void enable(boolean value) {
        this.active = value;
        if (value) {
            this.enableSlot();
        } else {
            this.slot.enable(false);
        }
    }

    private void enableSlot() {
        this.slot.enable(this.itemInSlot != null && this.itemInSlot.quantity() > 0 && (Dungeon.hero.belongings.backpack.contains(this.itemInSlot) || this.itemInSlot.isEquipped(Dungeon.hero)));
    }

    private void useTargeting() {
        boolean bl = this.targeting = this.lastTarget != null && this.lastTarget.isAlive() && Dungeon.visible[this.lastTarget.pos];
        if (this.targeting) {
            if (Actor.all().contains(this.lastTarget)) {
                this.lastTarget.sprite.parent.add(this.crossM);
                this.crossM.point(DungeonTilemap.tileToWorld(this.lastTarget.pos));
                this.crossB.visible = true;
            } else {
                this.lastTarget = null;
            }
        }
    }

    public static void refresh() {
        if (instance != null) {
            instance.item(QuickSlot.select());
        }
    }

    public static void target(Item item, Char target) {
        if (item == QuickSlot.instance.lastItem && target != Dungeon.hero) {
            QuickSlot.instance.lastTarget = target;
            HealthIndicator.instance.target(target);
        }
    }

    public static void cancel() {
        if (instance != null && QuickSlot.instance.targeting) {
            QuickSlot.instance.crossB.visible = false;
            QuickSlot.instance.crossM.remove();
            QuickSlot.instance.targeting = false;
        }
    }
}

