/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.ui.ItemSlot;
import com.watabou.pixeldungeon.ui.Tag;

public class LootIndicator
extends Tag {
    private ItemSlot slot;
    private Item lastItem = null;
    private int lastQuantity = 0;

    public LootIndicator() {
        super(2061772);
        this.setSize(24.0f, 22.0f);
        this.visible = false;
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.slot = new ItemSlot(){

            @Override
            protected void onClick() {
                Dungeon.hero.handle(Dungeon.hero.pos);
            }
        };
        this.slot.showParams(false);
        this.add(this.slot);
    }

    @Override
    protected void layout() {
        super.layout();
        this.slot.setRect(this.x + 2.0f, this.y + 3.0f, this.width - 2.0f, this.height - 6.0f);
    }

    @Override
    public void update() {
        if (Dungeon.hero.ready) {
            Heap heap = (Heap)Dungeon.level.heaps.get(Dungeon.hero.pos);
            if (heap != null) {
                Item item;
                Item item2 = heap.type == Heap.Type.CHEST ? ItemSlot.CHEST : (heap.type == Heap.Type.LOCKED_CHEST ? ItemSlot.LOCKED_CHEST : (heap.type == Heap.Type.TOMB ? ItemSlot.TOMB : (item = heap.type == Heap.Type.SKELETON ? ItemSlot.SKELETON : heap.peek())));
                if (item != this.lastItem || item.quantity() != this.lastQuantity) {
                    this.lastItem = item;
                    this.lastQuantity = item.quantity();
                    this.slot.item(item);
                    this.flash();
                }
                this.visible = true;
            } else {
                this.lastItem = null;
                this.visible = false;
            }
        }
        this.slot.enable(this.visible && Dungeon.hero.ready);
        super.update();
    }
}

