/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.sprites.CharSprite;

public class HealthIndicator
extends Component {
    private static final float HEIGHT = 2.0f;
    public static HealthIndicator instance;
    private Char target;
    private Image bg;
    private Image level;

    public HealthIndicator() {
        instance = this;
    }

    @Override
    protected void createChildren() {
        this.bg = new Image(TextureCache.createSolid(-3407872));
        this.bg.scale.y = 2.0f;
        this.add(this.bg);
        this.level = new Image(TextureCache.createSolid(-16724992));
        this.level.scale.y = 2.0f;
        this.add(this.level);
    }

    @Override
    public void update() {
        super.update();
        if (this.target != null && this.target.isAlive() && this.target.sprite.visible) {
            CharSprite sprite = this.target.sprite;
            this.bg.scale.x = sprite.width;
            this.level.scale.x = sprite.width * (float)this.target.HP / (float)this.target.HT;
            this.bg.x = this.level.x = sprite.x;
            this.bg.y = this.level.y = sprite.y - 2.0f - 1.0f;
            this.visible = true;
        } else {
            this.visible = false;
        }
    }

    public void target(Char ch) {
        this.target = ch != null && ch.isAlive() ? ch : null;
    }

    public Char target() {
        return this.target;
    }
}

