/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Game;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.scenes.PixelScene;

public class GoldIndicator
extends Component {
    private static final float TIME = 2.0f;
    private int lastValue = 0;
    private BitmapText tf;
    private float time;

    @Override
    protected void createChildren() {
        this.tf = new BitmapText(PixelScene.font1x);
        this.tf.hardlight(0xFFFF00);
        this.add(this.tf);
        this.visible = false;
    }

    @Override
    protected void layout() {
        this.tf.x = this.x + (this.width - this.tf.width()) / 2.0f;
        this.tf.y = this.bottom() - this.tf.height();
    }

    @Override
    public void update() {
        super.update();
        if (this.visible) {
            this.time -= Game.elapsed;
            if (this.time > 0.0f) {
                this.tf.alpha(this.time > 1.0f ? 1.0f : this.time * 2.0f / 2.0f);
            } else {
                this.visible = false;
            }
        }
        if (Dungeon.gold != this.lastValue) {
            this.lastValue = Dungeon.gold;
            this.tf.text(Integer.toString(this.lastValue));
            this.tf.measure();
            this.visible = true;
            this.time = 2.0f;
            this.layout();
        }
    }
}

