/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapTextMultiline;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Signal;
import java.util.regex.Pattern;

public class GameLog
extends Component
implements Signal.Listener<String> {
    private static final int MAX_MESSAGES = 3;
    private static final Pattern PUNCTUATION = Pattern.compile(".*[.,;?! ]$");
    private BitmapTextMultiline lastEntry;
    private int lastColor;

    public GameLog() {
        GLog.update.add(this);
        this.newLine();
    }

    public void newLine() {
        this.lastEntry = null;
    }

    @Override
    public void onSignal(String text) {
        int color = 0xFFFFFF;
        if (text.startsWith("++ ")) {
            text = text.substring("++ ".length());
            color = 65280;
        } else if (text.startsWith("-- ")) {
            text = text.substring("-- ".length());
            color = 0xFF0000;
        } else if (text.startsWith("** ")) {
            text = text.substring("** ".length());
            color = 0xFF8800;
        } else if (text.startsWith("@@ ")) {
            text = text.substring("@@ ".length());
            color = 0xFFFF00;
        }
        text = Utils.capitalize(text) + (PUNCTUATION.matcher(text).matches() ? "" : ".");
        if (this.lastEntry != null && color == this.lastColor) {
            String lastMessage = this.lastEntry.text();
            if (lastMessage.length() == 0) {
                this.lastEntry.text(text);
            } else {
                this.lastEntry.text(lastMessage, text);
            }
            this.lastEntry.measure();
        } else {
            this.lastEntry = PixelScene.createMultiline(text, 6.0f);
            this.lastEntry.maxWidth = (int)this.width;
            this.lastEntry.measure();
            this.lastEntry.hardlight(color);
            this.lastColor = color;
            this.add(this.lastEntry);
        }
        if (this.length > 3) {
            this.remove((Gizmo)this.members.get(0));
        }
        this.layout();
    }

    @Override
    protected void layout() {
        float pos = this.y;
        for (int i = this.length - 1; i >= 0; --i) {
            BitmapTextMultiline entry = (BitmapTextMultiline)this.members.get(i);
            entry.x = this.x;
            entry.y = pos - entry.height();
            pos -= entry.height();
        }
    }

    @Override
    public void destroy() {
        GLog.update.remove(this);
        super.destroy();
    }
}

