/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.HealthIndicator;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.Tag;

public class DangerIndicator
extends Tag {
    public static final int COLOR = 0xFF4C4C;
    private BitmapText number;
    private Image icon;
    private int enemyIndex = 0;
    private int lastNumber = -1;

    public DangerIndicator() {
        super(0xFF4C4C);
        this.hotKey = GameAction.TAG_DANGER;
        this.setSize(24.0f, 16.0f);
        this.visible = false;
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.number = new BitmapText(PixelScene.font1x);
        this.add(this.number);
        this.icon = Icons.SKULL.get();
        this.add(this.icon);
    }

    @Override
    protected void layout() {
        super.layout();
        this.icon.x = this.right() - 10.0f;
        this.icon.y = this.y + (this.height - this.icon.height) / 2.0f;
        this.placeNumber();
    }

    private void placeNumber() {
        this.number.x = this.right() - 11.0f - this.number.width();
        this.number.y = PixelScene.align(this.y + (this.height - this.number.baseLine()) / 2.0f);
    }

    @Override
    public void update() {
        if (Dungeon.hero.isAlive()) {
            int v = Dungeon.hero.visibleEnemies();
            if (v != this.lastNumber) {
                this.lastNumber = v;
                this.visible = this.lastNumber > 0;
                if (this.visible) {
                    this.number.text(Integer.toString(this.lastNumber));
                    this.number.measure();
                    this.placeNumber();
                    this.flash();
                }
            }
        } else {
            this.visible = false;
        }
        super.update();
    }

    @Override
    protected void onClick() {
        if (this.visible) {
            Mob target;
            HealthIndicator.instance.target((target = Dungeon.hero.visibleEnemy(this.enemyIndex++)) == HealthIndicator.instance.target() ? null : target);
            Camera.main.target = null;
            Camera.main.focusOn(target.sprite);
        }
    }
}

