/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.Icons;
import com.watabou.pixeldungeon.ui.RedButton;

public class CheckBox
extends RedButton {
    private boolean checked = false;

    public CheckBox(String label) {
        super(label);
        this.icon(Icons.get(Icons.UNCHECKED));
    }

    @Override
    protected void layout() {
        super.layout();
        float margin = (this.height - this.text.baseLine()) / 2.0f;
        this.text.x = PixelScene.align(PixelScene.uiCamera, this.x + margin);
        this.text.y = PixelScene.align(PixelScene.uiCamera, this.y + margin);
        this.icon.x = PixelScene.align(PixelScene.uiCamera, this.x + this.width - margin - this.icon.width);
        this.icon.y = PixelScene.align(PixelScene.uiCamera, this.y + (this.height - this.icon.height()) / 2.0f);
    }

    public boolean checked() {
        return this.checked;
    }

    public void checked(boolean value) {
        if (this.checked != value) {
            this.checked = value;
            this.icon.copy(Icons.get(this.checked ? Icons.CHECKED : Icons.UNCHECKED));
        }
    }

    @Override
    protected void onClick() {
        super.onClick();
        this.checked(!this.checked);
    }
}

