/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Image;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.utils.SparseArray;

public class BuffIndicator
extends Component {
    public static final int NONE = -1;
    public static final int MIND_VISION = 0;
    public static final int LEVITATION = 1;
    public static final int FIRE = 2;
    public static final int POISON = 3;
    public static final int PARALYSIS = 4;
    public static final int HUNGER = 5;
    public static final int STARVATION = 6;
    public static final int SLOW = 7;
    public static final int OOZE = 8;
    public static final int AMOK = 9;
    public static final int TERROR = 10;
    public static final int ROOTS = 11;
    public static final int INVISIBLE = 12;
    public static final int SHADOWS = 13;
    public static final int WEAKNESS = 14;
    public static final int FROST = 15;
    public static final int BLINDNESS = 16;
    public static final int COMBO = 17;
    public static final int FURY = 18;
    public static final int HEALING = 19;
    public static final int ARMOR = 20;
    public static final int HEART = 21;
    public static final int LIGHT = 22;
    public static final int CRIPPLE = 23;
    public static final int BARKSKIN = 24;
    public static final int IMMUNITY = 25;
    public static final int BLEEDING = 26;
    public static final int MARK = 27;
    public static final int DEFERRED = 28;
    public static final int VERTIGO = 29;
    public static final int SIZE = 7;
    private static BuffIndicator heroInstance;
    private SmartTexture texture;
    private TextureFilm film;
    private SparseArray<Image> icons = new SparseArray();
    private Char ch;

    public BuffIndicator(Char ch) {
        this.ch = ch;
        if (ch == Dungeon.hero) {
            heroInstance = this;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this == heroInstance) {
            heroInstance = null;
        }
    }

    @Override
    protected void createChildren() {
        this.texture = TextureCache.get("buffs.png");
        this.film = new TextureFilm(this.texture, 7, 7);
    }

    @Override
    protected void layout() {
        this.clear();
        SparseArray newIcons = new SparseArray();
        for (Buff buff : this.ch.buffs()) {
            int icon = buff.icon();
            if (icon == -1) continue;
            Image img = new Image(this.texture);
            img.frame(this.film.get(icon));
            img.x = this.x + (float)(this.members.size() * 9);
            img.y = this.y;
            this.add(img);
            newIcons.put(icon, img);
        }
        int[] arr$ = this.icons.keyArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer key = arr$[i$];
            if (newIcons.get(key) != null) continue;
            Image icon = (Image)this.icons.get(key);
            icon.origin.set(3.0f);
            this.add(icon);
            this.add(new AlphaTweener(icon, 0.0f, 0.6f){

                @Override
                protected void updateValues(float progress) {
                    super.updateValues(progress);
                    this.image.scale.set(1.0f + 5.0f * progress);
                }
            });
        }
        this.icons = newIcons;
    }

    public static void refreshHero() {
        if (heroInstance != null) {
            heroInstance.layout();
        }
    }
}

