/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Component;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.effects.BadgeBanner;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.ui.ScrollPane;
import com.watabou.pixeldungeon.windows.WndBadge;
import java.util.ArrayList;

public class BadgesList
extends ScrollPane {
    private ArrayList<ListItem> items = new ArrayList();

    public BadgesList(boolean global) {
        super(new Component());
        for (Badges.Badge badge : Badges.filtered(global)) {
            if (badge.image == -1) continue;
            ListItem item = new ListItem(badge);
            this.content.add(item);
            this.items.add(item);
        }
    }

    @Override
    protected void layout() {
        super.layout();
        float pos = 0.0f;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            this.items.get(i).setRect(0.0f, pos, this.width, 20.0f);
            pos += 20.0f;
        }
        this.content.setSize(this.width, pos);
    }

    @Override
    public void onClick(float x, float y) {
        int size = this.items.size();
        for (int i = 0; i < size && !this.items.get(i).onClick(x, y); ++i) {
        }
    }

    private class ListItem
    extends Component {
        private static final float HEIGHT = 20.0f;
        private Badges.Badge badge;
        private Image icon;
        private BitmapText label;

        public ListItem(Badges.Badge badge) {
            this.badge = badge;
            this.icon.copy(BadgeBanner.image(badge.image));
            this.label.text(badge.description);
        }

        @Override
        protected void createChildren() {
            this.icon = new Image();
            this.add(this.icon);
            this.label = PixelScene.createText(6.0f);
            this.add(this.label);
        }

        @Override
        protected void layout() {
            this.icon.x = this.x;
            this.icon.y = PixelScene.align(this.y + (this.height - this.icon.height) / 2.0f);
            this.label.x = this.icon.x + this.icon.width + 2.0f;
            this.label.y = PixelScene.align(this.y + (this.height - this.label.baseLine()) / 2.0f);
        }

        public boolean onClick(float x, float y) {
            if (this.inside(x, y)) {
                Sample.INSTANCE.play("snd_click.mp3", 0.7f, 0.7f, 1.2f);
                Game.scene().add(new WndBadge(this.badge));
                return true;
            }
            return false;
        }
    }
}

