/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.ui;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.input.GameAction;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.pixeldungeon.sprites.CharSprite;
import com.watabou.pixeldungeon.ui.HealthIndicator;
import com.watabou.pixeldungeon.ui.Tag;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class AttackIndicator
extends Tag {
    private static final float ENABLED = 1.0f;
    private static final float DISABLED = 0.3f;
    private static AttackIndicator instance;
    private CharSprite sprite = null;
    private static Mob lastTarget;
    private ArrayList<Mob> candidates = new ArrayList();
    private boolean enabled = true;

    public AttackIndicator() {
        super(0xFF4C4C);
        instance = this;
        this.hotKey = GameAction.TAG_ATTACK;
        this.setSize(24.0f, 24.0f);
        this.visible(false);
        this.enable(false);
    }

    @Override
    protected void createChildren() {
        super.createChildren();
    }

    @Override
    protected void layout() {
        super.layout();
        if (this.sprite != null) {
            this.sprite.x = this.x + (this.width - this.sprite.width()) / 2.0f;
            this.sprite.y = this.y + (this.height - this.sprite.height()) / 2.0f;
            PixelScene.align(this.sprite);
        }
    }

    @Override
    public void update() {
        super.update();
        if (Dungeon.hero.isAlive()) {
            if (!Dungeon.hero.ready) {
                this.enable(false);
            }
        } else {
            this.visible(false);
            this.enable(false);
        }
    }

    private void checkEnemies() {
        int heroPos = Dungeon.hero.pos;
        this.candidates.clear();
        int v = Dungeon.hero.visibleEnemies();
        for (int i = 0; i < v; ++i) {
            Mob mob = Dungeon.hero.visibleEnemy(i);
            if (!Level.adjacent(heroPos, mob.pos)) continue;
            this.candidates.add(mob);
        }
        if (!this.candidates.contains(lastTarget)) {
            if (this.candidates.isEmpty()) {
                lastTarget = null;
            } else {
                lastTarget = Random.element(this.candidates);
                this.updateImage();
                this.flash();
            }
        } else if (!this.bg.visible) {
            this.flash();
        }
        this.visible(lastTarget != null);
        this.enable(this.bg.visible);
    }

    private void updateImage() {
        if (this.sprite != null) {
            this.sprite.killAndErase();
            this.sprite = null;
        }
        try {
            this.sprite = ClassReflection.newInstance(AttackIndicator.lastTarget.spriteClass);
            this.sprite.idle();
            this.sprite.paused = true;
            this.add(this.sprite);
            this.sprite.x = this.x + (this.width - this.sprite.width()) / 2.0f + 1.0f;
            this.sprite.y = this.y + (this.height - this.sprite.height()) / 2.0f;
            PixelScene.align(this.sprite);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enable(boolean value) {
        this.enabled = value;
        if (this.sprite != null) {
            this.sprite.alpha(value ? 1.0f : 0.3f);
        }
    }

    private void visible(boolean value) {
        this.bg.visible = value;
        if (this.sprite != null) {
            this.sprite.visible = value;
        }
    }

    @Override
    protected void onClick() {
        if (this.enabled) {
            Dungeon.hero.handle(AttackIndicator.lastTarget.pos);
        }
    }

    public static void target(Char target) {
        lastTarget = (Mob)target;
        instance.updateImage();
        HealthIndicator.instance.target(target);
    }

    public static void updateState() {
        instance.checkEnemies();
    }

    static {
        lastTarget = null;
    }
}

