/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.Game;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.effects.Halo;
import com.watabou.pixeldungeon.effects.particles.ElmoParticle;
import com.watabou.pixeldungeon.sprites.MobSprite;
import com.watabou.utils.PointF;

public class WandmakerSprite
extends MobSprite {
    private Shield shield;

    public WandmakerSprite() {
        this.texture("wandmaker.png");
        TextureFilm frames = new TextureFilm(this.texture, 12, 14);
        this.idle = new MovieClip.Animation(10, true);
        this.idle.frames(frames, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 3, 3, 2, 1);
        this.run = new MovieClip.Animation(20, true);
        this.run.frames(frames, 0);
        this.die = new MovieClip.Animation(20, false);
        this.die.frames(frames, 0);
        this.play(this.idle);
    }

    @Override
    public void link(Char ch) {
        super.link(ch);
        if (this.shield == null) {
            this.shield = new Shield();
            this.parent.add(this.shield);
        }
    }

    @Override
    public void die() {
        super.die();
        if (this.shield != null) {
            this.shield.putOut();
        }
        this.emitter().start(ElmoParticle.FACTORY, 0.03f, 60);
    }

    public class Shield
    extends Halo {
        private float phase;

        public Shield() {
            super(14.0f, 0xBBAACC, 1.0f);
            this.am = -1.0f;
            this.aa = 1.0f;
            this.phase = 1.0f;
        }

        @Override
        public void update() {
            super.update();
            if (this.phase < 1.0f) {
                float f;
                this.phase -= Game.elapsed;
                if (f <= 0.0f) {
                    this.killAndErase();
                } else {
                    this.scale.set((2.0f - this.phase) * this.radius / 64.0f);
                    this.am = this.phase * -1.0f;
                    this.aa = this.phase * 1.0f;
                }
            }
            if (this.visible = WandmakerSprite.this.visible) {
                PointF p = WandmakerSprite.this.center();
                this.point(p.x, p.y);
            }
        }

        @Override
        public void draw() {
            Gdx.gl.glBlendFunc(770, 1);
            super.draw();
            Gdx.gl.glBlendFunc(770, 771);
        }

        public void putOut() {
            this.phase = 0.999f;
        }
    }
}

