/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.pixeldungeon.items.weapon.missiles.Shuriken;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.MissileSprite;
import com.watabou.pixeldungeon.sprites.MobSprite;
import com.watabou.utils.Callback;

public class TenguSprite
extends MobSprite {
    private MovieClip.Animation cast;

    public TenguSprite() {
        this.texture("tengu.png");
        TextureFilm frames = new TextureFilm(this.texture, 14, 16);
        this.idle = new MovieClip.Animation(2, true);
        this.idle.frames(frames, 0, 0, 0, 1);
        this.run = new MovieClip.Animation(15, false);
        this.run.frames(frames, 2, 3, 4, 5, 0);
        this.attack = new MovieClip.Animation(15, false);
        this.attack.frames(frames, 6, 7, 7, 0);
        this.cast = this.attack.clone();
        this.die = new MovieClip.Animation(8, false);
        this.die.frames(frames, 8, 9, 10, 10, 10, 10, 10, 10);
        this.play(this.run.clone());
    }

    @Override
    public void move(int from, int to) {
        this.place(to);
        this.play(this.run);
        this.turnTo(from, to);
        this.isMoving = true;
        if (Level.water[to]) {
            GameScene.ripple(to);
        }
        this.ch.onMotionComplete();
    }

    @Override
    public void attack(int cell) {
        if (!Level.adjacent(cell, this.ch.pos)) {
            ((MissileSprite)this.parent.recycle(MissileSprite.class)).reset(this.ch.pos, cell, new Shuriken(), new Callback(){

                @Override
                public void call() {
                    TenguSprite.this.ch.onAttackComplete();
                }
            });
            this.play(this.cast);
            this.turnTo(this.ch.pos, cell);
        } else {
            super.attack(cell);
        }
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.run) {
            this.isMoving = false;
            this.idle();
        } else {
            super.onComplete(anim);
        }
    }
}

