/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.sprites;

import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.pixeldungeon.items.weapon.missiles.Dart;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.sprites.MissileSprite;
import com.watabou.pixeldungeon.sprites.MobSprite;
import com.watabou.utils.Callback;

public class ScorpioSprite
extends MobSprite {
    private int cellToAttack;

    public ScorpioSprite() {
        this.texture("scorpio.png");
        TextureFilm frames = new TextureFilm(this.texture, 18, 17);
        this.idle = new MovieClip.Animation(12, true);
        this.idle.frames(frames, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 1, 2);
        this.run = new MovieClip.Animation(8, true);
        this.run.frames(frames, 5, 5, 6, 6);
        this.attack = new MovieClip.Animation(15, false);
        this.attack.frames(frames, 0, 3, 4);
        this.zap = this.attack.clone();
        this.die = new MovieClip.Animation(12, false);
        this.die.frames(frames, 0, 7, 8, 9, 10);
        this.play(this.idle);
    }

    @Override
    public int blood() {
        return -12255454;
    }

    @Override
    public void attack(int cell) {
        if (!Level.adjacent(cell, this.ch.pos)) {
            this.cellToAttack = cell;
            this.turnTo(this.ch.pos, cell);
            this.play(this.zap);
        } else {
            super.attack(cell);
        }
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.zap) {
            this.idle();
            ((MissileSprite)this.parent.recycle(MissileSprite.class)).reset(this.ch.pos, this.cellToAttack, new Dart(), new Callback(){

                @Override
                public void call() {
                    ScorpioSprite.this.ch.onAttackComplete();
                }
            });
        } else {
            super.onComplete(anim);
        }
    }
}

